/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.computer.clustering.peerpressure;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration2.Configuration;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.computer.MemoryComputeKey;
import org.apache.tinkerpop.gremlin.process.computer.MessageScope;
import org.apache.tinkerpop.gremlin.process.computer.Messenger;
import org.apache.tinkerpop.gremlin.process.computer.VertexComputeKey;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;
import org.apache.tinkerpop.gremlin.process.computer.util.AbstractVertexProgramBuilder;
import org.apache.tinkerpop.gremlin.process.computer.util.StaticVertexProgram;
import org.apache.tinkerpop.gremlin.process.traversal.Operator;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.MapHelper;
import org.apache.tinkerpop.gremlin.process.traversal.util.PureTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.javatuples.Pair;

public class PeerPressureVertexProgram
extends StaticVertexProgram<Pair<Serializable, Double>> {
    private MessageScope.Local<?> voteScope = MessageScope.Local.of(() -> __.outE(new String[0]));
    private MessageScope.Local<?> countScope = MessageScope.Local.of(new MessageScope.Local.ReverseTraversalSupplier(this.voteScope));
    public static final String CLUSTER = "gremlin.peerPressureVertexProgram.cluster";
    private static final String VOTE_STRENGTH = "gremlin.peerPressureVertexProgram.voteStrength";
    private static final String INITIAL_VOTE_STRENGTH_TRAVERSAL = "gremlin.pageRankVertexProgram.initialVoteStrengthTraversal";
    private static final String PROPERTY = "gremlin.peerPressureVertexProgram.property";
    private static final String MAX_ITERATIONS = "gremlin.peerPressureVertexProgram.maxIterations";
    private static final String DISTRIBUTE_VOTE = "gremlin.peerPressureVertexProgram.distributeVote";
    private static final String EDGE_TRAVERSAL = "gremlin.peerPressureVertexProgram.edgeTraversal";
    private static final String VOTE_TO_HALT = "gremlin.peerPressureVertexProgram.voteToHalt";
    private PureTraversal<Vertex, Edge> edgeTraversal = null;
    private PureTraversal<Vertex, ? extends Number> initialVoteStrengthTraversal = null;
    private int maxIterations = 30;
    private boolean distributeVote = false;
    private String property = "gremlin.peerPressureVertexProgram.cluster";
    private static final Set<MemoryComputeKey> MEMORY_COMPUTE_KEYS = Collections.singleton(MemoryComputeKey.of("gremlin.peerPressureVertexProgram.voteToHalt", Operator.and, false, true));

    private PeerPressureVertexProgram() {
    }

    @Override
    public void loadState(Graph graph, Configuration configuration) {
        if (configuration.containsKey(INITIAL_VOTE_STRENGTH_TRAVERSAL)) {
            this.initialVoteStrengthTraversal = PureTraversal.loadState(configuration, INITIAL_VOTE_STRENGTH_TRAVERSAL, graph);
        }
        if (configuration.containsKey(EDGE_TRAVERSAL)) {
            this.edgeTraversal = PureTraversal.loadState(configuration, EDGE_TRAVERSAL, graph);
            this.voteScope = MessageScope.Local.of(() -> this.edgeTraversal.get().clone());
            this.countScope = MessageScope.Local.of(new MessageScope.Local.ReverseTraversalSupplier(this.voteScope));
        }
        this.property = configuration.getString(PROPERTY, CLUSTER);
        this.maxIterations = configuration.getInt(MAX_ITERATIONS, 30);
        this.distributeVote = configuration.getBoolean(DISTRIBUTE_VOTE, false);
    }

    @Override
    public void storeState(Configuration configuration) {
        super.storeState(configuration);
        configuration.setProperty(PROPERTY, (Object)this.property);
        configuration.setProperty(MAX_ITERATIONS, (Object)this.maxIterations);
        configuration.setProperty(DISTRIBUTE_VOTE, (Object)this.distributeVote);
        if (null != this.edgeTraversal) {
            this.edgeTraversal.storeState(configuration, EDGE_TRAVERSAL);
        }
        if (null != this.initialVoteStrengthTraversal) {
            this.initialVoteStrengthTraversal.storeState(configuration, INITIAL_VOTE_STRENGTH_TRAVERSAL);
        }
    }

    @Override
    public Set<VertexComputeKey> getVertexComputeKeys() {
        return new HashSet<VertexComputeKey>(Arrays.asList(VertexComputeKey.of(this.property, false), VertexComputeKey.of(VOTE_STRENGTH, true)));
    }

    @Override
    public Set<MemoryComputeKey> getMemoryComputeKeys() {
        return MEMORY_COMPUTE_KEYS;
    }

    @Override
    public Set<MessageScope> getMessageScopes(Memory memory) {
        HashSet<MessageScope> VOTE_SCOPE = new HashSet<MessageScope>(Collections.singletonList(this.voteScope));
        HashSet COUNT_SCOPE = new HashSet(Collections.singletonList(this.countScope));
        return this.distributeVote && memory.isInitialIteration() ? COUNT_SCOPE : VOTE_SCOPE;
    }

    @Override
    public GraphComputer.ResultGraph getPreferredResultGraph() {
        return GraphComputer.ResultGraph.NEW;
    }

    @Override
    public GraphComputer.Persist getPreferredPersist() {
        return GraphComputer.Persist.VERTEX_PROPERTIES;
    }

    @Override
    public void setup(Memory memory) {
        memory.set(VOTE_TO_HALT, false);
    }

    @Override
    public void execute(Vertex vertex, Messenger<Pair<Serializable, Double>> messenger, Memory memory) {
        if (memory.isInitialIteration()) {
            if (this.distributeVote) {
                messenger.sendMessage(this.countScope, (Pair<Serializable, Double>)Pair.with((Object)Character.valueOf('c'), (Object)1.0));
            } else {
                double voteStrength = null == this.initialVoteStrengthTraversal ? 1.0 : TraversalUtil.apply(vertex, this.initialVoteStrengthTraversal.get()).doubleValue();
                vertex.property(VertexProperty.Cardinality.single, this.property, vertex.id(), new Object[0]);
                vertex.property(VertexProperty.Cardinality.single, VOTE_STRENGTH, voteStrength, new Object[0]);
                messenger.sendMessage(this.voteScope, (Pair<Serializable, Double>)new Pair((Object)((Serializable)vertex.id()), (Object)voteStrength));
                memory.add(VOTE_TO_HALT, false);
            }
        } else if (1 == memory.getIteration() && this.distributeVote) {
            double voteStrength = (null == this.initialVoteStrengthTraversal ? 1.0 : TraversalUtil.apply(vertex, this.initialVoteStrengthTraversal.get()).doubleValue()) / IteratorUtils.reduce(IteratorUtils.map(messenger.receiveMessages(), Pair::getValue1), Double.valueOf(0.0), (a, b) -> a + b);
            vertex.property(VertexProperty.Cardinality.single, this.property, vertex.id(), new Object[0]);
            vertex.property(VertexProperty.Cardinality.single, VOTE_STRENGTH, voteStrength, new Object[0]);
            messenger.sendMessage(this.voteScope, (Pair<Serializable, Double>)new Pair((Object)((Serializable)vertex.id()), (Object)voteStrength));
            memory.add(VOTE_TO_HALT, false);
        } else {
            HashMap votes = new HashMap();
            votes.put(vertex.value(this.property), vertex.value(VOTE_STRENGTH));
            messenger.receiveMessages().forEachRemaining(message -> MapHelper.incr(votes, message.getValue0(), (Double)message.getValue1()));
            Serializable cluster = (Serializable)PeerPressureVertexProgram.largestCount(votes);
            if (null == cluster) {
                cluster = (Serializable)vertex.id();
            }
            memory.add(VOTE_TO_HALT, vertex.value(this.property).equals(cluster));
            vertex.property(VertexProperty.Cardinality.single, this.property, cluster, new Object[0]);
            messenger.sendMessage(this.voteScope, (Pair<Serializable, Double>)new Pair((Object)cluster, vertex.value(VOTE_STRENGTH)));
        }
    }

    @Override
    public boolean terminate(Memory memory) {
        boolean voteToHalt;
        boolean bl = (Boolean)memory.get(VOTE_TO_HALT) != false || memory.getIteration() >= (this.distributeVote ? this.maxIterations + 1 : this.maxIterations) ? true : (voteToHalt = false);
        if (voteToHalt) {
            return true;
        }
        memory.set(VOTE_TO_HALT, true);
        return false;
    }

    private static <T> T largestCount(Map<T, Double> map) {
        Object largestKey = null;
        double largestValue = Double.MIN_VALUE;
        for (Map.Entry<T, Double> entry : map.entrySet()) {
            if (entry.getValue() == largestValue) {
                if (null == largestKey || largestKey.toString().compareTo(entry.getKey().toString()) <= 0) continue;
                largestKey = entry.getKey();
                largestValue = entry.getValue();
                continue;
            }
            if (!(entry.getValue() > largestValue)) continue;
            largestKey = entry.getKey();
            largestValue = entry.getValue();
        }
        return (T)largestKey;
    }

    public String toString() {
        return StringFactory.vertexProgramString(this, "distributeVote=" + this.distributeVote + ", maxIterations=" + this.maxIterations);
    }

    public static Builder build() {
        return new Builder();
    }

    @Override
    public VertexProgram.Features getFeatures() {
        return new VertexProgram.Features(){

            @Override
            public boolean requiresLocalMessageScopes() {
                return true;
            }

            @Override
            public boolean requiresVertexPropertyAddition() {
                return true;
            }
        };
    }

    public static final class Builder
    extends AbstractVertexProgramBuilder<Builder> {
        private Builder() {
            super(PeerPressureVertexProgram.class);
        }

        public Builder property(String key) {
            this.configuration.setProperty(PeerPressureVertexProgram.PROPERTY, (Object)key);
            return this;
        }

        public Builder maxIterations(int iterations) {
            this.configuration.setProperty(PeerPressureVertexProgram.MAX_ITERATIONS, (Object)iterations);
            return this;
        }

        public Builder distributeVote(boolean distributeVote) {
            this.configuration.setProperty(PeerPressureVertexProgram.DISTRIBUTE_VOTE, (Object)distributeVote);
            return this;
        }

        public Builder edges(Traversal.Admin<Vertex, Edge> edgeTraversal) {
            PureTraversal.storeState((Configuration)this.configuration, PeerPressureVertexProgram.EDGE_TRAVERSAL, edgeTraversal);
            return this;
        }

        public Builder initialVoteStrength(Traversal.Admin<Vertex, ? extends Number> initialVoteStrengthTraversal) {
            PureTraversal.storeState((Configuration)this.configuration, PeerPressureVertexProgram.INITIAL_VOTE_STRENGTH_TRAVERSAL, initialVoteStrengthTraversal);
            return this;
        }
    }
}

