/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc.linked;

import com.google.common.primitives.Ints;
import java.util.Random;
import org.caffinitas.ohc.linked.Uns;
import org.caffinitas.ohc.linked.Util;

final class FrequencySketch {
    private static final long[] SEED = new long[]{-4348849565147123417L, -5435081209227447693L, -7286425919675154353L, -3750763034362895579L};
    private static final long RESET_MASK = 0x7777777777777777L;
    private static final long ONE_MASK = 0x1111111111111111L;
    final int sampleSize;
    final int tableMask;
    long tableOffset;
    final int tableLength;
    int size;
    private Random random = new Random();
    private long seed = this.random.nextLong();
    private int reseed;

    FrequencySketch(long maximumSize) {
        if (maximumSize <= 0L) {
            throw new IllegalArgumentException("maximumSize must be greater than 0");
        }
        int maximum = (int)Math.min(maximumSize, 0x3FFFFFFFL);
        this.tableLength = maximum == 0 ? 1 : Ints.checkedCast((long)Util.roundUpToPowerOf2(maximum, 0x40000000L));
        this.tableOffset = Uns.allocate(8 * this.tableLength, true);
        Uns.setMemory(this.tableOffset, 0L, 8 * this.tableLength, (byte)0);
        this.tableMask = Math.max(0, this.tableLength - 1);
        this.sampleSize = maximum <= 0 ? Integer.MAX_VALUE : 10 * maximum;
        this.size = 0;
    }

    void release() {
        if (this.tableOffset != 0L) {
            Uns.free(this.tableOffset);
        }
        this.tableOffset = 0L;
    }

    private long tableAt(int i) {
        return Uns.getLong(this.tableOffset, i * 8);
    }

    private void tableAt(int i, long val) {
        Uns.putLong(this.tableOffset, i * 8, val);
    }

    int frequency(long hash) {
        long start = (hash & 3L) << 2;
        int frequency = this.countOf(start, 0, this.indexOf(hash, 0));
        frequency = Math.min(frequency, this.countOf(start, 1, this.indexOf(hash, 1)));
        frequency = Math.min(frequency, this.countOf(start, 2, this.indexOf(hash, 2)));
        return Math.min(frequency, this.countOf(start, 3, this.indexOf(hash, 3)));
    }

    private int countOf(long start, int i, int index) {
        return (int)(this.tableAt(index) >>> (int)(start + (long)i << 2) & 0xFL);
    }

    int indexOf(long item, int i) {
        return (int)(SEED[i] * item) & this.tableMask;
    }

    void increment(long hash) {
        int start = (int)((hash & 3L) << 2);
        boolean added = this.incrementAt(this.indexOf(hash, 0), start) | this.incrementAt(this.indexOf(hash, 1), start + 1) | this.incrementAt(this.indexOf(hash, 2), start + 2) | this.incrementAt(this.indexOf(hash, 3), start + 3);
        if (added && ++this.size == this.sampleSize) {
            this.reset();
        }
    }

    private boolean incrementAt(int i, int j) {
        int offset = j << 2;
        long mask = 15L << offset;
        long t = this.tableAt(i);
        if ((t & mask) != mask) {
            this.tableAt(i, t + (1L << offset));
            return true;
        }
        return false;
    }

    private void reset() {
        int count = 0;
        for (int i = 0; i < this.tableLength; ++i) {
            long t = this.tableAt(i);
            count += Long.bitCount(t & 0x1111111111111111L);
            this.tableAt(i, t >>> 1 & 0x7777777777777777L);
        }
        this.size = (this.size >>> 1) - (count >>> 2);
    }

    boolean tieAdmit() {
        if (++this.reseed == 32) {
            this.rollover();
        }
        long seed = this.seed;
        seed ^= seed >> 12;
        seed ^= seed << 25;
        seed ^= seed >> 27;
        this.seed = seed;
        long random = seed * 2685821657736338717L;
        return (random & 0x7FL) == 0L;
    }

    private void rollover() {
        this.reseed = 0;
        this.random.setSeed(this.seed);
        this.seed = this.random.nextLong();
    }
}

