/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc.linked;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.caffinitas.ohc.linked.Uns;
import org.caffinitas.ohc.linked.Util;
import org.caffinitas.ohc.util.ByteBufferCompat;
import org.xerial.snappy.Snappy;

final class DecompressingInputChannel
implements ReadableByteChannel {
    private final ReadableByteChannel delegate;
    private final long compressedAddress;
    private ByteBuffer compressedBuffer;
    private ByteBuffer decompressedBuffer;
    private boolean closed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DecompressingInputChannel(ReadableByteChannel delegate) throws IOException {
        int maxCLen;
        int bufferSize;
        long headerAdr = Uns.allocateIOException(16L);
        try {
            ByteBuffer header = Uns.directBufferFor(headerAdr, 0L, 16L, false);
            if (!Util.readFully(delegate, header)) {
                throw new EOFException("Could not read file header");
            }
            ByteBufferCompat.byteBufferFlip(header);
            int magic = header.getInt();
            if (magic == 1128482895) {
                throw new IOException("File from instance with different CPU architecture cannot be loaded");
            }
            if (magic != 1330135875) {
                throw new IOException("Illegal file header");
            }
            if (header.getInt() != 1) {
                throw new IOException("Illegal file version");
            }
            bufferSize = header.getInt();
            maxCLen = header.getInt();
        }
        finally {
            Uns.free(headerAdr);
        }
        this.delegate = delegate;
        this.compressedAddress = Uns.allocateIOException(maxCLen + bufferSize);
        this.compressedBuffer = Uns.directBufferFor(this.compressedAddress, 0L, maxCLen, false);
        ByteBufferCompat.byteBufferPosition(this.compressedBuffer, this.compressedBuffer.limit());
        this.decompressedBuffer = Uns.directBufferFor(this.compressedAddress, maxCLen, bufferSize, false);
        ByteBufferCompat.byteBufferPosition(this.decompressedBuffer, this.decompressedBuffer.limit());
    }

    @Override
    public void close() {
        if (this.compressedBuffer == null) {
            return;
        }
        this.compressedBuffer = null;
        this.decompressedBuffer = null;
        if (!this.closed) {
            Uns.free(this.compressedAddress);
        }
        this.closed = true;
    }

    protected void finalize() throws Throwable {
        if (!this.closed) {
            Uns.free(this.compressedAddress);
        }
        super.finalize();
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int dstRem;
        int r = this.decompressedBuffer.remaining();
        if (r == 0) {
            if (this.readBytes(4) == 0) {
                return -1;
            }
            int cLen = this.compressedBuffer.getInt(0);
            if (this.readBytes(cLen) != cLen) {
                throw new EOFException("unexpected EOF");
            }
            ByteBufferCompat.byteBufferClear(this.decompressedBuffer);
            if (!Snappy.isValidCompressedBuffer((ByteBuffer)this.compressedBuffer)) {
                throw new IOException("Invalid compressed data");
            }
            r = Snappy.uncompress((ByteBuffer)this.compressedBuffer, (ByteBuffer)this.decompressedBuffer);
        }
        if ((dstRem = dst.remaining()) < r) {
            ByteBuffer dDup = this.decompressedBuffer.duplicate();
            ByteBufferCompat.byteBufferLimit(dDup, dDup.position() + dstRem);
            dst.put(dDup);
            ByteBufferCompat.byteBufferPosition(this.decompressedBuffer, this.decompressedBuffer.position() + dstRem);
            return dstRem;
        }
        dst.put(this.decompressedBuffer);
        return r - this.decompressedBuffer.remaining();
    }

    private int readBytes(int len) throws IOException {
        ByteBufferCompat.byteBufferClear(this.compressedBuffer);
        ByteBufferCompat.byteBufferLimit(this.compressedBuffer, len);
        if (!Util.readFully(this.delegate, this.compressedBuffer)) {
            return 0;
        }
        ByteBufferCompat.byteBufferPosition(this.compressedBuffer, 0);
        return len;
    }

    @Override
    public boolean isOpen() {
        return this.compressedBuffer != null;
    }
}

