/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.gcmon;

import java.util.Iterator;
import org.gridkit.jvmtool.event.SimpleCounterCollection;
import org.gridkit.jvmtool.event.SimpleTagCollection;
import org.gridkit.jvmtool.gcmon.GarbageCollectionEvent;
import org.gridkit.jvmtool.gcmon.GarbageCollectionSummary;
import org.gridkit.jvmtool.jvmevents.JvmEvents;

public class GarbageCollectionEventPojo
implements GarbageCollectionEvent {
    private long timestamp;
    private SimpleTagCollection tags = new SimpleTagCollection();
    private SimpleCounterCollection counters = new SimpleCounterCollection();

    @Override
    public long timestamp() {
        return this.timestamp;
    }

    public void timestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public SimpleCounterCollection counters() {
        return this.counters;
    }

    public SimpleTagCollection tags() {
        return this.tags;
    }

    @Override
    public long duration() {
        return this.counters().getValue("duration");
    }

    public void duration(long duration) {
        this.counters().set("duration", duration);
    }

    public void tag(String key, String tag) {
        this.tags.put(key, tag);
    }

    public void set(String counter, long value) {
        this.counters.set(counter, value);
    }

    @Override
    public String collectorName() {
        return this.firstTag("jvm.gc.name");
    }

    public void collectorName(String name) {
        this.tags().put("jvm.gc.name", name);
    }

    @Override
    public long collectionCount() {
        return this.counters.getValue("jvm.gc.count");
    }

    @Override
    public long collectionTotalTime() {
        return this.counters.getValue("jvm.gc.total-time");
    }

    @Override
    public Iterable<String> memorySpaces() {
        return this.tags.tagsFor("jvm.gc.memory-spaces");
    }

    @Override
    public long memoryBefore(String space) {
        return this.counters.getValue(JvmEvents.memorySpaceBefore((String)space));
    }

    @Override
    public long memoryAfter(String space) {
        return this.counters.getValue(JvmEvents.memorySpaceUsed((String)space));
    }

    @Override
    public long memoryMax(String space) {
        return this.counters.getValue(JvmEvents.memorySpaceMax((String)space));
    }

    @Override
    public String memorySpaceName(String spaceId) {
        return this.firstTag(JvmEvents.memorySpaceName((String)spaceId));
    }

    private String firstTag(String key) {
        Iterator it = this.tags.tagsFor(key).iterator();
        return it.hasNext() ? (String)it.next() : null;
    }

    public void loadFrom(GarbageCollectionSummary gcevent) {
        this.collectorName(gcevent.collectorName());
        this.timestamp(gcevent.timestamp());
        this.duration(gcevent.duration());
        this.counters().set("jvm.gc.count", gcevent.collectionCount());
        this.counters().set("jvm.gc.total-time", gcevent.collectionTotalTime());
        for (String spaceId : gcevent.memorySpaces()) {
            this.tags().put("jvm.gc.memory-spaces", spaceId);
            this.tags().put(JvmEvents.memorySpaceName((String)spaceId), gcevent.memorySpaceName(spaceId));
            this.counters().set(JvmEvents.memorySpaceBefore((String)spaceId), gcevent.memoryBefore(spaceId));
            this.counters().set(JvmEvents.memorySpaceUsed((String)spaceId), gcevent.memoryAfter(spaceId));
            this.counters().set(JvmEvents.memorySpaceMax((String)spaceId), gcevent.memoryMax(spaceId));
        }
    }
}

