/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.stacktrace.analytics.flame;

import org.gridkit.jvmtool.event.TagCollection;
import org.gridkit.jvmtool.stacktrace.CounterCollection;
import org.gridkit.jvmtool.stacktrace.GenericStackElement;
import org.gridkit.jvmtool.stacktrace.StackFrame;
import org.gridkit.jvmtool.stacktrace.StackFrameArray;
import org.gridkit.jvmtool.stacktrace.StackFrameList;
import org.gridkit.jvmtool.stacktrace.ThreadSnapshot;
import org.gridkit.jvmtool.stacktrace.analytics.ThreadSnapshotFilter;
import org.gridkit.jvmtool.stacktrace.analytics.flame.DefaultColorPicker;
import org.gridkit.jvmtool.stacktrace.analytics.flame.FlameColorPicker;

public class RainbowColorPicker
implements FlameColorPicker {
    ThreadSnapshotFilter[] filters;
    int[] hues;
    int dh;

    public RainbowColorPicker(ThreadSnapshotFilter[] filters) {
        this.filters = filters;
        this.hues = new int[filters.length];
        int lim = Math.min(220, 60 * filters.length);
        int d = lim / filters.length;
        this.dh = Math.min(7, d / 3);
        for (int n = 0; n != filters.length; ++n) {
            this.hues[n] = 12 + n * d;
        }
    }

    @Override
    public int pickColor(GenericStackElement[] trace) {
        if (trace == null || trace.length < 1) {
            return 0;
        }
        StackFrame[] ftrace = new StackFrame[trace.length];
        for (int i = 0; i != trace.length; ++i) {
            ftrace[i] = (StackFrame)trace[i];
        }
        TSnap snap = new TSnap(ftrace);
        StackFrame frame = ftrace[ftrace.length - 1];
        for (int n = 0; n != this.filters.length; ++n) {
            if (!this.filters[n].evaluate(snap)) continue;
            return DefaultColorPicker.hashColor(this.hues[n], 0, frame);
        }
        return DefaultColorPicker.hashGrayColor(frame);
    }

    private static class TSnap
    implements ThreadSnapshot {
        StackFrameList trace;

        public TSnap(StackFrame[] trace) {
            this.trace = new StackFrameArray(trace);
        }

        @Override
        public long threadId() {
            return 0L;
        }

        @Override
        public String threadName() {
            return null;
        }

        @Override
        public long timestamp() {
            return 0L;
        }

        @Override
        public StackFrameList stackTrace() {
            return this.trace;
        }

        @Override
        public Thread.State threadState() {
            return null;
        }

        @Override
        public CounterCollection counters() {
            return null;
        }

        @Override
        public TagCollection tags() {
            return null;
        }
    }
}

