/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.sparta.xpath;

import com.hp.hpl.sparta.xpath.AttrEqualsExpr;
import com.hp.hpl.sparta.xpath.AttrExistsExpr;
import com.hp.hpl.sparta.xpath.AttrGreaterExpr;
import com.hp.hpl.sparta.xpath.AttrLessExpr;
import com.hp.hpl.sparta.xpath.AttrNotEqualsExpr;
import com.hp.hpl.sparta.xpath.BooleanExpr;
import com.hp.hpl.sparta.xpath.PositionEqualsExpr;
import com.hp.hpl.sparta.xpath.SimpleStreamTokenizer;
import com.hp.hpl.sparta.xpath.TextEqualsExpr;
import com.hp.hpl.sparta.xpath.TextExistsExpr;
import com.hp.hpl.sparta.xpath.TextNotEqualsExpr;
import com.hp.hpl.sparta.xpath.XPath;
import com.hp.hpl.sparta.xpath.XPathException;
import java.io.IOException;

public class ExprFactory {
    static BooleanExpr createExpr(XPath xpath, SimpleStreamTokenizer toks) throws XPathException, IOException {
        switch (toks.ttype) {
            default: {
                throw new XPathException(xpath, "at beginning of expression", toks, "@, number, or text()");
            }
            case -2: {
                int position = toks.nval;
                toks.nextToken();
                return new PositionEqualsExpr(position);
            }
            case 64: {
                if (toks.nextToken() != -3) {
                    throw new XPathException(xpath, "after @", toks, "name");
                }
                String name = toks.sval;
                switch (toks.nextToken()) {
                    case 61: {
                        toks.nextToken();
                        if (toks.ttype != 34 && toks.ttype != 39) {
                            throw new XPathException(xpath, "right hand side of equals", toks, "quoted string");
                        }
                        String value = toks.sval;
                        toks.nextToken();
                        return new AttrEqualsExpr(name, value);
                    }
                    case 60: {
                        int valueN;
                        toks.nextToken();
                        if (toks.ttype == 34 || toks.ttype == 39) {
                            valueN = Integer.parseInt(toks.sval);
                        } else if (toks.ttype == -2) {
                            valueN = toks.nval;
                        } else {
                            throw new XPathException(xpath, "right hand side of less-than", toks, "quoted string or number");
                        }
                        toks.nextToken();
                        return new AttrLessExpr(name, valueN);
                    }
                    case 62: {
                        int valueN;
                        toks.nextToken();
                        if (toks.ttype == 34 || toks.ttype == 39) {
                            valueN = Integer.parseInt(toks.sval);
                        } else if (toks.ttype == -2) {
                            valueN = toks.nval;
                        } else {
                            throw new XPathException(xpath, "right hand side of greater-than", toks, "quoted string or number");
                        }
                        toks.nextToken();
                        return new AttrGreaterExpr(name, valueN);
                    }
                    case 33: {
                        toks.nextToken();
                        if (toks.ttype != 61) {
                            throw new XPathException(xpath, "after !", toks, "=");
                        }
                        toks.nextToken();
                        if (toks.ttype != 34 && toks.ttype != 39) {
                            throw new XPathException(xpath, "right hand side of !=", toks, "quoted string");
                        }
                        String value = toks.sval;
                        toks.nextToken();
                        return new AttrNotEqualsExpr(name, value);
                    }
                }
                return new AttrExistsExpr(name);
            }
            case -3: 
        }
        if (!toks.sval.equals("text")) {
            throw new XPathException(xpath, "at beginning of expression", toks, "text()");
        }
        if (toks.nextToken() != 40) {
            throw new XPathException(xpath, "after text", toks, "(");
        }
        if (toks.nextToken() != 41) {
            throw new XPathException(xpath, "after text(", toks, ")");
        }
        switch (toks.nextToken()) {
            case 61: {
                toks.nextToken();
                if (toks.ttype != 34 && toks.ttype != 39) {
                    throw new XPathException(xpath, "right hand side of equals", toks, "quoted string");
                }
                String tValue = toks.sval;
                toks.nextToken();
                return new TextEqualsExpr(tValue);
            }
            case 33: {
                toks.nextToken();
                if (toks.ttype != 61) {
                    throw new XPathException(xpath, "after !", toks, "=");
                }
                toks.nextToken();
                if (toks.ttype != 34 && toks.ttype != 39) {
                    throw new XPathException(xpath, "right hand side of !=", toks, "quoted string");
                }
                String tValue = toks.sval;
                toks.nextToken();
                return new TextNotEqualsExpr(tValue);
            }
        }
        return TextExistsExpr.INSTANCE;
    }
}

