/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.traversers;

import com.codahale.metrics.annotation.Timed;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Singleton;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.api.graph.EdgeAPI;
import org.apache.hugegraph.api.graph.VertexAPI;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.query.QueryResults;
import org.apache.hugegraph.core.GraphManager;
import org.apache.hugegraph.traversal.algorithm.HugeTraverser;
import org.apache.hugegraph.traversal.algorithm.SingleSourceShortestPathTraverser;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.slf4j.Logger;

@Path(value="graphspaces/{graphspace}/graphs/{graph}/traversers/weightedshortestpath")
@Singleton
@Tag(name="WeightedShortestPathAPI")
public class WeightedShortestPathAPI
extends API {
    private static final Logger LOG = Log.logger(WeightedShortestPathAPI.class);

    @GET
    @Timed
    @Produces(value={"application/json;charset=UTF-8"})
    public String get(@Context GraphManager manager, @PathParam(value="graphspace") String graphSpace, @PathParam(value="graph") String graph, @QueryParam(value="source") String source, @QueryParam(value="target") String target, @QueryParam(value="direction") String direction, @QueryParam(value="label") String edgeLabel, @QueryParam(value="weight") String weight, @QueryParam(value="max_degree") @DefaultValue(value="10000") long maxDegree, @QueryParam(value="skip_degree") @DefaultValue(value="0") long skipDegree, @QueryParam(value="with_vertex") @DefaultValue(value="false") boolean withVertex, @QueryParam(value="with_edge") @DefaultValue(value="false") boolean withEdge, @QueryParam(value="capacity") @DefaultValue(value="10000000") long capacity) {
        Iterator iterVertex;
        LOG.debug("Graph [{}] get weighted shortest path between '{}' and '{}' with direction {}, edge label {}, weight property {}, max degree '{}', skip degree '{}', capacity '{}', with_vertex '{}' and with_edge '{}'", new Object[]{graph, source, target, direction, edgeLabel, weight, maxDegree, skipDegree, capacity, withVertex, withEdge});
        API.ApiMeasurer measure = new API.ApiMeasurer();
        Id sourceId = VertexAPI.checkAndParseVertexId(source);
        Id targetId = VertexAPI.checkAndParseVertexId(target);
        Directions dir = Directions.convert((Direction)EdgeAPI.parseDirection(direction));
        E.checkArgumentNotNull((Object)weight, (String)"The weight property can't be null", (Object[])new Object[0]);
        HugeGraph g = WeightedShortestPathAPI.graph(manager, graphSpace, graph);
        SingleSourceShortestPathTraverser traverser = new SingleSourceShortestPathTraverser(g);
        SingleSourceShortestPathTraverser.NodeWithWeight node = traverser.weightedShortestPath(sourceId, targetId, dir, edgeLabel, weight, maxDegree, skipDegree, capacity);
        measure.addIterCount(traverser.vertexIterCounter.get(), traverser.edgeIterCounter.get());
        if (node == null) {
            return manager.serializer((Graph)g, measure.measures()).writeWeightedPath(null, QueryResults.emptyIterator(), QueryResults.emptyIterator());
        }
        List vertexIds = node.node().path();
        if (withVertex && !vertexIds.isEmpty()) {
            iterVertex = g.vertices(vertexIds.toArray());
            measure.addIterCount(vertexIds.size(), 0L);
        } else {
            iterVertex = vertexIds.iterator();
        }
        Set edges = node.getEdges();
        Iterator iterEdge = withEdge && !edges.isEmpty() ? edges.iterator() : HugeTraverser.EdgeRecord.getEdgeIds((Set)edges).iterator();
        return manager.serializer((Graph)g, measure.measures()).writeWeightedPath(node, iterVertex, iterEdge);
    }
}

