/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.traversers;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.api.graph.EdgeAPI;
import org.apache.hugegraph.api.graph.VertexAPI;
import org.apache.hugegraph.api.traversers.TraverserAPI;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.query.QueryResults;
import org.apache.hugegraph.core.GraphManager;
import org.apache.hugegraph.structure.HugeVertex;
import org.apache.hugegraph.traversal.algorithm.HugeTraverser;
import org.apache.hugegraph.traversal.algorithm.KneighborTraverser;
import org.apache.hugegraph.traversal.algorithm.records.KneighborRecords;
import org.apache.hugegraph.traversal.algorithm.steps.Steps;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.slf4j.Logger;

@Path(value="graphspaces/{graphspace}/graphs/{graph}/traversers/kneighbor")
@Singleton
@Tag(name="KneighborAPI")
public class KneighborAPI
extends TraverserAPI {
    private static final Logger LOG = Log.logger(KneighborAPI.class);

    @GET
    @Timed
    @Produces(value={"application/json;charset=UTF-8"})
    public String get(@Context GraphManager manager, @PathParam(value="graphspace") String graphSpace, @PathParam(value="graph") String graph, @QueryParam(value="source") String sourceV, @QueryParam(value="direction") String direction, @QueryParam(value="label") String edgeLabel, @QueryParam(value="max_depth") int depth, @QueryParam(value="count_only") @DefaultValue(value="false") boolean countOnly, @QueryParam(value="max_degree") @DefaultValue(value="10000") long maxDegree, @QueryParam(value="limit") @DefaultValue(value="10000000") int limit) {
        Set ids;
        LOG.debug("Graph [{}] get k-neighbor from '{}' with direction '{}', edge label '{}', max depth '{}', max degree '{}' and limit '{}'", new Object[]{graph, sourceV, direction, edgeLabel, depth, maxDegree, limit});
        API.ApiMeasurer measure = new API.ApiMeasurer();
        Id source = VertexAPI.checkAndParseVertexId(sourceV);
        Directions dir = Directions.convert((Direction)EdgeAPI.parseDirection(direction));
        HugeGraph g = KneighborAPI.graph(manager, graphSpace, graph);
        try (KneighborTraverser traverser = new KneighborTraverser(g);){
            ids = traverser.kneighbor(source, dir, edgeLabel, depth, maxDegree, (long)limit);
            measure.addIterCount(traverser.vertexIterCounter.get(), traverser.edgeIterCounter.get());
        }
        if (countOnly) {
            return manager.serializer((Graph)g, measure.measures()).writeMap((Map<?, ?>)ImmutableMap.of((Object)"vertices_size", (Object)ids.size()));
        }
        return manager.serializer((Graph)g, measure.measures()).writeList("vertices", ids);
    }

    @POST
    @Timed
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String post(@Context GraphManager manager, @PathParam(value="graphspace") String graphSpace, @PathParam(value="graph") String graph, Request request) {
        KneighborRecords results;
        E.checkArgumentNotNull((Object)request, (String)"The request body can't be null", (Object[])new Object[0]);
        E.checkArgumentNotNull((Object)request.source, (String)"The source of request can't be null", (Object[])new Object[0]);
        E.checkArgument((request.steps != null ? 1 : 0) != 0, (String)"The steps of request can't be null", (Object[])new Object[0]);
        if (request.countOnly) {
            E.checkArgument((!request.withVertex && !request.withPath && !request.withEdge ? 1 : 0) != 0, (String)"Can't return vertex, edge or path when count only", (Object[])new Object[0]);
        }
        LOG.debug("Graph [{}] get customized kneighbor from source vertex '{}', with steps '{}', limit '{}', count_only '{}', with_vertex '{}', with_path '{}' and with_edge '{}'", new Object[]{graph, request.source, request.steps, request.limit, request.countOnly, request.withVertex, request.withPath, request.withEdge});
        API.ApiMeasurer measure = new API.ApiMeasurer();
        HugeGraph g = KneighborAPI.graph(manager, graphSpace, graph);
        Id sourceId = HugeVertex.getIdValue((Object)request.source);
        Steps steps = KneighborAPI.steps(g, request.steps);
        try (KneighborTraverser traverser = new KneighborTraverser(g);){
            results = traverser.customizedKneighbor(sourceId, steps, request.maxDepth, (long)request.limit);
            measure.addIterCount(traverser.vertexIterCounter.get(), traverser.edgeIterCounter.get());
        }
        long size = results.size();
        if ((long)request.limit != -1L && size > (long)request.limit) {
            size = request.limit;
        }
        ImmutableList neighbors = request.countOnly ? ImmutableList.of() : results.ids((long)request.limit);
        HugeTraverser.PathSet paths = new HugeTraverser.PathSet();
        if (request.withPath) {
            paths.addAll(results.paths((long)request.limit));
        }
        if (request.countOnly) {
            return manager.serializer((Graph)g, measure.measures()).writeNodesWithPath("kneighbor", (List<Id>)neighbors, size, (Collection<HugeTraverser.Path>)paths, QueryResults.emptyIterator(), QueryResults.emptyIterator());
        }
        Iterator iterVertex = Collections.emptyIterator();
        HashSet vertexIds = new HashSet(neighbors);
        if (request.withPath) {
            for (HugeTraverser.Path p : paths) {
                vertexIds.addAll(p.vertices());
            }
        }
        if (request.withVertex && !vertexIds.isEmpty()) {
            iterVertex = g.vertices(vertexIds.toArray());
            measure.addIterCount(vertexIds.size(), 0L);
        }
        Iterator<Object> iterEdge = Collections.emptyIterator();
        if (request.withPath && request.withEdge) {
            Set edges = results.edgeResults().getEdges((Collection)paths);
            iterEdge = edges.iterator();
        }
        return manager.serializer((Graph)g, measure.measures()).writeNodesWithPath("kneighbor", (List<Id>)neighbors, size, (Collection<HugeTraverser.Path>)paths, iterVertex, iterEdge);
    }

    private static class Request {
        @JsonProperty(value="source")
        public Object source;
        @JsonProperty(value="steps")
        public TraverserAPI.VESteps steps;
        @JsonProperty(value="max_depth")
        public int maxDepth;
        @JsonProperty(value="limit")
        public int limit = Integer.parseInt("10000000");
        @JsonProperty(value="count_only")
        public boolean countOnly = false;
        @JsonProperty(value="with_vertex")
        public boolean withVertex = false;
        @JsonProperty(value="with_path")
        public boolean withPath = false;
        @JsonProperty(value="with_edge")
        public boolean withEdge = false;

        private Request() {
        }

        public String toString() {
            return String.format("PathRequest{source=%s,steps=%s,maxDepth=%slimit=%s,countOnly=%s,withVertex=%s,withPath=%s,withEdge=%s}", this.source, this.steps, this.maxDepth, this.limit, this.countOnly, this.withVertex, this.withPath, this.withEdge);
        }
    }
}

