/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.traversers;

import com.codahale.metrics.annotation.Timed;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Singleton;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import java.util.Iterator;
import java.util.List;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.api.filter.CompressInterceptor;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.query.ConditionQuery;
import org.apache.hugegraph.backend.query.Query;
import org.apache.hugegraph.core.GraphManager;
import org.apache.hugegraph.structure.HugeEdge;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

@Path(value="graphspaces/{graphspace}/graphs/{graph}/traversers/edges")
@Singleton
@Tag(name="EdgesAPI")
public class EdgesAPI
extends API {
    private static final Logger LOG = Log.logger(EdgesAPI.class);

    @GET
    @Timed
    @CompressInterceptor.Compress
    @Produces(value={"application/json;charset=UTF-8"})
    public String list(@Context GraphManager manager, @PathParam(value="graphspace") String graphSpace, @PathParam(value="graph") String graph, @QueryParam(value="ids") List<String> stringIds) {
        LOG.debug("Graph [{}] get edges by ids: {}", (Object)graph, stringIds);
        E.checkArgument((stringIds != null && !stringIds.isEmpty() ? 1 : 0) != 0, (String)"The ids parameter can't be null or empty", (Object[])new Object[0]);
        Object[] ids = new Id[stringIds.size()];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = HugeEdge.getIdValue((Object)stringIds.get(i), (boolean)false);
        }
        HugeGraph g = EdgesAPI.graph(manager, graphSpace, graph);
        Iterator edges = g.edges(ids);
        return manager.serializer().writeEdges(edges, false);
    }

    @GET
    @Timed
    @Path(value="shards")
    @CompressInterceptor.Compress
    @Produces(value={"application/json;charset=UTF-8"})
    public String shards(@Context GraphManager manager, @PathParam(value="graphspace") String graphSpace, @PathParam(value="graph") String graph, @QueryParam(value="split_size") long splitSize) {
        LOG.debug("Graph [{}] get vertex shards with split size '{}'", (Object)graph, (Object)splitSize);
        HugeGraph g = EdgesAPI.graph(manager, graphSpace, graph);
        List shards = (List)g.metadata(HugeType.EDGE_OUT, "splits", new Object[]{splitSize});
        return manager.serializer().writeList("shards", shards);
    }

    @GET
    @Timed
    @Path(value="scan")
    @CompressInterceptor.Compress
    @Produces(value={"application/json;charset=UTF-8"})
    public String scan(@Context GraphManager manager, @PathParam(value="graphspace") String graphSpace, @PathParam(value="graph") String graph, @QueryParam(value="start") String start, @QueryParam(value="end") String end, @QueryParam(value="page") String page, @QueryParam(value="page_limit") @DefaultValue(value="100000") long pageLimit) {
        LOG.debug("Graph [{}] query edges by shard(start: {}, end: {}, page: {}) ", new Object[]{graph, start, end, page});
        HugeGraph g = EdgesAPI.graph(manager, graphSpace, graph);
        ConditionQuery query = new ConditionQuery(HugeType.EDGE_OUT);
        query.scan(start, end);
        query.page(page);
        if (query.paging()) {
            query.limit(pageLimit);
        }
        Iterator edges = g.edges((Query)query);
        return manager.serializer().writeEdges(edges, query.paging());
    }
}

