/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.filter;

import jakarta.inject.Singleton;
import jakarta.ws.rs.NameBinding;
import jakarta.ws.rs.ext.Provider;
import jakarta.ws.rs.ext.ReaderInterceptor;
import jakarta.ws.rs.ext.ReaderInterceptorContext;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.zip.GZIPInputStream;

@Provider
@Singleton
@Decompress
public class DecompressInterceptor
implements ReaderInterceptor {
    public static final String GZIP = "gzip";

    public Object aroundReadFrom(ReaderInterceptorContext context) throws IOException {
        String encoding = (String)context.getHeaders().getFirst((Object)"Content-Encoding");
        if (!GZIP.equalsIgnoreCase(encoding)) {
            return context.proceed();
        }
        context.setInputStream((InputStream)new GZIPInputStream(context.getInputStream()));
        return context.proceed();
    }

    @NameBinding
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Decompress {
        public String value() default "gzip";
    }
}

