/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.serializer;

import java.util.Arrays;
import org.apache.fury.Fury;
import org.apache.fury.collection.FuryObjectMap;
import org.apache.fury.memory.MemoryBuffer;
import org.apache.fury.meta.Encoders;
import org.apache.fury.meta.MetaString;
import org.apache.fury.resolver.MetaStringBytes;
import org.apache.fury.resolver.MetaStringResolver;
import org.apache.fury.serializer.ImmutableSerializer;
import org.apache.fury.util.Preconditions;

public class EnumSerializer
extends ImmutableSerializer<Enum> {
    private final MetaStringResolver metaStringResolver;
    private final Enum[] enumConstants;
    private final FuryObjectMap<MetaStringBytes, Enum> metaStringtoEnumRepresentation;
    private final MetaStringBytes[] metaStringBytesArrByEnumOrdinal;

    public EnumSerializer(Fury fury, Class<Enum> cls) {
        super(fury, cls, false);
        this.metaStringResolver = fury.getMetaStringResolver();
        if (cls.isEnum()) {
            this.enumConstants = cls.getEnumConstants();
        } else {
            Preconditions.checkArgument(Enum.class.isAssignableFrom(cls) && cls != Enum.class);
            Class<?> enclosingClass = cls.getEnclosingClass();
            Preconditions.checkNotNull(enclosingClass);
            Preconditions.checkArgument(enclosingClass.isEnum());
            this.enumConstants = (Enum[])enclosingClass.getEnumConstants();
        }
        this.metaStringBytesArrByEnumOrdinal = new MetaStringBytes[this.enumConstants.length];
        if (fury.getConfig().serializeEnumByName()) {
            int initialCapacity = (int)Math.ceil((float)this.enumConstants.length / 0.5f);
            this.metaStringtoEnumRepresentation = new FuryObjectMap(initialCapacity, 0.5f);
            for (Enum enumConstant : this.enumConstants) {
                if (enumConstant == null) continue;
                MetaString ms = Encoders.GENERIC_ENCODER.encode(enumConstant.name());
                MetaStringBytes msb = this.metaStringResolver.getOrCreateMetaStringBytes(ms);
                this.metaStringtoEnumRepresentation.put(msb, enumConstant);
                this.metaStringBytesArrByEnumOrdinal[enumConstant.ordinal()] = msb;
            }
        } else {
            this.metaStringtoEnumRepresentation = null;
        }
    }

    @Override
    public void write(MemoryBuffer buffer, Enum value) {
        if (this.fury.getConfig().serializeEnumByName()) {
            MetaStringBytes metaStringBytes = this.metaStringBytesArrByEnumOrdinal[value.ordinal()];
            this.metaStringResolver.writeMetaStringBytes(buffer, metaStringBytes);
        } else {
            buffer.writeVarUint32Small7(value.ordinal());
        }
    }

    @Override
    public Enum read(MemoryBuffer buffer) {
        if (this.fury.getConfig().serializeEnumByName()) {
            MetaStringBytes metaStringBytes = this.metaStringResolver.readMetaStringBytes(buffer);
            Enum e = this.metaStringtoEnumRepresentation.get(metaStringBytes);
            if (e != null) {
                return e;
            }
            return this.handleNonexistentEnumValue(metaStringBytes.decode(Encoders.GENERIC_DECODER));
        }
        int value = buffer.readVarUint32Small7();
        if (value >= this.enumConstants.length) {
            return this.handleNonexistentEnumValue(value);
        }
        return this.enumConstants[value];
    }

    private Enum handleNonexistentEnumValue(int value) {
        if (this.fury.getConfig().deserializeNonexistentEnumValueAsNull()) {
            return null;
        }
        throw new IllegalArgumentException(String.format("Enum ordinal %s not in %s", value, Arrays.toString(this.enumConstants)));
    }

    private Enum handleNonexistentEnumValue(String value) {
        if (this.fury.getConfig().deserializeNonexistentEnumValueAsNull()) {
            return null;
        }
        throw new IllegalArgumentException(String.format("Enum string %s not in %s", value, Arrays.toString(this.enumConstants)));
    }
}

