/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.meta;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.fury.Fury;
import org.apache.fury.collection.Tuple2;
import org.apache.fury.memory.MemoryBuffer;
import org.apache.fury.memory.MemoryUtils;
import org.apache.fury.meta.ClassDef;
import org.apache.fury.meta.Encoders;
import org.apache.fury.meta.MetaString;
import org.apache.fury.reflect.ReflectionUtils;
import org.apache.fury.resolver.ClassResolver;
import org.apache.fury.type.Descriptor;
import org.apache.fury.type.DescriptorGrouper;
import org.apache.fury.util.MathUtils;
import org.apache.fury.util.MurmurHash3;

class ClassDefEncoder {
    static final int BIG_NAME_THRESHOLD = 63;

    ClassDefEncoder() {
    }

    static List<Field> buildFields(Fury fury, Class<?> cls, boolean resolveParent) {
        Comparator<Descriptor> comparator = DescriptorGrouper.getPrimitiveComparator(fury.compressInt(), fury.compressLong());
        DescriptorGrouper descriptorGrouper = new DescriptorGrouper(fury.getClassResolver()::isMonomorphic, fury.getClassResolver().getAllDescriptorsMap(cls, resolveParent).values(), false, Function.identity(), comparator, DescriptorGrouper.COMPARATOR_BY_TYPE_AND_NAME);
        ArrayList<Field> fields = new ArrayList<Field>();
        descriptorGrouper.getPrimitiveDescriptors().forEach(descriptor -> fields.add(descriptor.getField()));
        descriptorGrouper.getBoxedDescriptors().forEach(descriptor -> fields.add(descriptor.getField()));
        descriptorGrouper.getFinalDescriptors().forEach(descriptor -> fields.add(descriptor.getField()));
        descriptorGrouper.getOtherDescriptors().forEach(descriptor -> fields.add(descriptor.getField()));
        descriptorGrouper.getCollectionDescriptors().forEach(descriptor -> fields.add(descriptor.getField()));
        descriptorGrouper.getMapDescriptors().forEach(descriptor -> fields.add(descriptor.getField()));
        return fields;
    }

    static List<ClassDef.FieldInfo> buildFieldsInfo(ClassResolver resolver, Class<?> cls) {
        return ClassDefEncoder.buildFieldsInfo(resolver, ClassDefEncoder.buildFields(resolver.getFury(), cls, true));
    }

    static List<ClassDef.FieldInfo> buildFieldsInfo(ClassResolver resolver, List<Field> fields) {
        ArrayList<ClassDef.FieldInfo> fieldInfos = new ArrayList<ClassDef.FieldInfo>();
        for (Field field : fields) {
            ClassDef.FieldInfo fieldInfo = new ClassDef.FieldInfo(field.getDeclaringClass().getName(), field.getName(), ClassDef.buildFieldType(resolver, field));
            fieldInfos.add(fieldInfo);
        }
        return fieldInfos;
    }

    static ClassDef buildClassDef(ClassResolver classResolver, Class<?> type, List<Field> fields, boolean isObjectType) {
        List<ClassDef.FieldInfo> fieldInfos = ClassDefEncoder.buildFieldsInfo(classResolver, fields);
        Map<String, List<ClassDef.FieldInfo>> classLayers = ClassDefEncoder.getClassFields(type, fieldInfos);
        fieldInfos = new ArrayList<ClassDef.FieldInfo>(fieldInfos.size());
        classLayers.values().forEach(fieldInfos::addAll);
        MemoryBuffer encodeClassDef = ClassDefEncoder.encodeClassDef(classResolver, type, classLayers, isObjectType);
        byte[] classDefBytes = encodeClassDef.getBytes(0, encodeClassDef.writerIndex());
        return new ClassDef(Encoders.buildClassSpec(type), fieldInfos, isObjectType, encodeClassDef.getInt64(0), classDefBytes);
    }

    static MemoryBuffer encodeClassDef(ClassResolver classResolver, Class<?> type, Map<String, List<ClassDef.FieldInfo>> classLayers, boolean isObjectType) {
        MemoryBuffer classDefBuf = MemoryBuffer.newHeapBuffer(128);
        for (Map.Entry<String, List<ClassDef.FieldInfo>> entry : classLayers.entrySet()) {
            String className = entry.getKey();
            List<ClassDef.FieldInfo> fields = entry.getValue();
            int currentClassHeader = fields.size() << 1;
            if (classResolver.isRegistered(type)) {
                classDefBuf.writeVarUint32Small7(currentClassHeader |= 1);
                classDefBuf.writeVarUint32Small7(classResolver.getRegisteredClassId(type).shortValue());
            } else {
                classDefBuf.writeVarUint32Small7(currentClassHeader);
                Class<?> currentType = ClassDefEncoder.getType(type, className);
                Tuple2<String, String> encoded = Encoders.encodePkgAndClass(currentType);
                ClassDefEncoder.writePkgName(classDefBuf, (String)encoded.f0);
                ClassDefEncoder.writeTypeName(classDefBuf, (String)encoded.f1);
            }
            ClassDefEncoder.writeFieldsInfo(classDefBuf, fields);
        }
        byte[] compressed = classResolver.getFury().getConfig().getMetaCompressor().compress(classDefBuf.getHeapMemory(), 0, classDefBuf.writerIndex());
        boolean isCompressed = false;
        if (compressed.length < classDefBuf.writerIndex()) {
            isCompressed = true;
            classDefBuf = MemoryBuffer.fromByteArray(compressed);
            classDefBuf.writerIndex(compressed.length);
        }
        long hash = MurmurHash3.murmurhash3_x64_128(classDefBuf.getHeapMemory(), 0, classDefBuf.writerIndex(), 47)[0];
        int numClasses = classLayers.size() - 1;
        long header = numClasses > 14 ? 15L : (long)numClasses;
        header |= 0x10L;
        if (isObjectType) {
            header |= 0x40L;
        }
        if (isCompressed) {
            header |= 0x80L;
        }
        header |= Math.abs(hash <<= 8);
        MemoryBuffer buffer = MemoryUtils.buffer(classDefBuf.writerIndex() + 10);
        int len = classDefBuf.writerIndex() + MathUtils.toInt(numClasses > 14);
        if (len > 255) {
            buffer.writeInt64(header |= 0x20L);
            buffer.writeInt16((short)len);
        } else {
            buffer.writeInt64(header);
            buffer.writeByte(len);
        }
        if (numClasses > 14) {
            buffer.writeVarUint32Small7(numClasses - 14);
        }
        buffer.writeBytes(classDefBuf.getHeapMemory(), 0, classDefBuf.writerIndex());
        return buffer;
    }

    private static Class<?> getType(Class<?> cls, String type) {
        Class<?> c = cls;
        while (cls != null) {
            if (type.equals(cls.getName())) {
                return cls;
            }
            cls = cls.getSuperclass();
        }
        throw new IllegalStateException(String.format("Class %s doesn't have %s as super class", c, type));
    }

    static Map<String, List<ClassDef.FieldInfo>> getClassFields(Class<?> type, List<ClassDef.FieldInfo> fieldsInfo) {
        LinkedHashMap<String, List<ClassDef.FieldInfo>> sortedClassFields = new LinkedHashMap<String, List<ClassDef.FieldInfo>>();
        if (fieldsInfo.isEmpty()) {
            sortedClassFields.put(type.getName(), new ArrayList());
            return sortedClassFields;
        }
        Map<String, List<ClassDef.FieldInfo>> classFields = ClassDefEncoder.groupClassFields(fieldsInfo);
        for (Class<?> clz : ReflectionUtils.getAllClasses(type, true)) {
            List<ClassDef.FieldInfo> fieldInfos = classFields.get(clz.getName());
            if (fieldInfos != null) {
                sortedClassFields.put(clz.getName(), fieldInfos);
                continue;
            }
            if (!type.getName().equals(clz.getName())) continue;
            sortedClassFields.put(clz.getName(), new ArrayList());
        }
        classFields = sortedClassFields;
        return classFields;
    }

    static Map<String, List<ClassDef.FieldInfo>> groupClassFields(List<ClassDef.FieldInfo> fieldsInfo) {
        HashMap<String, List<ClassDef.FieldInfo>> classFields = new HashMap<String, List<ClassDef.FieldInfo>>();
        for (ClassDef.FieldInfo fieldInfo : fieldsInfo) {
            String definedClass = fieldInfo.getDefinedClass();
            classFields.computeIfAbsent(definedClass, k -> new ArrayList()).add(fieldInfo);
        }
        return classFields;
    }

    static void writeFieldsInfo(MemoryBuffer buffer, List<ClassDef.FieldInfo> fields) {
        for (ClassDef.FieldInfo fieldInfo : fields) {
            boolean bigSize;
            ClassDef.FieldType fieldType = fieldInfo.getFieldType();
            int header = (fieldType.isMonomorphic() ? 1 : 0) << 2;
            MetaString metaString = Encoders.encodeFieldName(fieldInfo.getFieldName());
            int encodingFlags = Encoders.fieldNameEncodingsList.indexOf((Object)metaString.getEncoding());
            byte[] encoded = metaString.getBytes();
            int size = encoded.length - 1;
            if (fieldInfo.hasTypeTag()) {
                size = fieldInfo.getTypeTag();
                encodingFlags = 3;
            }
            header |= (byte)(encodingFlags << 3);
            boolean bl = bigSize = size >= 7;
            if (bigSize) {
                buffer.writeByte(header |= 0xE0);
                buffer.writeVarUint32Small7(size - 7);
            } else {
                buffer.writeByte(header |= size << 5);
            }
            if (!fieldInfo.hasTypeTag()) {
                buffer.writeBytes(encoded);
            }
            fieldType.write(buffer, false);
        }
    }

    private static void writePkgName(MemoryBuffer buffer, String pkg) {
        MetaString pkgMetaString = Encoders.encodePackage(pkg);
        byte[] encoded = pkgMetaString.getBytes();
        ClassDefEncoder.writeName(buffer, encoded, Encoders.pkgEncodingsList.indexOf((Object)pkgMetaString.getEncoding()));
    }

    private static void writeTypeName(MemoryBuffer buffer, String typeName) {
        MetaString metaString = Encoders.encodeTypeName(typeName);
        byte[] encoded = metaString.getBytes();
        ClassDefEncoder.writeName(buffer, encoded, Encoders.typeNameEncodingsList.indexOf((Object)metaString.getEncoding()));
    }

    private static void writeName(MemoryBuffer buffer, byte[] encoded, int encoding) {
        boolean bigSize;
        boolean bl = bigSize = encoded.length >= 63;
        if (bigSize) {
            int header = 0xFC | encoding;
            buffer.writeByte(header);
            buffer.writeVarUint32Small7(encoded.length - 63);
        } else {
            int header = encoded.length << 2 | encoding;
            buffer.writeByte(header);
        }
        buffer.writeBytes(encoded);
    }
}

