/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.node.grpc.query.stages;

import org.apache.hugegraph.rocksdb.access.RocksDBSession;
import org.apache.hugegraph.serializer.DirectBinarySerializer;
import org.apache.hugegraph.store.node.grpc.query.QueryStage;
import org.apache.hugegraph.store.node.grpc.query.model.PipelineResult;
import org.apache.hugegraph.store.node.grpc.query.model.PipelineResultType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TtlCheckStage
implements QueryStage {
    private static final Logger log = LoggerFactory.getLogger(TtlCheckStage.class);
    private boolean isVertex;
    private final DirectBinarySerializer serializer = new DirectBinarySerializer();
    private long now;

    public void init(Object ... objects) {
        this.isVertex = (Boolean)objects[0];
        this.now = System.currentTimeMillis();
    }

    public PipelineResult handle(PipelineResult result) {
        if (result.getResultType() == PipelineResultType.BACKEND_COLUMN) {
            RocksDBSession.BackendColumn col = result.getColumn();
            try {
                DirectBinarySerializer.DirectHugeElement element;
                DirectBinarySerializer.DirectHugeElement directHugeElement = element = this.isVertex ? this.serializer.parseVertex(col.name, col.value) : this.serializer.parseEdge(col.name, col.value);
                if (element.expiredTime() > 0L && element.expiredTime() < this.now) {
                    return null;
                }
            }
            catch (Exception e) {
                log.error("parse element error", (Throwable)e);
                return null;
            }
        }
        return result;
    }

    public String getName() {
        return "TTL_CHECK_STAGE";
    }
}

