/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.node.grpc;

import com.google.protobuf.ByteString;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.util.Collections;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hugegraph.rocksdb.access.RocksDBSession;
import org.apache.hugegraph.rocksdb.access.ScanIterator;
import org.apache.hugegraph.store.grpc.common.Kv;
import org.apache.hugegraph.store.grpc.stream.KvPageRes;
import org.apache.hugegraph.store.grpc.stream.ScanStreamReq;
import org.apache.hugegraph.store.node.AppConfig;
import org.apache.hugegraph.store.node.grpc.HgStoreWrapperEx;
import org.apache.hugegraph.store.node.grpc.ScanUtil;
import org.apache.hugegraph.store.node.util.HgAssert;
import org.apache.hugegraph.store.node.util.HgChannel;
import org.apache.hugegraph.store.node.util.HgGrpc;
import org.apache.hugegraph.store.node.util.HgStoreNodeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanStreamResponse
implements StreamObserver<ScanStreamReq> {
    private static final Logger log = LoggerFactory.getLogger(ScanStreamResponse.class);
    private static final String msg = "to wait for client taking data exceeded max time: [{}] seconds,stop scanning.";
    private final StreamObserver<KvPageRes> responseObserver;
    private final HgStoreWrapperEx wrapper;
    private final AtomicBoolean finishFlag = new AtomicBoolean();
    private final ThreadPoolExecutor executor;
    private final AtomicBoolean isStarted = new AtomicBoolean();
    private final AtomicBoolean isStop = new AtomicBoolean(false);
    private final AppConfig config;
    private final int waitTime;
    private final HgChannel<KvPageRes.Builder> channel;
    private ScanIterator iterator;
    private long limit = 0L;
    private int times = 0;
    private long pageSize = 0L;
    private int total = 0;
    private String graph;
    private String table;

    ScanStreamResponse(StreamObserver<KvPageRes> responseObserver, HgStoreWrapperEx wrapper, ThreadPoolExecutor executor, AppConfig appConfig) {
        this.responseObserver = responseObserver;
        this.wrapper = wrapper;
        this.executor = executor;
        this.config = appConfig;
        this.waitTime = this.config.getServerWaitTime();
        this.channel = HgChannel.of((long)this.waitTime);
    }

    public static ScanStreamResponse of(StreamObserver<KvPageRes> responseObserver, HgStoreWrapperEx wrapper, ThreadPoolExecutor executor, AppConfig appConfig) {
        HgAssert.isArgumentNotNull(responseObserver, (String)"responseObserver");
        HgAssert.isArgumentNotNull((Object)wrapper, (String)"wrapper");
        HgAssert.isArgumentNotNull((Object)executor, (String)"executor");
        return new ScanStreamResponse(responseObserver, wrapper, executor, appConfig);
    }

    public void onNext(ScanStreamReq request) {
        try {
            if (request.getCloseFlag() == 1) {
                this.close();
            } else {
                this.next(request);
            }
        }
        catch (Exception e) {
            this.responseObserver.onError((Throwable)e);
        }
    }

    public void onError(Throwable t) {
        this.isStop.set(true);
        this.finishServer();
        log.warn("onError from client [ graph: {} , table: {}]; Reason: {}]", new Object[]{this.graph, this.table, t.getMessage()});
    }

    public void onCompleted() {
        this.isStop.set(true);
        this.finishServer();
    }

    private void initIterator(ScanStreamReq request) {
        try {
            if (this.isStarted.getAndSet(true)) {
                return;
            }
            this.iterator = ScanUtil.getIterator((ScanStreamReq)request, (HgStoreWrapperEx)this.wrapper);
            this.graph = request.getHeader().getGraph();
            this.table = request.getTable();
            this.limit = request.getLimit();
            this.pageSize = request.getPageSize();
            if (this.pageSize <= 0L) {
                log.warn("As page-Size is less than or equals 0, no data will be send to the client.");
            }
            Runnable scanning = () -> {
                KvPageRes.Builder dataBuilder = KvPageRes.newBuilder();
                Kv.Builder kvBuilder = Kv.newBuilder();
                int pageCount = 0;
                try {
                    while (this.iterator.hasNext() && (this.limit <= 0L || (long)(++this.total) <= this.limit)) {
                        if ((long)(++pageCount) > this.pageSize) {
                            long start = System.currentTimeMillis();
                            if (!this.channel.send((Object)dataBuilder)) {
                                if (System.currentTimeMillis() - start >= (long)this.waitTime * 1000L) {
                                    log.warn(msg, (Object)this.waitTime);
                                    this.timeoutSever();
                                }
                                return;
                            }
                            if (this.isStop.get()) {
                                return;
                            }
                            pageCount = 1;
                            dataBuilder = KvPageRes.newBuilder();
                        }
                        dataBuilder.addData(this.toKv(kvBuilder, (RocksDBSession.BackendColumn)this.iterator.next(), this.iterator.position()));
                    }
                    this.channel.send((Object)dataBuilder);
                }
                catch (Throwable t) {
                    String msg = "an exception occurred while scanning data:";
                    StatusRuntimeException ex = HgGrpc.toErr((Status)Status.INTERNAL, (String)(msg + t.getMessage()), (Throwable)t);
                    this.responseObserver.onError((Throwable)ex);
                }
                finally {
                    try {
                        this.iterator.close();
                        this.channel.close();
                    }
                    catch (Exception exception) {}
                }
            };
            this.executor.execute(scanning);
        }
        catch (Exception e) {
            StatusRuntimeException ex = HgGrpc.toErr((Status)Status.INTERNAL, null, (Throwable)e);
            this.responseObserver.onError((Throwable)ex);
            try {
                this.iterator.close();
                this.channel.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private Kv toKv(Kv.Builder kvBuilder, RocksDBSession.BackendColumn col, byte[] position) {
        return kvBuilder.setKey(ByteString.copyFrom((byte[])col.name)).setValue(ByteString.copyFrom((byte[])col.value)).setCode(HgStoreNodeUtil.toInt((byte[])position)).build();
    }

    private void close() {
        this.isStop.set(true);
        this.channel.close();
        if (!this.finishFlag.get()) {
            this.responseObserver.onNext((Object)KvPageRes.newBuilder().addAllData((Iterable)Collections.EMPTY_LIST).setOver(true).setTimes(++this.times).build());
        }
        this.finishServer();
    }

    private void next(ScanStreamReq request) {
        KvPageRes.Builder resBuilder;
        this.initIterator(request);
        try {
            resBuilder = (KvPageRes.Builder)this.channel.receive();
            ++this.times;
        }
        catch (Exception e) {
            String msg = "failed to poll a page of data, cause by:";
            log.error(msg, (Throwable)e);
            this.responseObserver.onError((Throwable)HgGrpc.toErr((String)(msg + e.getMessage())));
            return;
        }
        boolean isOver = false;
        if (resBuilder == null || resBuilder.getDataList() == null || resBuilder.getDataList().isEmpty()) {
            isOver = true;
            resBuilder = KvPageRes.newBuilder().addAllData((Iterable)Collections.EMPTY_LIST);
        }
        if (!this.finishFlag.get()) {
            this.responseObserver.onNext((Object)resBuilder.setOver(isOver).setTimes(this.times).build());
        }
        if (isOver) {
            this.finishServer();
        }
    }

    private void finishServer() {
        if (!this.finishFlag.getAndSet(true)) {
            this.responseObserver.onCompleted();
        }
    }

    private void timeoutSever() {
        if (!this.finishFlag.getAndSet(true)) {
            String msg = "server wait time exceeds the threshold[" + this.waitTime + "] seconds.";
            this.responseObserver.onError((Throwable)HgGrpc.toErr((Status.Code)Status.Code.DEADLINE_EXCEEDED, (String)msg));
        }
    }
}

