/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.node;

import org.apache.hugegraph.rocksdb.access.RocksDBFactory;

public class AppShutdownHook
extends Thread {
    private final Thread mainThread;
    private boolean shutDownSignalReceived;

    public AppShutdownHook(Thread mainThread) {
        this.mainThread = mainThread;
        this.shutDownSignalReceived = false;
        Runtime.getRuntime().addShutdownHook((Thread)this);
    }

    @Override
    public void run() {
        System.out.println("Shut down signal received.");
        this.shutDownSignalReceived = true;
        this.mainThread.interrupt();
        this.doSomethingForShutdown();
        try {
            this.mainThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println("Shut down complete.");
    }

    public boolean shouldShutDown() {
        return this.shutDownSignalReceived;
    }

    private void doSomethingForShutdown() {
        RocksDBFactory.getInstance().releaseAllGraphDB();
    }
}

