/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.commons.lang.dat;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import org.nlpcn.commons.lang.dat.BasicItem;
import org.nlpcn.commons.lang.dat.Item;
import org.nlpcn.commons.lang.util.FileIterator;
import org.nlpcn.commons.lang.util.IOUtil;
import org.nlpcn.commons.lang.util.StringUtil;

public class DoubleArrayTire {
    private Item[] dat;
    public int arrayLength;

    private DoubleArrayTire() {
    }

    public DoubleArrayTire(Item[] dat) {
        this.dat = dat;
        this.arrayLength = dat.length;
    }

    public Item[] getDAT() {
        return this.dat;
    }

    public int getId(String str) {
        Object item = this.getItem(str);
        return item != null ? ((Item)item).index : 0;
    }

    public <T extends Item> T getItem(String str) {
        if (StringUtil.isBlank(str)) {
            return null;
        }
        if (str.length() == 1) {
            return (T)this.dat[str.charAt(0)];
        }
        Item item = this.dat[str.charAt(0)];
        if (item == null) {
            return null;
        }
        for (int i = 1; i < str.length(); ++i) {
            int checkValue = item.index;
            if (item.base + str.charAt(i) > this.dat.length - 1) {
                return null;
            }
            item = this.dat[item.base + str.charAt(i)];
            if (item == null) {
                return null;
            }
            if (item.check == -1 || item.check == checkValue) continue;
            return null;
        }
        return (T)item;
    }

    public <T extends Item> T getItem(int id) {
        return (T)this.dat[id];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DoubleArrayTire load(String filePath) throws FileNotFoundException, IOException, ClassNotFoundException {
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(filePath)));
            DoubleArrayTire instance = new DoubleArrayTire();
            instance.dat = new Item[ois.readInt()];
            instance.arrayLength = ois.readInt();
            for (int i = 0; i < instance.arrayLength; ++i) {
                Item item;
                instance.dat[item.index] = item = (Item)ois.readObject();
            }
            DoubleArrayTire doubleArrayTire = instance;
            return doubleArrayTire;
        }
        finally {
            if (ois != null) {
                ois.close();
            }
        }
    }

    public static DoubleArrayTire loadText(String filePath, Class<? extends Item> cla) throws FileNotFoundException, InstantiationException, IllegalAccessException {
        return DoubleArrayTire.loadText(IOUtil.getInputStream(filePath), cla);
    }

    public static DoubleArrayTire loadText(InputStream is, Class<? extends Item> cla) throws FileNotFoundException, InstantiationException, IllegalAccessException {
        DoubleArrayTire obj = new DoubleArrayTire();
        FileIterator it = IOUtil.instanceFileIterator(is, "utf-8");
        if (it == null) {
            throw new FileNotFoundException();
        }
        String temp = it.next();
        obj.arrayLength = Integer.parseInt(temp);
        obj.dat = new Item[obj.arrayLength];
        while (it.hasNext()) {
            temp = it.next();
            Item item = cla.newInstance();
            item.initValue(temp.split("\t"));
            obj.dat[item.index] = item;
        }
        return obj;
    }

    public static DoubleArrayTire loadText(String filePath) throws FileNotFoundException, InstantiationException, IllegalAccessException {
        return DoubleArrayTire.loadText(filePath, BasicItem.class);
    }
}

