/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.commons.lang.dat;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.nlpcn.commons.lang.dat.BasicItem;
import org.nlpcn.commons.lang.dat.Item;
import org.nlpcn.commons.lang.tire.domain.SmartForest;
import org.nlpcn.commons.lang.util.FileIterator;
import org.nlpcn.commons.lang.util.IOUtil;
import org.nlpcn.commons.lang.util.StringUtil;

public class DATMaker {
    private static final Logger LOG = Logger.getLogger(DATMaker.class.getName());
    private final int capacity = 100000;
    private Item[] dat = new Item[100000];

    public void maker(String dicPath) throws Exception {
        this.maker(dicPath, BasicItem.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maker(String dicPath, Class<? extends Item> cla) throws FileNotFoundException, InstantiationException, IllegalAccessException {
        long start = System.currentTimeMillis();
        LOG.info("make basic tire begin !");
        SmartForest<Item> forest = new SmartForest<Item>();
        FileIterator it = IOUtil.instanceFileIterator(dicPath, "utf-8");
        if (it == null) {
            throw new FileNotFoundException();
        }
        try {
            while (it.hasNext()) {
                String temp = it.next();
                if (StringUtil.isBlank(temp)) continue;
                Item item = cla.newInstance();
                String[] split = temp.split("\t");
                item.init(split);
                forest.add(split[0], item);
            }
        }
        finally {
            it.close();
        }
        LOG.info("make basic tire over use time " + (System.currentTimeMillis() - start) + " ms");
        start = System.currentTimeMillis();
        LOG.info("make dat tire begin !");
        this.makeDAT(this.tree2List(cla, forest));
        LOG.info("make dat tire over use time " + (System.currentTimeMillis() - start) + " ms! dat len is " + this.datArrLen() + "! dat size is " + this.datItemSize());
    }

    private void makeDAT(List<Item> all) {
        for (int i = 0; i < all.size(); ++i) {
            Item item = all.get(i);
            char[] chars = item.name.toCharArray();
            int length = chars.length;
            if (length == 1) {
                item.check = -1;
                item.index = chars[0];
                this.dat[item.index] = item;
                continue;
            }
            Item pre = this.getPre(item);
            List<Item> group = this.findGroup(all, i, pre);
            this.item2DAT(pre, group);
            i = i + group.size() - 1;
        }
    }

    private List<Item> findGroup(List<Item> all, int i, Item pre) {
        Item tmp;
        ArrayList<Item> group = new ArrayList<Item>();
        group.add(all.get(i));
        for (int j = i + 1; j < all.size() && pre == this.getPre(tmp = all.get(j)); ++j) {
            group.add(tmp);
        }
        return group;
    }

    private void item2DAT(Item pre, List<Item> samePreGroup) {
        this.updateBaseValue(samePreGroup, pre);
        for (Item tmp : samePreGroup) {
            tmp.index = pre.base + this.getLastChar(tmp.name);
            this.dat[pre.base + this.getLastChar((String)tmp.name)] = tmp;
            tmp.check = pre.index;
        }
    }

    private void updateBaseValue(List<Item> samePreGroup, Item pre) {
        Iterator<Item> iterator = samePreGroup.iterator();
        while (iterator.hasNext()) {
            Item item = iterator.next();
            this.checkLength(pre.base + this.getLastChar(item.name));
            if (this.dat[pre.base + this.getLastChar(item.name)] == null) continue;
            ++pre.base;
            iterator = samePreGroup.iterator();
        }
    }

    private void checkLength(int len) {
        if (len >= this.dat.length) {
            this.dat = Arrays.copyOf(this.dat, len + 100000);
        }
    }

    public char getLastChar(String word) {
        return word.charAt(word.length() - 1);
    }

    public Item getPre(Item item) {
        char[] chars = item.name.toCharArray();
        int tempBase = 0;
        if (chars.length == 2) {
            return this.dat[chars[0]];
        }
        for (int i = 0; i < chars.length - 1; ++i) {
            if (i == 0) {
                tempBase += chars[i];
                continue;
            }
            tempBase = this.dat[tempBase].base + chars[i];
        }
        return this.dat[tempBase];
    }

    private List<Item> tree2List(Class<? extends Item> cla, SmartForest<Item> forest) throws InstantiationException, IllegalAccessException {
        ArrayList<Item> all = new ArrayList<Item>();
        this.treeToLibrary(cla, all, forest, "");
        return all;
    }

    private void treeToLibrary(Class<? extends Item> cla, List<Item> all, SmartForest<Item> sf, String preStr) throws InstantiationException, IllegalAccessException {
        SmartForest<Item>[] branches = sf.getBranches();
        if (branches == null) {
            return;
        }
        for (SmartForest<Item> branche : branches) {
            if (branche == null) continue;
            Item param = branche.getParam();
            if (param == null) {
                param = cla.newInstance();
                param.name = preStr + branche.getC();
                param.status = 1;
            } else {
                param.status = branche.getStatus();
            }
            all.add(param);
        }
        for (SmartForest<Item> branche : branches) {
            if (branche == null) continue;
            this.treeToLibrary(cla, all, branche, preStr + branche.getC());
        }
    }

    private int datArrLen() {
        for (int i = this.dat.length - 1; i >= 0; --i) {
            if (this.dat[i] == null) continue;
            return i + 1;
        }
        return 0;
    }

    private int datItemSize() {
        int size = 0;
        for (int i = this.dat.length - 1; i >= 0; --i) {
            if (this.dat[i] == null) continue;
            ++size;
        }
        return size;
    }

    public Item[] getDAT() {
        return this.dat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String path) throws IOException {
        ObjectOutput writer = null;
        try {
            writer = new ObjectOutputStream(new FileOutputStream(path));
            writer.writeInt(this.datArrLen());
            writer.writeInt(this.datItemSize());
            for (Item item : this.dat) {
                if (item == null) continue;
                writer.writeObject(item);
            }
        }
        finally {
            if (writer != null) {
                writer.flush();
                writer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveText(String path) throws IOException {
        Writer writer = null;
        try {
            writer = new FileWriter(new File(path));
            writer.write(String.valueOf(this.datArrLen()));
            writer.write(10);
            for (Item item : this.dat) {
                if (item == null) continue;
                writer.write(item.toString());
                writer.write(10);
            }
            writer.flush();
        }
        finally {
            if (writer != null) {
                writer.flush();
                writer.close();
            }
        }
    }
}

