/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.util;

import java.util.AbstractQueue;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hugegraph.pd.common.HgAssert;
import org.apache.hugegraph.pd.util.HgExecutorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public final class HgExecutorUtil {
    private static final Logger log = LoggerFactory.getLogger(HgExecutorUtil.class);
    private static final Map<String, ThreadPoolExecutor> EXECUTOR_MAP = new ConcurrentHashMap();
    private static final Executor COMMON_EXECUTOR = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), HgExecutorUtil.newThreadFactory((String)"pd-common"));

    public static void execute(Runnable command) {
        if (command == null) {
            return;
        }
        COMMON_EXECUTOR.execute(command);
    }

    public static ThreadFactory newThreadFactory(String namePrefix, int priority) {
        HgAssert.isArgumentNotNull((Object)namePrefix, (String)"namePrefix");
        return new HgThreadFactory(namePrefix, priority);
    }

    public static ThreadFactory newThreadFactory(String namePrefix) {
        HgAssert.isArgumentNotNull((Object)namePrefix, (String)"namePrefix");
        return new HgDefaultThreadFactory(namePrefix);
    }

    public static ThreadPoolExecutor getThreadPoolExecutor(String name) {
        if (name == null) {
            return null;
        }
        return (ThreadPoolExecutor)EXECUTOR_MAP.get(name);
    }

    @Deprecated
    public static Executor createExecutor(String name, int coreThreads, int maxThreads) {
        return HgExecutorUtil.createExecutor((String)name, (int)coreThreads, (int)maxThreads, (int)Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ThreadPoolExecutor createExecutor(String name, int coreThreads, int maxThreads, int queueSize) {
        ThreadPoolExecutor res = (ThreadPoolExecutor)EXECUTOR_MAP.get(name);
        if (res != null) {
            return res;
        }
        Map map = EXECUTOR_MAP;
        synchronized (map) {
            res = (ThreadPoolExecutor)EXECUTOR_MAP.get(name);
            if (res != null) {
                return res;
            }
            AbstractQueue queue = null;
            queue = queueSize <= 0 ? new SynchronousQueue() : new LinkedBlockingQueue(queueSize);
            res = new ThreadPoolExecutor(coreThreads, maxThreads, 60L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)((Object)queue), HgExecutorUtil.newThreadFactory((String)name));
            EXECUTOR_MAP.put(name, res);
        }
        return res;
    }
}

