/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.boot;

import java.util.concurrent.ThreadPoolExecutor;
import org.apache.hugegraph.pd.service.MetadataService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutdownHook
extends Thread {
    private static Logger log = LoggerFactory.getLogger(ShutdownHook.class);
    private static String msg = "there are still uninterruptible jobs that have not been completed and will wait for them to complete";
    private Thread main;

    public ShutdownHook(Thread main) {
        this.main = main;
    }

    @Override
    public void run() {
        log.info("shutdown signal received");
        this.main.interrupt();
        this.waitForShutdown();
        try {
            this.main.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        log.info("shutdown completed");
    }

    private void waitForShutdown() {
        this.checkUninterruptibleJobs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void checkUninterruptibleJobs() {
        ThreadPoolExecutor jobs;
        block10: {
            jobs = MetadataService.getUninterruptibleJobs();
            try {
                if (jobs == null) break block10;
                long lastPrint = System.currentTimeMillis() - 5000L;
                log.info("check for ongoing background jobs that cannot be interrupted, active:{}, queue:{}.", (Object)jobs.getActiveCount(), (Object)jobs.getQueue().size());
                while (jobs.getActiveCount() != 0 || jobs.getQueue().size() != 0) {
                    Class<ShutdownHook> clazz = ShutdownHook.class;
                    // MONITORENTER : org.apache.hugegraph.pd.boot.ShutdownHook.class
                    if (System.currentTimeMillis() - lastPrint > 5000L) {
                        log.warn(msg);
                        lastPrint = System.currentTimeMillis();
                    }
                    try {
                        ShutdownHook.class.wait(200L);
                    }
                    catch (InterruptedException e) {
                        log.error("close jobs with error:", (Throwable)e);
                    }
                }
                log.info("all ongoing background jobs have been completed and the shutdown will continue");
            }
            catch (Exception e) {
                log.error("close jobs with error:", (Throwable)e);
            }
        }
        try {
            if (jobs == null) return;
            jobs.shutdownNow();
            return;
        }
        catch (Exception e) {
            log.error("close jobs with error:", (Throwable)e);
        }
    }
}

