/*
 * Decompiled with CFR 0.152.
 */
package org.apdplat.word.util;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apdplat.word.util.WordConfTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryWatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(DirectoryWatcher.class);
    private WatchService watchService = null;
    private final Map<WatchKey, Path> directories = new HashMap<WatchKey, Path>();
    private static ExecutorService EXECUTOR_SERVICE = null;
    private WatchEvent.Kind<?>[] events;

    public static DirectoryWatcher getDirectoryWatcher(WatcherCallback watcherCallback, WatchEvent.Kind<?> ... kindArray) {
        if ("true".equals(WordConfTools.get("auto.detect", "true"))) {
            return new DirectoryWatcher(watcherCallback, kindArray);
        }
        LOGGER.warn("\u6ce8\u610f\uff1a\u672a\u542f\u7528\u81ea\u52a8\u68c0\u6d4b\u529f\u80fd\uff01\u5982\u9700\u542f\u7528\uff0c\u8bf7\u5728word.local.conf\u6587\u4ef6\u4e2d\u6307\u5b9a\u914d\u7f6e\u9879auto.detect=true");
        return new DirectoryWatcher(){

            @Override
            public void close() {
            }

            @Override
            public void watchDirectoryTree(Path path) {
            }

            @Override
            public void watchDirectoryTree(String string) {
            }

            @Override
            public void watchDirectory(Path path) {
            }

            @Override
            public void watchDirectory(String string) {
            }
        };
    }

    private DirectoryWatcher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DirectoryWatcher(final WatcherCallback watcherCallback, WatchEvent.Kind<?> ... kindArray) {
        try {
            if (kindArray.length == 0) {
                throw new RuntimeException("\u5fc5\u987b\u81f3\u5c11\u6307\u5b9a\u4e00\u4e2a\u76d1\u63a7\u7684\u4e8b\u4ef6\uff0c\u5982\uff1aStandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE");
            }
            Class<DirectoryWatcher> clazz = DirectoryWatcher.class;
            synchronized (DirectoryWatcher.class) {
                if (EXECUTOR_SERVICE == null) {
                    EXECUTOR_SERVICE = Executors.newCachedThreadPool();
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                this.events = new WatchEvent.Kind[kindArray.length];
                int n = 0;
                for (WatchEvent.Kind<?> kind : kindArray) {
                    this.events[n++] = kind;
                    LOGGER.info("\u6ce8\u518c\u4e8b\u4ef6\uff1a" + kind.name());
                }
                this.watchService = FileSystems.getDefault().newWatchService();
                EXECUTOR_SERVICE.submit(new Runnable(){

                    @Override
                    public void run() {
                        DirectoryWatcher.this.watch(watcherCallback);
                    }
                });
            }
        }
        catch (IOException iOException) {
            LOGGER.error("\u6784\u9020\u6587\u4ef6\u7cfb\u7edf\u76d1\u63a7\u670d\u52a1\u5931\u8d25\uff1a", (Throwable)iOException);
            throw new RuntimeException(iOException);
        }
    }

    public void watchDirectory(String string) {
        this.watchDirectory(Paths.get(string, new String[0]));
    }

    public void watchDirectory(Path path) {
        this.registerDirectory(path);
    }

    public void watchDirectoryTree(String string) {
        this.watchDirectoryTree(Paths.get(string, new String[0]));
    }

    public void watchDirectoryTree(Path path) {
        this.registerDirectoryTree(path);
    }

    public void close() {
        EXECUTOR_SERVICE.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void watch(WatcherCallback watcherCallback) {
        try {
            try {
                while (true) {
                    WatchKey watchKey;
                    if ((watchKey = this.watchService.take()) == null) {
                        continue;
                    }
                    for (WatchEvent<?> watchEvent : watchKey.pollEvents()) {
                        WatchEvent.Kind<?> kind = watchEvent.kind();
                        if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                        WatchEvent<?> watchEvent2 = watchEvent;
                        Path path = (Path)watchEvent2.context();
                        LOGGER.info("contextPath:" + path);
                        Path path2 = this.directories.get(watchKey);
                        LOGGER.info("directoryPath:" + path2);
                        Path path3 = path2.resolve(path);
                        LOGGER.info("absolutePath:" + path3);
                        LOGGER.info("kind:" + kind);
                        switch (kind.name()) {
                            case "ENTRY_CREATE": {
                                if (Files.isDirectory(path3, LinkOption.NOFOLLOW_LINKS)) {
                                    LOGGER.info("\u65b0\u589e\u76ee\u5f55\uff1a" + path3);
                                    this.registerDirectoryTree(path3);
                                    break;
                                }
                                LOGGER.info("\u65b0\u589e\u6587\u4ef6\uff1a" + path3);
                                break;
                            }
                            case "ENTRY_DELETE": {
                                LOGGER.info("\u5220\u9664\uff1a" + path3);
                                break;
                            }
                            case "ENTRY_MODIFY": {
                                LOGGER.info("\u4fee\u6539\uff1a" + path3);
                            }
                        }
                        watcherCallback.execute(kind, path3.toAbsolutePath().toString());
                    }
                    boolean bl = watchKey.reset();
                    if (bl || this.directories.get(watchKey) == null) continue;
                    LOGGER.info("\u505c\u6b62\u76d1\u63a7\u76ee\u5f55\uff1a" + this.directories.get(watchKey));
                    this.directories.remove(watchKey);
                }
            }
            catch (InterruptedException interruptedException) {
                LOGGER.info("\u76d1\u63a7\u76ee\u5f55\u7ebf\u7a0b\u9000\u51fa");
                try {
                    this.watchService.close();
                    LOGGER.info("\u5173\u95ed\u76d1\u63a7\u76ee\u5f55\u670d\u52a1");
                }
                catch (IOException iOException) {
                    LOGGER.error("\u5173\u95ed\u76d1\u63a7\u76ee\u5f55\u670d\u52a1\u51fa\u9519", (Throwable)iOException);
                }
            }
        }
        catch (Throwable throwable) {
            try {
                this.watchService.close();
                LOGGER.info("\u5173\u95ed\u76d1\u63a7\u76ee\u5f55\u670d\u52a1");
            }
            catch (IOException iOException) {
                LOGGER.error("\u5173\u95ed\u76d1\u63a7\u76ee\u5f55\u670d\u52a1\u51fa\u9519", (Throwable)iOException);
            }
            throw throwable;
        }
    }

    private void registerDirectoryTree(Path path) {
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                    DirectoryWatcher.this.registerDirectory(path);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException iOException) {
            LOGGER.error("\u76d1\u63a7\u76ee\u5f55\u5931\u8d25\uff1a" + path.toAbsolutePath(), (Throwable)iOException);
        }
    }

    private void registerDirectory(Path path) {
        try {
            LOGGER.info("\u76d1\u63a7\u76ee\u5f55:" + path);
            WatchKey watchKey = path.register(this.watchService, this.events);
            this.directories.put(watchKey, path);
        }
        catch (IOException iOException) {
            LOGGER.error("\u76d1\u63a7\u76ee\u5f55\u5931\u8d25\uff1a" + path.toAbsolutePath(), (Throwable)iOException);
        }
    }

    public static void main(String[] stringArray) {
        DirectoryWatcher directoryWatcher = new DirectoryWatcher(new WatcherCallback(){
            private long lastExecute = System.currentTimeMillis();

            @Override
            public void execute(WatchEvent.Kind<?> kind, String string) {
                if (System.currentTimeMillis() - this.lastExecute > 1000L) {
                    this.lastExecute = System.currentTimeMillis();
                    System.out.println("\u4e8b\u4ef6\uff1a" + kind.name() + " ,\u8def\u5f84\uff1a" + string);
                }
            }
        }, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
        directoryWatcher.watchDirectoryTree("d:/DIC");
        directoryWatcher.watchDirectory("d:/DIC2");
    }

    public static interface WatcherCallback {
        public void execute(WatchEvent.Kind<?> var1, String var2);
    }
}

