/*
 * Decompiled with CFR 0.152.
 */
package org.apdplat.word.segmentation.impl;

import java.util.List;
import java.util.Map;
import org.apdplat.word.segmentation.SegmentationAlgorithm;
import org.apdplat.word.segmentation.SegmentationFactory;
import org.apdplat.word.segmentation.Word;
import org.apdplat.word.segmentation.impl.AbstractSegmentation;

public class BidirectionalMaximumMatching
extends AbstractSegmentation {
    private static final AbstractSegmentation MM = (AbstractSegmentation)SegmentationFactory.getSegmentation(SegmentationAlgorithm.MaximumMatching);
    private static final AbstractSegmentation RMM = (AbstractSegmentation)SegmentationFactory.getSegmentation(SegmentationAlgorithm.ReverseMaximumMatching);

    @Override
    public SegmentationAlgorithm getSegmentationAlgorithm() {
        return SegmentationAlgorithm.BidirectionalMaximumMatching;
    }

    @Override
    public List<Word> segImpl(String string) {
        List<Word> list = RMM.seg(string);
        if (!this.ngramEnabled()) {
            return list;
        }
        List<Word> list2 = MM.seg(string);
        if (list.size() == list2.size() && list.equals(list2)) {
            return list;
        }
        Map<List<Word>, Float> map = this.ngram(list, list2);
        float f = map.get(list).floatValue();
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug("\u9006\u5411\u6700\u5927\u5339\u914d\uff1a" + list.toString() + " : ngram\u5206\u503c=" + f);
        }
        List<Word> list3 = list;
        float f2 = f;
        f = map.get(list2).floatValue();
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug("\u6b63\u5411\u6700\u5927\u5339\u914d\uff1a" + list2.toString() + " : ngram\u5206\u503c=" + f);
        }
        if (f > f2) {
            list3 = list2;
            f2 = f;
        }
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug("\u6700\u5927\u5206\u503c\uff1a" + f2 + ", \u6d88\u6b67\u7ed3\u679c\uff1a" + list3);
        }
        return list3;
    }

    public static void main(String[] stringArray) {
        String string = "APDPlat\u7684\u96cf\u5f62\u53ef\u4ee5\u8ffd\u6eaf\u52302008\u5e74\uff0c\u5e76\u4e8e4\u5e74\u540e\u53732012\u5e744\u67089\u65e5\u5728GITHUB\u5f00\u6e90 \u3002APDPlat\u5728\u6f14\u5316\u7684\u8fc7\u7a0b\u4e2d\uff0c\u7ecf\u53d7\u4f4f\u4e86\u4f17\u591a\u9879\u76ee\u7684\u8003\u9a8c\uff0c\u4e00\u76f4\u8ffd\u6c42\u7b80\u6d01\u4f18\u96c5\uff0c\u4e00\u76f4\u5bf9\u67b6\u6784\u3001\u8bbe\u8ba1\u548c\u4ee3\u7801\u8fdb\u884c\u91cd\u6784\u4f18\u5316\u3002 ";
        if (stringArray != null && stringArray.length == 1) {
            string = stringArray[0];
        }
        BidirectionalMaximumMatching bidirectionalMaximumMatching = new BidirectionalMaximumMatching();
        System.out.println(bidirectionalMaximumMatching.seg(string).toString());
    }
}

