/*
 * Decompiled with CFR 0.152.
 */
package org.apdplat.word.segmentation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apdplat.word.segmentation.SegmentationAlgorithm;
import org.apdplat.word.segmentation.SegmentationFactory;

public class SegmentationContrast {
    public static Map<String, String> seg(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (SegmentationAlgorithm segmentationAlgorithm : SegmentationAlgorithm.values()) {
            String string2 = SegmentationFactory.getSegmentation(segmentationAlgorithm).seg(string).toString();
            hashMap.put(segmentationAlgorithm.getDes(), string2);
        }
        return hashMap;
    }

    public static void dump(Map<String, String> map) {
        System.out.println("***************************************************");
        System.out.println("\u5207\u5206\u6548\u679c\u5bf9\u6bd4\uff1a");
        System.out.println("***************************************************");
        map.keySet().stream().sorted().forEach(string -> System.out.println(string + " : " + (String)map.get(string)));
        System.out.println("***************************************************");
    }

    public static void run(String string) {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in, string));){
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                if ("exit".equals(string2)) {
                    System.exit(0);
                    return;
                }
                if (string2.trim().equals("")) continue;
                SegmentationContrast.dump(SegmentationContrast.seg(string2));
                SegmentationContrast.showUsage();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void showUsage() {
        System.out.println("\u8f93\u5165exit\u9000\u51fa\u7a0b\u5e8f");
        System.out.println("\u8f93\u5165\u8981\u5206\u8bcd\u7684\u6587\u672c\u540e\u56de\u8f66\u786e\u8ba4\uff1a");
    }

    public static void main(String[] stringArray) {
        SegmentationContrast.dump(SegmentationContrast.seg("\u72ec\u7acb\u81ea\u4e3b\u548c\u5e73\u7b49\u4e92\u5229\u7684\u539f\u5219"));
        String string = "utf-8";
        if (stringArray == null || stringArray.length == 0) {
            SegmentationContrast.showUsage();
            SegmentationContrast.run(string);
        } else if (Charset.isSupported(stringArray[0])) {
            SegmentationContrast.showUsage();
            SegmentationContrast.run(stringArray[0]);
        }
    }
}

