/*
 * Decompiled with CFR 0.152.
 */
package org.apdplat.word.recognition;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apdplat.word.segmentation.Word;
import org.apdplat.word.util.AutoDetector;
import org.apdplat.word.util.ResourceLoader;
import org.apdplat.word.util.WordConfTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StopWord {
    private static final Logger LOGGER = LoggerFactory.getLogger(StopWord.class);
    private static final Set<String> stopwords = new HashSet<String>();

    public static void reload() {
        AutoDetector.loadAndWatch(new ResourceLoader(){

            @Override
            public void clear() {
                stopwords.clear();
            }

            @Override
            public void load(List<String> list) {
                LOGGER.info("\u521d\u59cb\u5316\u505c\u7528\u8bcd");
                for (String string : list) {
                    if (StopWord.isStopChar(string)) continue;
                    stopwords.add(string);
                }
                LOGGER.info("\u505c\u7528\u8bcd\u521d\u59cb\u5316\u5b8c\u6bd5\uff0c\u505c\u7528\u8bcd\u4e2a\u6570\uff1a" + stopwords.size());
            }

            @Override
            public void add(String string) {
                if (!StopWord.isStopChar(string)) {
                    stopwords.add(string);
                }
            }

            @Override
            public void remove(String string) {
                if (!StopWord.isStopChar(string)) {
                    stopwords.remove(string);
                }
            }
        }, WordConfTools.get("stopwords.path", "classpath:stopwords.txt"));
    }

    private static boolean isStopChar(String string) {
        if (string.length() == 1) {
            char c = string.charAt(0);
            if (c < '0') {
                return true;
            }
            if (c > '9' && c < '\u4e00') {
                return true;
            }
            if (c > '\u9fa5') {
                return true;
            }
        }
        return false;
    }

    public static boolean is(String string) {
        if (string == null) {
            return false;
        }
        return StopWord.isStopChar(string = string.trim()) || stopwords.contains(string);
    }

    public static void filterStopWords(List<Word> list) {
        Iterator<Word> iterator = list.iterator();
        while (iterator.hasNext()) {
            Word word = iterator.next();
            if (!StopWord.is(word.getText())) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u53bb\u9664\u505c\u7528\u8bcd\uff1a" + word.getText());
            }
            iterator.remove();
        }
    }

    public static void main(String[] stringArray) {
        LOGGER.info("\u505c\u7528\u8bcd\uff1a");
        int n = 1;
        for (String string : stopwords) {
            LOGGER.info(n++ + " : " + string);
        }
    }

    static {
        StopWord.reload();
    }
}

