/*
 * Decompiled with CFR 0.152.
 */
package org.apdplat.word.corpus;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apdplat.word.segmentation.Word;
import org.apdplat.word.util.AutoDetector;
import org.apdplat.word.util.DoubleArrayGenericTrie;
import org.apdplat.word.util.ResourceLoader;
import org.apdplat.word.util.WordConfTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bigram {
    private static final Logger LOGGER = LoggerFactory.getLogger(Bigram.class);
    private static final DoubleArrayGenericTrie DOUBLE_ARRAY_GENERIC_TRIE = new DoubleArrayGenericTrie(WordConfTools.getInt("bigram.double.array.trie.size", 5300000));
    private static int maxFrequency = 0;

    public static void reload() {
        AutoDetector.loadAndWatch(new ResourceLoader(){

            @Override
            public void clear() {
                DOUBLE_ARRAY_GENERIC_TRIE.clear();
            }

            @Override
            public void load(List<String> list) {
                LOGGER.info("\u521d\u59cb\u5316bigram");
                HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                for (String string : list) {
                    try {
                        this.addLine(string, hashMap);
                    }
                    catch (Exception exception) {
                        LOGGER.error("\u9519\u8bef\u7684bigram\u6570\u636e\uff1a" + string);
                    }
                }
                int n = hashMap.size();
                DOUBLE_ARRAY_GENERIC_TRIE.putAll(hashMap);
                LOGGER.info("bigram\u521d\u59cb\u5316\u5b8c\u6bd5\uff0cbigram\u6570\u636e\u6761\u6570\uff1a" + n);
            }

            @Override
            public void add(String string) {
                throw new RuntimeException("not yet support menthod!");
            }

            private void addLine(String string, Map<String, Integer> map) {
                String[] stringArray = string.split("\\s+");
                int n = Integer.parseInt(stringArray[1]);
                if (n > maxFrequency) {
                    maxFrequency = n;
                }
                map.put(stringArray[0], n);
            }

            @Override
            public void remove(String string) {
                throw new RuntimeException("not yet support menthod!");
            }
        }, WordConfTools.get("bigram.path", "classpath:bigram.txt"));
    }

    public static int getMaxFrequency() {
        return maxFrequency;
    }

    public static Map<List<Word>, Float> bigram(List<Word> ... listArray) {
        Object object;
        HashMap<List<Word>, Float> hashMap = new HashMap<List<Word>, Float>();
        HashMap<Object, Float> hashMap2 = new HashMap<Object, Float>();
        HashMap<String, Float> hashMap3 = new HashMap<String, Float>();
        for (List<Word> list2 : listArray) {
            if (hashMap.get(list2) != null) continue;
            float f = 0.0f;
            if (list2.size() > 1) {
                object = "";
                for (int i = 0; i < list2.size() - 1; ++i) {
                    String string;
                    Float[] floatArray = ((Word)list2.get(i)).getText();
                    float f2 = Bigram.getScore((String)floatArray, string = ((Word)list2.get(i + 1)).getText());
                    if (!(f2 > 0.0f)) continue;
                    if (((String)object).endsWith((String)floatArray)) {
                        hashMap3.put((String)object + string, Float.valueOf(((Float)hashMap2.get(object)).floatValue() + f2));
                        object = "";
                    }
                    object = (String)floatArray + string;
                    hashMap2.put(object, Float.valueOf(f2));
                    f += f2;
                }
            }
            hashMap.put(list2, Float.valueOf(f));
        }
        if (hashMap2.size() > 0 || hashMap3.size() > 0) {
            for (List list : hashMap.keySet()) {
                for (List<Word> list2 : list) {
                    Float[] floatArray;
                    Float f = (Float)hashMap2.get(((Word)((Object)list2)).getText());
                    object = (Float)hashMap3.get(((Word)((Object)list2)).getText());
                    for (Float f3 : floatArray = new Float[]{f, object}) {
                        if (f3 == null || !(f3.floatValue() > 0.0f)) continue;
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug(((Word)((Object)list2)).getText() + " \u83b7\u5f97\u5206\u503c\uff1a" + f3);
                        }
                        float f4 = ((Float)hashMap.get(list)).floatValue();
                        hashMap.put(list, Float.valueOf(f4 += f3.floatValue()));
                    }
                }
            }
        }
        return hashMap;
    }

    public static float bigram(List<Word> list) {
        if (list.size() > 1) {
            float f = 0.0f;
            for (int i = 0; i < list.size() - 1; ++i) {
                f += Bigram.getScore(list.get(i).getText(), list.get(i + 1).getText());
            }
            return f;
        }
        return 0.0f;
    }

    public static float getScore(String string, String string2) {
        int n = Bigram.getFrequency(string, string2);
        float f = (float)n / (float)maxFrequency;
        if (LOGGER.isDebugEnabled() && f > 0.0f) {
            LOGGER.debug("\u4e8c\u5143\u6a21\u578b " + string + ":" + string2 + " \u83b7\u5f97\u5206\u503c\uff1a" + f);
        }
        return f;
    }

    public static int getFrequency(String string, String string2) {
        Integer n = DOUBLE_ARRAY_GENERIC_TRIE.get(string + ":" + string2);
        if (n == null) {
            return 0;
        }
        return n;
    }

    static {
        Bigram.reload();
    }
}

