/*
 * Decompiled with CFR 0.152.
 */
package org.apdplat.word.analysis;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apdplat.word.analysis.TextSimilarity;
import org.apdplat.word.segmentation.Word;

public class SimpleTextSimilarity
extends TextSimilarity {
    @Override
    protected double scoreImpl(List<Word> list, List<Word> list2) {
        AtomicInteger atomicInteger = new AtomicInteger();
        list.parallelStream().forEach(word -> atomicInteger.addAndGet(word.getText().length()));
        AtomicInteger atomicInteger2 = new AtomicInteger();
        list2.parallelStream().forEach(word -> atomicInteger2.addAndGet(word.getText().length()));
        list.retainAll(list2);
        AtomicInteger atomicInteger3 = new AtomicInteger();
        list.parallelStream().forEach(word -> atomicInteger3.addAndGet(word.getText().length()));
        double d = (double)atomicInteger3.get() / (double)Math.max(atomicInteger.get(), atomicInteger2.get());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u8bcd\u5217\u88681\u603b\u7684\u5b57\u7b26\u6570\uff1a" + atomicInteger.get());
            LOGGER.debug("\u8bcd\u5217\u88682\u603b\u7684\u5b57\u7b26\u6570\uff1a" + atomicInteger2.get());
            LOGGER.debug("\u8bcd\u5217\u88681\u548c2\u5171\u6709\u7684\u8bcd\u7684\u603b\u7684\u5b57\u7b26\u6570\uff1a" + atomicInteger3.get());
            LOGGER.debug("\u76f8\u4f3c\u5ea6\u5206\u503c=" + atomicInteger3.get() + "/(double)Math.max(" + atomicInteger.get() + ", " + atomicInteger.get() + ")=" + d);
        }
        return d;
    }

    public static void main(String[] stringArray) {
        String string = "\u6211\u7231\u8d2d\u7269";
        String string2 = "\u6211\u7231\u8bfb\u4e66";
        String string3 = "\u4ed6\u662f\u9ed1\u5ba2";
        SimpleTextSimilarity simpleTextSimilarity = new SimpleTextSimilarity();
        double d = simpleTextSimilarity.similarScore(string, string);
        double d2 = simpleTextSimilarity.similarScore(string, string2);
        double d3 = simpleTextSimilarity.similarScore(string, string3);
        double d4 = simpleTextSimilarity.similarScore(string2, string2);
        double d5 = simpleTextSimilarity.similarScore(string2, string3);
        double d6 = simpleTextSimilarity.similarScore(string3, string3);
        System.out.println(string + " \u548c " + string + " \u7684\u76f8\u4f3c\u5ea6\u5206\u503c\uff1a" + d);
        System.out.println(string + " \u548c " + string2 + " \u7684\u76f8\u4f3c\u5ea6\u5206\u503c\uff1a" + d2);
        System.out.println(string + " \u548c " + string3 + " \u7684\u76f8\u4f3c\u5ea6\u5206\u503c\uff1a" + d3);
        System.out.println(string2 + " \u548c " + string2 + " \u7684\u76f8\u4f3c\u5ea6\u5206\u503c\uff1a" + d4);
        System.out.println(string2 + " \u548c " + string3 + " \u7684\u76f8\u4f3c\u5ea6\u5206\u503c\uff1a" + d5);
        System.out.println(string3 + " \u548c " + string3 + " \u7684\u76f8\u4f3c\u5ea6\u5206\u503c\uff1a" + d6);
    }
}

