/*
 * Decompiled with CFR 0.152.
 */
package org.apdplat.word.analysis;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apdplat.word.analysis.TextSimilarity;
import org.apdplat.word.segmentation.Word;
import org.apdplat.word.util.AtomicFloat;

public class ManhattanDistanceTextSimilarity
extends TextSimilarity {
    @Override
    protected double scoreImpl(List<Word> list, List<Word> list2) {
        this.taggingWeightWithWordFrequency(list, list2);
        Map<String, Float> map = this.toFastSearchMap(list);
        Map<String, Float> map2 = this.toFastSearchMap(list2);
        HashSet<Word> hashSet = new HashSet<Word>();
        hashSet.addAll(list);
        hashSet.addAll(list2);
        AtomicFloat atomicFloat = new AtomicFloat();
        hashSet.parallelStream().forEach(word -> {
            Float f = (Float)map.get(word.getText());
            Float f2 = (Float)map2.get(word.getText());
            if (f == null) {
                f = Float.valueOf(0.0f);
            }
            if (f2 == null) {
                f2 = Float.valueOf(0.0f);
            }
            float f3 = Math.abs(f.floatValue() - f2.floatValue());
            atomicFloat.addAndGet(f3);
        });
        double d = 0.0;
        d = atomicFloat.get() == 0.0f ? 1.0 : BigDecimal.valueOf(1L).divide(BigDecimal.valueOf(atomicFloat.get() + 1.0f), 9, 4).doubleValue();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u6587\u672c1\u548c\u6587\u672c2\u7684\u66fc\u54c8\u987f\u8ddd\u79bb\uff1a" + atomicFloat.get());
            LOGGER.debug("\u6587\u672c1\u548c\u6587\u672c2\u7684\u76f8\u4f3c\u5ea6\u5206\u503c\uff1a1 / (double)(" + atomicFloat.get() + "+1)=" + d);
        }
        return d;
    }

    public static void main(String[] stringArray) {
        String string = "\u6211\u7231\u8d2d\u7269";
        String string2 = "\u6211\u7231\u8bfb\u4e66";
        String string3 = "\u4ed6\u662f\u9ed1\u5ba2";
        ManhattanDistanceTextSimilarity manhattanDistanceTextSimilarity = new ManhattanDistanceTextSimilarity();
        double d = manhattanDistanceTextSimilarity.similarScore(string, string);
        double d2 = manhattanDistanceTextSimilarity.similarScore(string, string2);
        double d3 = manhattanDistanceTextSimilarity.similarScore(string, string3);
        double d4 = manhattanDistanceTextSimilarity.similarScore(string2, string2);
        double d5 = manhattanDistanceTextSimilarity.similarScore(string2, string3);
        double d6 = manhattanDistanceTextSimilarity.similarScore(string3, string3);
        System.out.println(string + " \u548c " + string + " \u7684\u76f8\u4f3c\u5ea6\u5206\u503c\uff1a" + d);
        System.out.println(string + " \u548c " + string2 + " \u7684\u76f8\u4f3c\u5ea6\u5206\u503c\uff1a" + d2);
        System.out.println(string + " \u548c " + string3 + " \u7684\u76f8\u4f3c\u5ea6\u5206\u503c\uff1a" + d3);
        System.out.println(string2 + " \u548c " + string2 + " \u7684\u76f8\u4f3c\u5ea6\u5206\u503c\uff1a" + d4);
        System.out.println(string2 + " \u548c " + string3 + " \u7684\u76f8\u4f3c\u5ea6\u5206\u503c\uff1a" + d5);
        System.out.println(string3 + " \u548c " + string3 + " \u7684\u76f8\u4f3c\u5ea6\u5206\u503c\uff1a" + d6);
    }
}

