/*
 * Decompiled with CFR 0.152.
 */
package org.apdplat.word.analysis;

import java.util.List;
import org.apdplat.word.analysis.JaroDistanceTextSimilarity;
import org.apdplat.word.segmentation.Word;

public class JaroWinklerDistanceTextSimilarity
extends JaroDistanceTextSimilarity {
    private static final double DEFAULT_SCALING_FACTOR = 0.1;
    private static final int MAXIMUM_CHARACTERS = 4;
    private double scalingFactor;

    public JaroWinklerDistanceTextSimilarity() {
        this.scalingFactor = 0.1;
    }

    public JaroWinklerDistanceTextSimilarity(double d) {
        if (d > 0.25) {
            d = 0.25;
        }
        if (d < 0.0) {
            d = 0.0;
        }
        this.scalingFactor = d;
    }

    @Override
    protected double scoreImpl(List<Word> list, List<Word> list2) {
        double d = super.scoreImpl(list, list2);
        d += this.scalingFactor * (double)this.commonPrefixLength() * (1.0 - d);
        return d;
    }

    private int commonPrefixLength() {
        int n = 0;
        int n2 = this.shorterText.length();
        for (int i = 0; i < n2 && this.shorterText.charAt(i) == this.longerText.charAt(i); ++i) {
            if (++n < 4) continue;
            return 4;
        }
        return n;
    }

    public static void main(String[] stringArray) {
        String string = "\u6211\u7231\u8d2d\u7269";
        String string2 = "\u6211\u7231\u8bfb\u4e66";
        String string3 = "\u4ed6\u662f\u9ed1\u5ba2";
        JaroWinklerDistanceTextSimilarity jaroWinklerDistanceTextSimilarity = new JaroWinklerDistanceTextSimilarity();
        double d = jaroWinklerDistanceTextSimilarity.similarScore(string, string);
        double d2 = jaroWinklerDistanceTextSimilarity.similarScore(string, string2);
        double d3 = jaroWinklerDistanceTextSimilarity.similarScore(string, string3);
        double d4 = jaroWinklerDistanceTextSimilarity.similarScore(string2, string2);
        double d5 = jaroWinklerDistanceTextSimilarity.similarScore(string2, string3);
        double d6 = jaroWinklerDistanceTextSimilarity.similarScore(string3, string3);
        System.out.println(string + " \u548c " + string + " \u7684\u76f8\u4f3c\u5ea6\u5206\u503c\uff1a" + d);
        System.out.println(string + " \u548c " + string2 + " \u7684\u76f8\u4f3c\u5ea6\u5206\u503c\uff1a" + d2);
        System.out.println(string + " \u548c " + string3 + " \u7684\u76f8\u4f3c\u5ea6\u5206\u503c\uff1a" + d3);
        System.out.println(string2 + " \u548c " + string2 + " \u7684\u76f8\u4f3c\u5ea6\u5206\u503c\uff1a" + d4);
        System.out.println(string2 + " \u548c " + string3 + " \u7684\u76f8\u4f3c\u5ea6\u5206\u503c\uff1a" + d5);
        System.out.println(string3 + " \u548c " + string3 + " \u7684\u76f8\u4f3c\u5ea6\u5206\u503c\uff1a" + d6);
    }
}

