/*
 * Decompiled with CFR 0.152.
 */
package org.apdplat.word.analysis;

import java.util.List;
import org.apdplat.word.analysis.TextSimilarity;
import org.apdplat.word.segmentation.Word;

public class EditDistanceTextSimilarity
extends TextSimilarity {
    @Override
    protected double scoreImpl(List<Word> list, List<Word> list2) {
        StringBuilder stringBuilder = new StringBuilder();
        list.forEach(word -> stringBuilder.append(word.getText()));
        StringBuilder stringBuilder2 = new StringBuilder();
        list2.forEach(word -> stringBuilder2.append(word.getText()));
        int n = Math.max(stringBuilder.length(), stringBuilder2.length());
        if (n == 0) {
            return 1.0;
        }
        int n2 = this.editDistance(stringBuilder.toString(), stringBuilder2.toString());
        double d = 1.0 - (double)n2 / (double)n;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u6587\u672c1\uff1a" + stringBuilder.toString());
            LOGGER.debug("\u6587\u672c2\uff1a" + stringBuilder2.toString());
            LOGGER.debug("\u6587\u672c1\u548c\u6587\u672c2\u7684\u7f16\u8f91\u8ddd\u79bb\uff1a" + n2);
            LOGGER.debug("\u6587\u672c1\u548c\u6587\u672c2\u7684\u6700\u5927\u957f\u5ea6\uff1a" + n);
            LOGGER.debug("\u6587\u672c1\u548c\u6587\u672c2\u7684\u76f8\u4f3c\u5ea6\u5206\u503c\uff1a1 - " + n2 + " / (double)" + n + "=" + d);
        }
        return d;
    }

    private int editDistance(String string, String string2) {
        int[] nArray = new int[string2.length() + 1];
        for (int i = 0; i <= string.length(); ++i) {
            int n = i;
            for (int j = 0; j <= string2.length(); ++j) {
                if (i == 0) {
                    nArray[j] = j;
                    continue;
                }
                if (j <= 0) continue;
                int n2 = nArray[j - 1];
                if (string.charAt(i - 1) != string2.charAt(j - 1)) {
                    n2 = Math.min(Math.min(n2, n), nArray[j]) + 1;
                }
                nArray[j - 1] = n;
                n = n2;
            }
            if (i <= 0) continue;
            nArray[string2.length()] = n;
        }
        return nArray[string2.length()];
    }

    public static void main(String[] stringArray) {
        String string = "\u6211\u7231\u8d2d\u7269";
        String string2 = "\u6211\u7231\u8bfb\u4e66";
        String string3 = "\u4ed6\u662f\u9ed1\u5ba2";
        EditDistanceTextSimilarity editDistanceTextSimilarity = new EditDistanceTextSimilarity();
        double d = editDistanceTextSimilarity.similarScore(string, string);
        double d2 = editDistanceTextSimilarity.similarScore(string, string2);
        double d3 = editDistanceTextSimilarity.similarScore(string, string3);
        double d4 = editDistanceTextSimilarity.similarScore(string2, string2);
        double d5 = editDistanceTextSimilarity.similarScore(string2, string3);
        double d6 = editDistanceTextSimilarity.similarScore(string3, string3);
        System.out.println(string + " \u548c " + string + " \u7684\u76f8\u4f3c\u5ea6\u5206\u503c\uff1a" + d);
        System.out.println(string + " \u548c " + string2 + " \u7684\u76f8\u4f3c\u5ea6\u5206\u503c\uff1a" + d2);
        System.out.println(string + " \u548c " + string3 + " \u7684\u76f8\u4f3c\u5ea6\u5206\u503c\uff1a" + d3);
        System.out.println(string2 + " \u548c " + string2 + " \u7684\u76f8\u4f3c\u5ea6\u5206\u503c\uff1a" + d4);
        System.out.println(string2 + " \u548c " + string3 + " \u7684\u76f8\u4f3c\u5ea6\u5206\u503c\uff1a" + d5);
        System.out.println(string3 + " \u548c " + string3 + " \u7684\u76f8\u4f3c\u5ea6\u5206\u503c\uff1a" + d6);
    }
}

