/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.nio.ByteBuffer;
import org.rocksdb.AbstractRocksIterator;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.util.BufferUtil;

public class RocksIterator
extends AbstractRocksIterator<RocksDB> {
    protected RocksIterator(RocksDB rocksDB, long l) {
        super(rocksDB, l);
    }

    public byte[] key() {
        assert (this.isOwningHandle());
        return this.key0(this.nativeHandle_);
    }

    public int key(byte[] byArray) {
        assert (this.isOwningHandle());
        return this.keyByteArray0(this.nativeHandle_, byArray, 0, byArray.length);
    }

    public int key(byte[] byArray, int n, int n2) {
        assert (this.isOwningHandle());
        BufferUtil.CheckBounds(n, n2, byArray.length);
        return this.keyByteArray0(this.nativeHandle_, byArray, n, n2);
    }

    public int key(ByteBuffer byteBuffer) {
        int n;
        assert (this.isOwningHandle());
        if (byteBuffer.isDirect()) {
            n = this.keyDirect0(this.nativeHandle_, byteBuffer, byteBuffer.position(), byteBuffer.remaining());
        } else {
            assert (byteBuffer.hasArray());
            n = this.keyByteArray0(this.nativeHandle_, byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
        }
        byteBuffer.limit(Math.min(byteBuffer.position() + n, byteBuffer.limit()));
        return n;
    }

    public byte[] value() {
        assert (this.isOwningHandle());
        return this.value0(this.nativeHandle_);
    }

    public int value(ByteBuffer byteBuffer) {
        int n;
        assert (this.isOwningHandle());
        if (byteBuffer.isDirect()) {
            n = this.valueDirect0(this.nativeHandle_, byteBuffer, byteBuffer.position(), byteBuffer.remaining());
        } else {
            assert (byteBuffer.hasArray());
            n = this.valueByteArray0(this.nativeHandle_, byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
        }
        byteBuffer.limit(Math.min(byteBuffer.position() + n, byteBuffer.limit()));
        return n;
    }

    public int value(byte[] byArray) {
        assert (this.isOwningHandle());
        return this.valueByteArray0(this.nativeHandle_, byArray, 0, byArray.length);
    }

    public int value(byte[] byArray, int n, int n2) {
        assert (this.isOwningHandle());
        BufferUtil.CheckBounds(n, n2, byArray.length);
        return this.valueByteArray0(this.nativeHandle_, byArray, n, n2);
    }

    @Override
    protected final native void disposeInternal(long var1);

    @Override
    final native boolean isValid0(long var1);

    @Override
    final native void seekToFirst0(long var1);

    @Override
    final native void seekToLast0(long var1);

    @Override
    final native void next0(long var1);

    @Override
    final native void prev0(long var1);

    @Override
    final native void refresh0(long var1);

    @Override
    final native void seek0(long var1, byte[] var3, int var4);

    @Override
    final native void seekForPrev0(long var1, byte[] var3, int var4);

    @Override
    final native void seekDirect0(long var1, ByteBuffer var3, int var4, int var5);

    @Override
    final native void seekByteArray0(long var1, byte[] var3, int var4, int var5);

    @Override
    final native void seekForPrevDirect0(long var1, ByteBuffer var3, int var4, int var5);

    @Override
    final native void seekForPrevByteArray0(long var1, byte[] var3, int var4, int var5);

    @Override
    final native void status0(long var1) throws RocksDBException;

    private native byte[] key0(long var1);

    private native byte[] value0(long var1);

    private native int keyDirect0(long var1, ByteBuffer var3, int var4, int var5);

    private native int keyByteArray0(long var1, byte[] var3, int var4, int var5);

    private native int valueDirect0(long var1, ByteBuffer var3, int var4, int var5);

    private native int valueByteArray0(long var1, byte[] var3, int var4, int var5);
}

