/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.query;

import com.google.common.util.concurrent.AtomicDouble;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hugegraph.store.query.Tuple2;
import org.apache.hugegraph.store.query.concurrent.AtomicFloat;

public class KvSerializer {
    private static final byte TYPE_INT = 0;
    private static final byte TYPE_LONG = 1;
    private static final byte TYPE_FLOAT = 2;
    private static final byte TYPE_DOUBLE = 3;
    private static final byte TYPE_STRING = 4;
    private static final byte TYPE_BIG_DECIMAL = 5;
    private static final byte TYPE_TUPLE2 = 6;
    private static final byte TYPE_AT_INT = 7;
    private static final byte TYPE_AT_LONG = 8;
    private static final byte TYPE_AT_FLOAT = 9;
    private static final byte TYPE_AT_DOUBLE = 10;
    private static final byte TYPE_NULL = 127;

    public static byte[] toBytes(List<Object> list) {
        ByteBuffer buffer = ByteBuffer.allocate(list == null ? 4 : list.size() * 4 + 4);
        if (list == null) {
            buffer.putInt(-1);
        } else {
            buffer.putInt(list.size());
            for (Object o : list) {
                buffer = KvSerializer.write(buffer, o);
            }
        }
        byte[] bytes = buffer.array();
        int position = buffer.position();
        if (position == bytes.length) {
            return bytes;
        }
        return Arrays.copyOf(bytes, position);
    }

    public static List<Comparable> fromBytes(byte[] bytes) {
        ArrayList<Comparable> list = new ArrayList<Comparable>();
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        int n = buffer.getInt();
        for (int i = 0; i < n; ++i) {
            list.add((Comparable)KvSerializer.read(buffer));
        }
        return list;
    }

    public static List<Object> fromObjectBytes(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        int n = buffer.getInt();
        if (n == -1) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < n; ++i) {
            list.add(KvSerializer.read(buffer));
        }
        return list;
    }

    private static Object read(ByteBuffer buffer) {
        byte b = buffer.get();
        switch (b) {
            case 0: {
                return KvSerializer.readInt(buffer);
            }
            case 7: {
                return new AtomicInteger(KvSerializer.readInt(buffer));
            }
            case 1: {
                return KvSerializer.readLong(buffer);
            }
            case 8: {
                return new AtomicLong(KvSerializer.readLong(buffer));
            }
            case 2: {
                return Float.valueOf(KvSerializer.readFloat(buffer));
            }
            case 9: {
                return new AtomicFloat(KvSerializer.readFloat(buffer));
            }
            case 3: {
                return KvSerializer.readDouble(buffer);
            }
            case 10: {
                return new AtomicDouble(KvSerializer.readDouble(buffer));
            }
            case 4: {
                return KvSerializer.readString(buffer);
            }
            case 5: {
                return KvSerializer.readBigDecimal(buffer);
            }
            case 6: {
                return KvSerializer.readTuple2(buffer);
            }
            case 127: {
                return null;
            }
        }
        throw new RuntimeException("unsupported type " + b);
    }

    private static ByteBuffer write(ByteBuffer buffer, Object o) {
        if (o == null) {
            buffer = KvSerializer.writeByte(buffer, (byte)127);
            return buffer;
        }
        if (o instanceof Integer) {
            buffer = KvSerializer.writeByte(buffer, (byte)0);
            buffer = KvSerializer.writeInt(buffer, (Integer)o);
            return buffer;
        }
        if (o instanceof Long) {
            buffer = KvSerializer.writeByte(buffer, (byte)1);
            buffer = KvSerializer.writeLong(buffer, (Long)o);
            return buffer;
        }
        if (o instanceof Float) {
            buffer = KvSerializer.writeByte(buffer, (byte)2);
            buffer = KvSerializer.writeFloat(buffer, ((Float)o).floatValue());
            return buffer;
        }
        if (o instanceof Double) {
            buffer = KvSerializer.writeByte(buffer, (byte)3);
            buffer = KvSerializer.writeDouble(buffer, (Double)o);
            return buffer;
        }
        if (o instanceof BigDecimal) {
            buffer = KvSerializer.writeByte(buffer, (byte)5);
            buffer = KvSerializer.writeBigDecimal(buffer, (BigDecimal)o);
            return buffer;
        }
        if (o instanceof String) {
            buffer = KvSerializer.writeByte(buffer, (byte)4);
            buffer = KvSerializer.writeString(buffer, (String)o);
            return buffer;
        }
        if (o instanceof AtomicInteger) {
            buffer = KvSerializer.writeByte(buffer, (byte)7);
            buffer = KvSerializer.writeInt(buffer, ((AtomicInteger)o).get());
            return buffer;
        }
        if (o instanceof AtomicLong) {
            buffer = KvSerializer.writeByte(buffer, (byte)8);
            buffer = KvSerializer.writeLong(buffer, ((AtomicLong)o).get());
            return buffer;
        }
        if (o instanceof AtomicFloat) {
            buffer = KvSerializer.writeByte(buffer, (byte)9);
            buffer = KvSerializer.writeFloat(buffer, ((AtomicFloat)o).get());
            return buffer;
        }
        if (o instanceof AtomicDouble) {
            buffer = KvSerializer.writeByte(buffer, (byte)10);
            buffer = KvSerializer.writeDouble(buffer, ((AtomicDouble)o).get());
            return buffer;
        }
        if (o instanceof Tuple2) {
            buffer = KvSerializer.writeByte(buffer, (byte)6);
            buffer = KvSerializer.write(buffer, ((Tuple2)o).getV1());
            buffer = KvSerializer.write(buffer, ((Tuple2)o).getV2());
            return buffer;
        }
        throw new RuntimeException("unsupported type " + o.getClass().getName());
    }

    private static ByteBuffer writeByte(ByteBuffer buffer, byte b) {
        buffer = KvSerializer.ensureCapacity(buffer, 1);
        buffer.put(b);
        return buffer;
    }

    private static ByteBuffer writeInt(ByteBuffer buffer, int i) {
        buffer = KvSerializer.ensureCapacity(buffer, 4);
        buffer.putInt(i);
        return buffer;
    }

    private static int readInt(ByteBuffer buffer) {
        return buffer.getInt();
    }

    private static ByteBuffer writeLong(ByteBuffer buffer, long l) {
        buffer = KvSerializer.ensureCapacity(buffer, 8);
        buffer.putLong(l);
        return buffer;
    }

    private static long readLong(ByteBuffer buffer) {
        return buffer.getLong();
    }

    private static ByteBuffer writeFloat(ByteBuffer buffer, float f) {
        buffer = KvSerializer.ensureCapacity(buffer, 4);
        buffer.putFloat(f);
        return buffer;
    }

    private static float readFloat(ByteBuffer buffer) {
        return buffer.getFloat();
    }

    private static ByteBuffer writeDouble(ByteBuffer buffer, double d) {
        buffer = KvSerializer.ensureCapacity(buffer, 8);
        buffer.putDouble(d);
        return buffer;
    }

    private static double readDouble(ByteBuffer buffer) {
        return buffer.getDouble();
    }

    private static ByteBuffer writeString(ByteBuffer buffer, String s) {
        byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
        buffer = KvSerializer.ensureCapacity(buffer, bytes.length + 4);
        buffer.putInt(bytes.length);
        buffer.put(bytes);
        return buffer;
    }

    private static String readString(ByteBuffer buffer) {
        int len = buffer.getInt();
        byte[] bytes = new byte[len];
        buffer.get(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private static ByteBuffer writeBigDecimal(ByteBuffer buffer, BigDecimal d) {
        return KvSerializer.writeString(buffer, d.toString());
    }

    private static BigDecimal readBigDecimal(ByteBuffer buffer) {
        return new BigDecimal(KvSerializer.readString(buffer));
    }

    private static Tuple2 readTuple2(ByteBuffer buffer) {
        return Tuple2.of(KvSerializer.read(buffer), KvSerializer.read(buffer));
    }

    private static ByteBuffer ensureCapacity(ByteBuffer buffer, int capacity) {
        if (buffer.remaining() < capacity) {
            ByteBuffer newBuffer = ByteBuffer.allocate(buffer.capacity() * 2 + capacity);
            buffer.flip();
            newBuffer.put(buffer);
            buffer = newBuffer;
        }
        return buffer;
    }
}

