/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.buffer;

import java.nio.ByteBuffer;

public class KVByteBuffer {
    ByteBuffer buffer;

    public KVByteBuffer(int capacity) {
        this.buffer = ByteBuffer.allocate(capacity);
    }

    public KVByteBuffer(byte[] buffer) {
        this.buffer = ByteBuffer.wrap(buffer);
    }

    public KVByteBuffer(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    public void clear() {
        this.buffer.clear();
    }

    public KVByteBuffer flip() {
        this.buffer.flip();
        return this;
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public ByteBuffer copyBuffer() {
        byte[] buf = new byte[this.buffer.position()];
        System.arraycopy(this.buffer.array(), 0, buf, 0, this.buffer.position());
        return ByteBuffer.wrap(buf);
    }

    public void put(byte data) {
        this.buffer.put(data);
    }

    public void put(byte[] data) {
        if (data != null) {
            this.buffer.putInt(data.length);
            this.buffer.put(data);
        }
    }

    public byte[] getBytes() {
        int len = this.buffer.getInt();
        byte[] data = new byte[len];
        this.buffer.get(data);
        return data;
    }

    public byte get() {
        return this.buffer.get();
    }

    public void putInt(int data) {
        this.buffer.putInt(data);
    }

    public int getInt() {
        return this.buffer.getInt();
    }

    public byte[] array() {
        return this.buffer.array();
    }

    public int position() {
        return this.buffer.position();
    }

    public final boolean hasRemaining() {
        return this.buffer.hasRemaining();
    }
}

