/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.configuration2.Configuration;
import org.apache.tinkerpop.gremlin.AbstractGraphProvider;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.TestHelper;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.io.Storage;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONResourceAccess;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoResourceAccess;
import org.apache.tinkerpop.gremlin.structure.io.script.ScriptResourceAccess;

public abstract class AbstractFileGraphProvider
extends AbstractGraphProvider {
    protected static final Random RANDOM = TestHelper.RANDOM;
    protected boolean graphSONInput = false;
    public static Map<String, String> PATHS = new HashMap<String, String>();

    @Override
    public void clear(Graph graph, Configuration configuration) throws Exception {
        if (graph != null) {
            graph.close();
        }
    }

    protected String getInputLocation(Graph g, LoadGraphWith.GraphData graphData) {
        String type;
        String string = type = this.graphSONInput ? "-v3d0.json" : "-v3d0.kryo";
        if (graphData.equals((Object)LoadGraphWith.GraphData.GRATEFUL)) {
            return PATHS.get("grateful-dead" + type);
        }
        if (graphData.equals((Object)LoadGraphWith.GraphData.MODERN)) {
            return PATHS.get("tinkerpop-modern" + type);
        }
        if (graphData.equals((Object)LoadGraphWith.GraphData.CLASSIC)) {
            return PATHS.get("tinkerpop-classic" + type);
        }
        if (graphData.equals((Object)LoadGraphWith.GraphData.CREW)) {
            return PATHS.get("tinkerpop-crew" + type);
        }
        if (graphData.equals((Object)LoadGraphWith.GraphData.SINK)) {
            return PATHS.get("tinkerpop-sink" + type);
        }
        throw new RuntimeException("Could not load graph with " + (Object)((Object)graphData));
    }

    static {
        try {
            List<String> kryoResources = Arrays.asList("tinkerpop-modern-v3d0.kryo", "grateful-dead-v3d0.kryo", "tinkerpop-classic-v3d0.kryo", "tinkerpop-crew-v3d0.kryo", "tinkerpop-sink-v3d0.kryo");
            for (String string : kryoResources) {
                PATHS.put(string, Storage.toPath((File)TestHelper.generateTempFileFromResource(GryoResourceAccess.class, (String)string, (String)"")));
            }
            List<String> graphsonResources = Arrays.asList("tinkerpop-modern-typed-v2d0.json", "tinkerpop-modern-v3d0.json", "grateful-dead-typed-v2d0.json", "grateful-dead-v3d0.json", "tinkerpop-classic-typed-v2d0.json", "tinkerpop-classic-v3d0.json", "tinkerpop-crew-typed-v2d0.json", "tinkerpop-crew-v3d0.json", "tinkerpop-sink-v3d0.json");
            for (String fileName : graphsonResources) {
                PATHS.put(fileName, Storage.toPath((File)TestHelper.generateTempFileFromResource(GraphSONResourceAccess.class, (String)fileName, (String)"")));
            }
            List<String> list = Arrays.asList("tinkerpop-classic.txt", "script-input.groovy", "script-output.groovy", "grateful-dead.txt", "script-input-grateful-dead.groovy", "script-output-grateful-dead.groovy");
            for (String fileName : list) {
                PATHS.put(fileName, Storage.toPath((File)TestHelper.generateTempFileFromResource(ScriptResourceAccess.class, (String)fileName, (String)"")));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

