/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.palo;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.hugegraph.backend.BackendException;
import org.apache.hugegraph.backend.store.palo.PaloOptions;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.util.E;

public class PaloFile
extends File {
    private static final long serialVersionUID = -1918775445693598353L;

    public PaloFile(String dir, String subDir, String fileName) {
        this(Paths.get(dir, subDir, fileName).toString());
    }

    public PaloFile(String path, int id, int part) {
        this(Paths.get(path, PaloFile.formatFileName(id, part)).toString());
    }

    public PaloFile(String path) {
        super(path);
    }

    public String table() {
        return this.getParentFile().getName();
    }

    public int sessionId() {
        String[] parts = this.getName().split("-");
        E.checkState((parts.length == 2 ? 1 : 0) != 0, (String)"Invalid file name format '%s' for palo temp file, the legal format is session{m}-part{n}", (Object[])new Object[]{this.getName()});
        return Integer.parseInt(parts[0].substring("session".length()));
    }

    public int sessionPart() {
        String[] parts = this.getName().split("-");
        E.checkState((parts.length == 2 ? 1 : 0) != 0, (String)"Invalid file name format '%s' for palo temp file, the legal format is session{m}-part{n}", (Object[])new Object[]{this.getName()});
        return Integer.parseInt(parts[1].substring("part".length()));
    }

    public int writeLines(Collection<String> lines) {
        try {
            FileUtils.writeLines((File)this, (String)Charsets.UTF_8.name(), lines, (boolean)true);
        }
        catch (IOException e) {
            throw new BackendException((Throwable)e);
        }
        return lines.size();
    }

    public String readAsString() {
        try {
            return FileUtils.readFileToString((File)this);
        }
        catch (IOException e) {
            throw new BackendException((Throwable)e);
        }
    }

    public void forceDelete() {
        if (this.exists()) {
            try {
                FileUtils.forceDelete((File)this);
            }
            catch (IOException e) {
                throw new BackendException((Throwable)e);
            }
        }
    }

    public static void clearDir(String tempDir) {
        File file = FileUtils.getFile((String[])new String[]{tempDir});
        if (!file.exists()) {
            return;
        }
        try {
            FileUtils.forceDelete((File)file);
        }
        catch (IOException e) {
            throw new BackendException((Throwable)e);
        }
    }

    public static List<PaloFile> scan(String path, List<String> tableDirs) {
        File directory = FileUtils.getFile((String[])new String[]{path});
        if (!directory.exists()) {
            return ImmutableList.of();
        }
        File[] subDirs = directory.listFiles((File dir, String name) -> tableDirs.contains(name));
        if (subDirs == null || subDirs.length == 0) {
            return ImmutableList.of();
        }
        ArrayList<PaloFile> paloFiles = new ArrayList<PaloFile>(subDirs.length);
        for (File subDir : subDirs) {
            String[] fileNames = subDir.list();
            if (fileNames == null) continue;
            for (String fileName : fileNames) {
                paloFiles.add(new PaloFile(path, subDir.getName(), fileName));
            }
        }
        paloFiles.sort((file1, file2) -> (int)(file1.lastModified() - file2.lastModified()));
        return paloFiles;
    }

    private static String formatFileName(int id, int part) {
        return String.format("session%s-part%s", id, part);
    }

    private static int[] parseFileName(String fileName) {
        String[] nameParts = fileName.split("-");
        E.checkArgument((nameParts.length == 2 ? 1 : 0) != 0, (String)"Invalid file name format '%s' for palo temp file, the legal format is session{m}-part{n}", (Object[])new Object[]{fileName});
        int[] rs = new int[]{Integer.parseInt(nameParts[0].substring("session".length())), Integer.parseInt(nameParts[1].substring("part".length()))};
        return rs;
    }

    public static long limitSize(HugeConfig config) {
        long limitSize = ((Integer)config.get(PaloOptions.PALO_FILE_LIMIT_SIZE)).intValue();
        return limitSize * 1024L * 1024L;
    }

    public static Set<Integer> scanSessionIds(HugeConfig config, List<String> tableDirs) {
        HashSet<Integer> sessionIds = new HashSet<Integer>();
        String path = (String)config.get(PaloOptions.PALO_TEMP_DIR);
        File pathDir = Paths.get(path, new String[0]).toFile();
        if (!pathDir.exists()) {
            return sessionIds;
        }
        for (String table : tableDirs) {
            String[] fileNames;
            File tableDir = Paths.get(path, table).toFile();
            if (!tableDir.exists() || (fileNames = tableDir.list()) == null || fileNames.length == 0) continue;
            for (String fileName : fileNames) {
                int[] parts = PaloFile.parseFileName(fileName);
                int sessionId = parts[0];
                sessionIds.add(sessionId);
            }
        }
        return sessionIds;
    }
}

