/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecluster.messenger;

import com.google.common.collect.Maps;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tags;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.schedulers.Timed;
import io.reactivex.rxjava3.subjects.PublishSubject;
import io.reactivex.rxjava3.subjects.Subject;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.bifromq.basecluster.messenger.Gossiper;
import org.apache.bifromq.basecluster.messenger.IMessenger;
import org.apache.bifromq.basecluster.messenger.IRecipientSelector;
import org.apache.bifromq.basecluster.messenger.MessageEnvelope;
import org.apache.bifromq.basecluster.messenger.MessengerMessageEnvelope;
import org.apache.bifromq.basecluster.messenger.MessengerOptions;
import org.apache.bifromq.basecluster.messenger.MessengerTransport;
import org.apache.bifromq.basecluster.messenger.proto.DirectMessage;
import org.apache.bifromq.basecluster.messenger.proto.GossipMessage;
import org.apache.bifromq.basecluster.messenger.proto.MessengerMessage;
import org.apache.bifromq.basecluster.proto.ClusterMessage;
import org.apache.bifromq.basecluster.transport.ITransport;
import org.apache.bifromq.basecluster.util.RandomUtils;
import org.apache.bifromq.baseenv.ZeroCopyParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Messenger
implements IMessenger {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Messenger.class);
    private final MessengerTransport transport;
    private final CompositeDisposable disposables = new CompositeDisposable();
    private final InetSocketAddress localAddress;
    private final Gossiper gossiper;
    private final Subject<Timed<MessageEnvelope>> publisher = PublishSubject.create().toSerialized();
    private final Scheduler scheduler;
    private final MessengerOptions opts;
    private final MetricManager metricManager;
    private State state = State.INIT;

    private Messenger(ITransport transport, Scheduler scheduler, MessengerOptions opts) {
        this.transport = new MessengerTransport(transport);
        this.opts = opts.toBuilder().build();
        this.scheduler = scheduler;
        this.localAddress = transport.bindAddress();
        this.gossiper = new Gossiper(transport.bindAddress().toString(), opts.retransmitMultiplier(), opts.spreadPeriod(), this.scheduler);
        this.metricManager = new MetricManager(this.localAddress);
    }

    @Override
    public InetSocketAddress bindAddress() {
        return this.transport.bindAddress();
    }

    @Override
    public CompletableFuture<Void> send(ClusterMessage message, InetSocketAddress recipient, boolean reliable) {
        log.trace("Sending message: addr={}, reliable={}, message={}", new Object[]{recipient, reliable, message});
        this.metricManager.msgSendCounters.get((Object)message.getClusterMessageTypeCase()).increment();
        DirectMessage directMessage = DirectMessage.newBuilder().setPayload(message.toByteString()).build();
        MessengerMessage messengerMessage = MessengerMessage.newBuilder().setDirect(directMessage).build();
        return this.transport.send(List.of(messengerMessage), recipient, reliable);
    }

    @Override
    public CompletableFuture<Void> send(ClusterMessage message, List<ClusterMessage> piggybackedGossips, InetSocketAddress recipient, boolean reliable) {
        return this.send(message, piggybackedGossips, recipient, "", reliable);
    }

    @Override
    public CompletableFuture<Void> send(ClusterMessage message, List<ClusterMessage> piggybackedGossips, InetSocketAddress recipient, String sender, boolean reliable) {
        log.trace("Sending message with piggyback: addr={}, reliable={}, message={}", new Object[]{recipient, reliable, message});
        this.metricManager.msgSendCounters.get((Object)message.getClusterMessageTypeCase()).increment();
        ArrayList<MessengerMessage> buffer = new ArrayList<MessengerMessage>();
        buffer.add(MessengerMessage.newBuilder().setDirect(DirectMessage.newBuilder().setPayload(message.toByteString()).build()).build());
        piggybackedGossips.forEach(gossip -> {
            this.metricManager.msgSendCounters.get((Object)message.getClusterMessageTypeCase()).increment();
            buffer.add(MessengerMessage.newBuilder().setGossip(GossipMessage.newBuilder().setPayload(gossip.toByteString()).build()).build());
        });
        return this.transport.send(buffer, recipient, reliable);
    }

    @Override
    public CompletableFuture<Duration> spread(ClusterMessage message) {
        log.trace("Spreading message: message={}", (Object)message);
        this.metricManager.gossipGenCounters.get((Object)message.getClusterMessageTypeCase()).increment();
        return this.gossiper.generateGossip(message.toByteString());
    }

    @Override
    public Observable<Timed<MessageEnvelope>> receive() {
        return this.publisher;
    }

    @Override
    public void start(IRecipientSelector recipientSelector) {
        switch (this.state) {
            case INIT: {
                this.state = State.START;
                log.debug("Start messenger");
                this.disposables.add(this.transport.receive().observeOn(this.scheduler).subscribe(this::onMessengerMessage, this::onError));
                this.disposables.add(this.gossiper.gossips().observeOn(this.scheduler).subscribe(this::onGossipHeard));
                this.disposables.add(Observable.interval((long)this.opts.spreadPeriod().toMillis(), (long)this.opts.spreadPeriod().toMillis(), (TimeUnit)TimeUnit.MILLISECONDS).observeOn(this.scheduler).subscribe(tick -> this.doGossipSpread(recipientSelector)));
                break;
            }
            case START: {
                break;
            }
            case STOP: {
                throw new IllegalStateException("Messenger has been stopped");
            }
        }
    }

    @Override
    public void shutdown() {
        switch (this.state) {
            case START: {
                this.state = State.STOP;
                log.debug("Shutdown messenger");
                this.metricManager.close();
                this.publisher.onComplete();
                this.disposables.dispose();
                break;
            }
            case INIT: {
                this.metricManager.close();
                throw new IllegalStateException("Messenger has not started");
            }
        }
    }

    private void doGossipSpread(IRecipientSelector recipientSelector) {
        int totalGossipers = recipientSelector.clusterSize();
        int gossipPerRecipient = Math.max(1, this.opts.maxFanoutGossips() / this.opts.maxFanout());
        long period = this.gossiper.nextPeriod(totalGossipers);
        recipientSelector.selectForSpread(this.opts.maxFanout()).forEach(recipient -> {
            List<GossipMessage> gossips = this.gossiper.selectGossipsSendTo(recipient.addr(), totalGossipers);
            if (!gossips.isEmpty()) {
                gossips = RandomUtils.uniqueRandomPickAtMost(gossips, gossipPerRecipient, gossipMessage -> true);
                log.trace("Gossiping[{}], send gossips: msg-count={}, addr={}", new Object[]{period, gossips.size(), recipient.addr()});
                this.metricManager.gossipSpreadCounter.increment((double)gossips.size());
                this.transport.send(gossips.stream().map(gossipMessage -> MessengerMessage.newBuilder().setGossip((GossipMessage)gossipMessage).build()).collect(Collectors.toList()), recipient.addr(), false);
            }
        });
    }

    private void onMessengerMessage(Timed<MessengerMessageEnvelope> timedMessageEnvelop) {
        MessengerMessageEnvelope messengerMessageEnvelope = (MessengerMessageEnvelope)timedMessageEnvelop.value();
        switch (messengerMessageEnvelope.message.getMessengerMessageTypeCase()) {
            case DIRECT: {
                try {
                    ClusterMessage clusterMessage = (ClusterMessage)ZeroCopyParser.parse((ByteString)messengerMessageEnvelope.message.getDirect().getPayload(), ClusterMessage.parser());
                    log.trace("Received message: sender={}, message={}", (Object)messengerMessageEnvelope.sender, (Object)clusterMessage);
                    this.metricManager.msgRecvCounters.get((Object)clusterMessage.getClusterMessageTypeCase()).increment();
                    this.publisher.onNext((Object)new Timed((Object)MessageEnvelope.builder().message(clusterMessage).recipient(messengerMessageEnvelope.recipient).sender(messengerMessageEnvelope.sender).build(), timedMessageEnvelop.time(), timedMessageEnvelop.unit()));
                }
                catch (InvalidProtocolBufferException e) {
                    log.error("Invalid message", (Throwable)e);
                }
                break;
            }
            case GOSSIP: {
                this.gossiper.hearGossip(messengerMessageEnvelope.message.getGossip(), messengerMessageEnvelope.sender);
            }
        }
    }

    private void onGossipHeard(Timed<GossipMessage> confirmedGossip) {
        try {
            ClusterMessage clusterMessage = ClusterMessage.parseFrom(((GossipMessage)confirmedGossip.value()).getPayload());
            log.trace("Heard gossip: id={}, message={}", (Object)((GossipMessage)confirmedGossip.value()).getMessageId(), (Object)clusterMessage);
            this.metricManager.gossipHeardCounters.get((Object)clusterMessage.getClusterMessageTypeCase()).increment();
            this.publisher.onNext((Object)new Timed((Object)MessageEnvelope.builder().message(clusterMessage).recipient(this.localAddress).build(), confirmedGossip.time(), confirmedGossip.unit()));
        }
        catch (InvalidProtocolBufferException e) {
            log.error("Invalid message", (Throwable)e);
        }
    }

    private void onError(Throwable throwable) {
        log.error("Received unexpected error:", throwable);
    }

    @Generated
    public static MessengerBuilder builder() {
        return new MessengerBuilder();
    }

    private static enum State {
        INIT,
        START,
        STOP;

    }

    private static class MetricManager {
        final Map<ClusterMessage.ClusterMessageTypeCase, Counter> msgSendCounters = Maps.newHashMap();
        final Map<ClusterMessage.ClusterMessageTypeCase, Counter> msgRecvCounters = Maps.newHashMap();
        final Map<ClusterMessage.ClusterMessageTypeCase, Counter> gossipGenCounters = Maps.newHashMap();
        final Map<ClusterMessage.ClusterMessageTypeCase, Counter> gossipHeardCounters = Maps.newHashMap();
        final Counter gossipSpreadCounter = Metrics.counter((String)"cluster.gossip.count", (String[])new String[0]);

        MetricManager(InetSocketAddress localAddress) {
            for (ClusterMessage.ClusterMessageTypeCase typeCase : ClusterMessage.ClusterMessageTypeCase.values()) {
                if (typeCase == ClusterMessage.ClusterMessageTypeCase.CLUSTERMESSAGETYPE_NOT_SET) continue;
                Tags tags = Tags.of((String)"local", (String)(localAddress.getAddress().getHostAddress() + ":" + localAddress.getPort())).and("type", typeCase.name());
                this.msgSendCounters.put(typeCase, Metrics.counter((String)"basecluster.send.count", (Iterable)tags));
                this.msgRecvCounters.put(typeCase, Metrics.counter((String)"basecluster.recv.count", (Iterable)tags));
                this.gossipGenCounters.put(typeCase, Metrics.counter((String)"basecluster.gossip.gen.count", (Iterable)tags));
                this.gossipHeardCounters.put(typeCase, Metrics.counter((String)"basecluster.gossip.heard.count", (Iterable)tags));
            }
        }

        void close() {
            this.msgSendCounters.forEach((t, m) -> Metrics.globalRegistry.remove((Meter)m));
            this.msgRecvCounters.forEach((t, m) -> Metrics.globalRegistry.remove((Meter)m));
            this.gossipGenCounters.forEach((t, m) -> Metrics.globalRegistry.remove((Meter)m));
            this.gossipHeardCounters.forEach((t, m) -> Metrics.globalRegistry.remove((Meter)m));
            Metrics.globalRegistry.remove((Meter)this.gossipSpreadCounter);
        }
    }

    @Generated
    public static class MessengerBuilder {
        @Generated
        private ITransport transport;
        @Generated
        private Scheduler scheduler;
        @Generated
        private MessengerOptions opts;

        @Generated
        MessengerBuilder() {
        }

        @Generated
        public MessengerBuilder transport(ITransport transport) {
            this.transport = transport;
            return this;
        }

        @Generated
        public MessengerBuilder scheduler(Scheduler scheduler) {
            this.scheduler = scheduler;
            return this;
        }

        @Generated
        public MessengerBuilder opts(MessengerOptions opts) {
            this.opts = opts;
            return this;
        }

        @Generated
        public Messenger build() {
            return new Messenger(this.transport, this.scheduler, this.opts);
        }

        @Generated
        public String toString() {
            return "Messenger.MessengerBuilder(transport=" + String.valueOf(this.transport) + ", scheduler=" + String.valueOf(this.scheduler) + ", opts=" + String.valueOf(this.opts) + ")";
        }
    }
}

