/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.raft;

import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.bifromq.basekv.raft.ILogEntryIterator;
import org.apache.bifromq.basekv.raft.IRaftStateStore;
import org.apache.bifromq.basekv.raft.proto.ClusterConfig;
import org.apache.bifromq.basekv.raft.proto.LogEntry;
import org.apache.bifromq.basekv.raft.proto.Snapshot;
import org.apache.bifromq.basekv.raft.proto.Voting;

public final class InMemoryStateStore
implements IRaftStateStore {
    private static final IRaftStateStore.StableListener DEFAULT_STABLE_LISTENER = stableListener -> {};
    private final String id;
    private final LinkedList<Long> configEntryIndexes = new LinkedList();
    private final long flushDelayInMS;
    private final ScheduledExecutorService flusher = Executors.newSingleThreadScheduledExecutor();
    private final AtomicBoolean flushTaskScheduled = new AtomicBoolean(false);
    private final LinkedList<LogEntry> logEntries = new LinkedList();
    private final AtomicLong currentTerm = new AtomicLong(0L);
    private volatile long stabilizingIndex;
    private Snapshot latestSnapshot;
    private Voting currentVoting;
    private IRaftStateStore.StableListener stableListener = DEFAULT_STABLE_LISTENER;

    public InMemoryStateStore(String id, Snapshot latestSnapshot, long flushDelayInMS) {
        this.id = id;
        this.latestSnapshot = latestSnapshot;
        this.flushDelayInMS = flushDelayInMS;
        this.logEntries.add(LogEntry.newBuilder().setTerm(latestSnapshot.getTerm()).setIndex(latestSnapshot.getIndex()).build());
    }

    public InMemoryStateStore(String id, Snapshot latestSnapshot) {
        this(id, latestSnapshot, 5L);
    }

    @Override
    public String local() {
        return this.id;
    }

    @Override
    public long currentTerm() {
        return this.currentTerm.get();
    }

    @Override
    public void saveTerm(long term) {
        assert (term >= this.currentTerm.get());
        this.currentTerm.set(term);
    }

    @Override
    public Optional<Voting> currentVoting() {
        return Optional.ofNullable(this.currentVoting);
    }

    @Override
    public void saveVoting(Voting voting) {
        this.currentVoting = voting;
    }

    @Override
    public ClusterConfig latestClusterConfig() {
        if (this.configEntryIndexes.isEmpty()) {
            return this.latestSnapshot.getClusterConfig();
        }
        long latestConfigEntryIndex = this.configEntryIndexes.getLast();
        LogEntry logEntry = this.logEntries.get(this.offset(latestConfigEntryIndex));
        assert (logEntry.hasConfig());
        return logEntry.getConfig();
    }

    @Override
    public void applySnapshot(Snapshot snapshot) {
        long snapLastIndex = snapshot.getIndex();
        long snapLastTerm = snapshot.getTerm();
        Optional<LogEntry> lastEntryInSS = this.entryAt(snapLastIndex);
        if (lastEntryInSS.isPresent() && lastEntryInSS.get().getTerm() == snapLastTerm || lastEntryInSS.isEmpty() && this.latestSnapshot != null && this.latestSnapshot.getIndex() == snapLastIndex && this.latestSnapshot.getTerm() == snapLastTerm) {
            this.latestSnapshot = snapshot;
            long truncateBefore = Math.min(this.lastIndex(), snapLastIndex) + 1L;
            while (this.firstIndex() < truncateBefore) {
                this.logEntries.remove(0);
            }
            while (!this.configEntryIndexes.isEmpty() && this.configEntryIndexes.getFirst() < truncateBefore) {
                this.configEntryIndexes.removeFirst();
            }
            this.logEntries.set(0, this.logEntries.getFirst().toBuilder().setIndex(snapLastIndex).setTerm(snapLastTerm).setData(ByteString.EMPTY).build());
        } else {
            this.latestSnapshot = snapshot;
            this.logEntries.clear();
            this.configEntryIndexes.clear();
            this.logEntries.add(LogEntry.newBuilder().setTerm(this.latestSnapshot.getTerm()).setIndex(this.latestSnapshot.getIndex()).build());
        }
    }

    @Override
    public Snapshot latestSnapshot() {
        return this.latestSnapshot;
    }

    @Override
    public long firstIndex() {
        return this.logEntries.getFirst().getIndex() + 1L;
    }

    @Override
    public long lastIndex() {
        return this.logEntries.getLast().getIndex();
    }

    @Override
    public Optional<LogEntry> entryAt(long index) {
        if (index < this.firstIndex() || index > this.lastIndex()) {
            return Optional.empty();
        }
        return Optional.of(this.logEntries.get(this.offset(index)));
    }

    @Override
    public ILogEntryIterator entries(long lo, long hi, long maxSize) {
        if (lo < this.firstIndex()) {
            throw new IndexOutOfBoundsException("lo must not be less than firstIndex");
        }
        if (hi > this.lastIndex() + 1L) {
            throw new IndexOutOfBoundsException("hi must not be greater than lastIndex");
        }
        if (maxSize < 0L) {
            maxSize = Long.MAX_VALUE;
        }
        final ArrayList<LogEntry> ret = new ArrayList<LogEntry>();
        long size = 0L;
        while (lo < hi && size <= maxSize) {
            LogEntry entry = this.logEntries.get(this.offset(lo));
            ret.add(entry);
            switch (entry.getTypeCase()) {
                case DATA: {
                    size += (long)entry.getData().size();
                    break;
                }
                case CONFIG: {
                    size += (long)entry.getConfig().getSerializedSize();
                    break;
                }
            }
            ++lo;
        }
        return new ILogEntryIterator(){
            private final Iterator<LogEntry> delegate;
            {
                this.delegate = ret.iterator();
            }

            @Override
            public void close() {
            }

            @Override
            public boolean hasNext() {
                return this.delegate.hasNext();
            }

            @Override
            public LogEntry next() {
                return this.delegate.next();
            }
        };
    }

    @Override
    public void append(List<LogEntry> entries, boolean flush) {
        assert (!entries.isEmpty());
        LogEntry startEntry = entries.get(0);
        if (this.lastIndex() >= this.firstIndex()) {
            if (this.firstIndex() > startEntry.getIndex() || this.lastIndex() + 1L < startEntry.getIndex()) {
                throw new IndexOutOfBoundsException("log index[" + startEntry.getIndex() + "] must be in [" + this.firstIndex() + "," + this.lastIndex() + "1]");
            }
        } else if (startEntry.getIndex() != this.firstIndex()) {
            throw new IndexOutOfBoundsException("log index must start from " + this.firstIndex());
        }
        long afterIndex = startEntry.getIndex() - 1L;
        ListIterator<LogEntry> itr = this.logEntries.listIterator(this.offset(afterIndex) + 1);
        while (itr.hasNext()) {
            itr.next();
            itr.remove();
        }
        while (!this.configEntryIndexes.isEmpty() && this.configEntryIndexes.get(this.configEntryIndexes.size() - 1) > afterIndex) {
            this.configEntryIndexes.remove(this.configEntryIndexes.size() - 1);
        }
        entries.forEach(entry -> {
            if (entry.hasConfig()) {
                this.configEntryIndexes.add(entry.getIndex());
            }
            this.logEntries.add((LogEntry)entry);
        });
        if (flush) {
            this.immediateFlush(this.entryAt(this.lastIndex()).get().getIndex());
        } else {
            this.stabilizingIndex = this.lastIndex();
            this.scheduleFlushTask();
        }
    }

    @Override
    public void addStableListener(IRaftStateStore.StableListener listener) {
        this.stableListener = listener;
    }

    @Override
    public void stop() {
        this.flusher.shutdown();
        try {
            this.flusher.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.stableListener = DEFAULT_STABLE_LISTENER;
        }
    }

    int offset(long index) {
        return (int)(index - this.firstIndex() + 1L);
    }

    void immediateFlush(long index) {
        this.stableListener.onStabilized(index);
    }

    void flush() {
        this.stableListener.onStabilized(this.stabilizingIndex);
        this.flushTaskScheduled.set(false);
    }

    void scheduleFlushTask() {
        if (this.flushTaskScheduled.compareAndSet(false, true)) {
            this.flusher.schedule(this::flush, this.flushDelayInMS, TimeUnit.MILLISECONDS);
        }
    }
}

