/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.baserpc.trafficgovernor;

import com.google.common.collect.Maps;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.subjects.BehaviorSubject;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.bifromq.basecrdt.core.api.CRDTURI;
import org.apache.bifromq.basecrdt.core.api.CausalCRDTType;
import org.apache.bifromq.basecrdt.core.api.ICRDTOperation;
import org.apache.bifromq.basecrdt.core.api.IMVReg;
import org.apache.bifromq.basecrdt.core.api.IORMap;
import org.apache.bifromq.basecrdt.core.api.MVRegOperation;
import org.apache.bifromq.basecrdt.core.api.ORMapOperation;
import org.apache.bifromq.basecrdt.proto.Replica;
import org.apache.bifromq.basecrdt.service.ICRDTService;
import org.apache.bifromq.basehlc.HLC;
import org.apache.bifromq.baserpc.proto.LoadAssignment;
import org.apache.bifromq.baserpc.proto.RPCServer;
import org.apache.bifromq.baserpc.trafficgovernor.SharedScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class RPCServiceAnnouncer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RPCServiceAnnouncer.class);
    private static final ByteString SERVER_LIST_KEY = ByteString.copyFrom((byte[])new byte[]{0});
    private static final ByteString TRAFFIC_RULES_KEY = ByteString.copyFrom((byte[])new byte[]{1});
    protected final String serviceUniqueName;
    protected final ICRDTService crdtService;
    private final Replica crdtReplica;
    private final IORMap rpcServiceCRDT;
    private final BehaviorSubject<Map<String, RPCServer>> serverEndpointSubject;
    private final BehaviorSubject<Map<String, Map<String, Integer>>> trafficRulesSubject;
    private final CompositeDisposable disposable = new CompositeDisposable();

    protected RPCServiceAnnouncer(String serviceUniqueName, ICRDTService crdtService) {
        this.serviceUniqueName = serviceUniqueName;
        this.crdtService = crdtService;
        this.rpcServiceCRDT = (IORMap)crdtService.host(CRDTURI.toURI((CausalCRDTType)CausalCRDTType.ormap, (String)("RPC:" + serviceUniqueName)));
        this.crdtReplica = this.rpcServiceCRDT.id();
        Map<String, RPCServer> serverMap = this.buildAnnouncedServers(HLC.INST.get());
        this.serverEndpointSubject = serverMap.isEmpty() ? BehaviorSubject.create() : BehaviorSubject.createDefault(serverMap);
        this.trafficRulesSubject = BehaviorSubject.createDefault(this.buildAnnouncedTrafficRules(HLC.INST.get()).orElse(Collections.emptyMap()));
        this.disposable.add(this.rpcServiceCRDT.getORMap(new ByteString[]{SERVER_LIST_KEY}).inflation().observeOn(SharedScheduler.RPC_SHARED_SCHEDULER).map(this::buildAnnouncedServers).subscribe(arg_0 -> this.serverEndpointSubject.onNext(arg_0)));
        this.disposable.add(this.rpcServiceCRDT.getORMap(new ByteString[]{TRAFFIC_RULES_KEY}).inflation().observeOn(SharedScheduler.RPC_SHARED_SCHEDULER).map(this::buildAnnouncedTrafficRules).filter(Optional::isPresent).map(Optional::get).subscribe(arg_0 -> this.trafficRulesSubject.onNext(arg_0)));
    }

    protected ByteString id() {
        return this.crdtReplica.getId();
    }

    protected void destroy() {
        this.serverEndpointSubject.onComplete();
        this.trafficRulesSubject.onComplete();
        this.disposable.dispose();
        this.crdtService.stopHosting(this.rpcServiceCRDT.id().getUri()).join();
    }

    protected CompletableFuture<Void> announce(RPCServer server) {
        return this.rpcServiceCRDT.execute((ICRDTOperation)ORMapOperation.update((ByteString[])new ByteString[]{SERVER_LIST_KEY, ByteString.copyFromUtf8((String)server.getId())}).with(MVRegOperation.write((ByteString)server.toByteString())));
    }

    protected CompletableFuture<Void> setTrafficRule(String tenantIdPrefix, Map<String, Integer> weightedGroups) {
        return this.rpcServiceCRDT.execute((ICRDTOperation)ORMapOperation.update((ByteString[])new ByteString[]{TRAFFIC_RULES_KEY}).with((ORMapOperation)ORMapOperation.update((ByteString[])new ByteString[]{ByteString.copyFromUtf8((String)tenantIdPrefix)}).with(MVRegOperation.write((ByteString)LoadAssignment.newBuilder().putAllWeightedGroup(weightedGroups).build().toByteString()))));
    }

    protected CompletableFuture<Void> unsetTrafficRule(String tenantIdPrefix) {
        return this.rpcServiceCRDT.execute((ICRDTOperation)ORMapOperation.update((ByteString[])new ByteString[]{TRAFFIC_RULES_KEY}).with((ORMapOperation)ORMapOperation.remove((ByteString[])new ByteString[]{ByteString.copyFromUtf8((String)tenantIdPrefix)}).of(CausalCRDTType.mvreg)));
    }

    protected CompletableFuture<Void> revoke(String id) {
        return this.rpcServiceCRDT.execute((ICRDTOperation)ORMapOperation.remove((ByteString[])new ByteString[]{SERVER_LIST_KEY, ByteString.copyFromUtf8((String)id)}).of(CausalCRDTType.mvreg));
    }

    protected Optional<RPCServer> announcedServer(String id) {
        return this.announcedServer(this.rpcServiceCRDT.getMVReg(new ByteString[]{SERVER_LIST_KEY, ByteString.copyFromUtf8((String)id)}));
    }

    private Optional<RPCServer> announcedServer(IMVReg mvReg) {
        RPCServer server = null;
        Iterator itr = mvReg.read();
        while (itr.hasNext()) {
            try {
                RPCServer s = RPCServer.parseFrom((ByteString)itr.next());
                if (server == null) {
                    server = s;
                    continue;
                }
                server = server.getAnnouncedTS() < s.getAnnouncedTS() ? s : server;
            }
            catch (InvalidProtocolBufferException e) {
                log.error("Unable to parse RPCServer from crdt", (Throwable)e);
            }
        }
        return Optional.ofNullable(server);
    }

    protected Observable<Map<String, RPCServer>> announcedServers() {
        return this.serverEndpointSubject;
    }

    private Map<String, RPCServer> buildAnnouncedServers(long t) {
        IORMap serverListORMap = this.rpcServiceCRDT.getORMap(new ByteString[]{SERVER_LIST_KEY});
        Iterator keyItr = serverListORMap.keys();
        HashMap announced = Maps.newHashMap();
        while (keyItr.hasNext()) {
            IORMap.ORMapKey orMapKey = (IORMap.ORMapKey)keyItr.next();
            assert (orMapKey.valueType() == CausalCRDTType.mvreg);
            Optional<RPCServer> rpcServer = this.announcedServer(serverListORMap.getMVReg(new ByteString[]{orMapKey.key()}));
            rpcServer.ifPresent(server -> announced.put(server.getId(), server));
        }
        log.debug("Build service[{}]'s server list at {}\n{}", new Object[]{this.serviceUniqueName, t, announced});
        return announced;
    }

    protected Observable<Map<String, Map<String, Integer>>> trafficRules() {
        return this.trafficRulesSubject;
    }

    protected Observable<Set<ByteString>> aliveAnnouncers() {
        return this.crdtService.aliveReplicas(this.crdtReplica.getUri()).map(r -> r.stream().map(Replica::getId).collect(Collectors.toSet()));
    }

    private Optional<Map<String, Map<String, Integer>>> buildAnnouncedTrafficRules(long t) {
        HashMap trafficDirective = Maps.newHashMap();
        IORMap directives = this.rpcServiceCRDT.getORMap(new ByteString[]{TRAFFIC_RULES_KEY});
        directives.keys().forEachRemaining(key -> {
            assert (key.valueType() == CausalCRDTType.mvreg);
            Optional<LoadAssignment> la = this.parseLoadAssignment(directives.getMVReg(new ByteString[]{key.key()}));
            la.ifPresent(loadAssignment -> trafficDirective.put(key.key().toStringUtf8(), loadAssignment.getWeightedGroupMap()));
        });
        return Optional.of(trafficDirective);
    }

    private Optional<LoadAssignment> parseLoadAssignment(IMVReg mvReg) {
        LoadAssignment loadAssignment = null;
        Iterator itr = mvReg.read();
        while (itr.hasNext()) {
            try {
                LoadAssignment next = LoadAssignment.parseFrom((ByteString)itr.next());
                if (loadAssignment == null) {
                    loadAssignment = next;
                    continue;
                }
                loadAssignment = loadAssignment.getAnnouncedTS() < next.getAnnouncedTS() ? next : loadAssignment;
            }
            catch (InvalidProtocolBufferException e) {
                log.error("Unable to parse LoadAssignment from crdt", (Throwable)e);
            }
        }
        return Optional.ofNullable(loadAssignment);
    }
}

