/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecluster.memberlist;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Scheduler;
import com.google.common.collect.Maps;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.bifromq.basecluster.memberlist.IHostAddressResolver;
import org.apache.bifromq.basecluster.memberlist.IHostMemberList;
import org.apache.bifromq.basecluster.membership.proto.Endorse;
import org.apache.bifromq.basecluster.membership.proto.Fail;
import org.apache.bifromq.basecluster.membership.proto.HostEndpoint;
import org.apache.bifromq.basecluster.membership.proto.HostMember;
import org.apache.bifromq.basecluster.membership.proto.Join;
import org.apache.bifromq.basecluster.membership.proto.Quit;
import org.apache.bifromq.basecluster.messenger.IMessenger;
import org.apache.bifromq.basecluster.messenger.MessageEnvelope;
import org.apache.bifromq.basecluster.proto.ClusterMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AutoHealer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AutoHealer.class);
    private final Cache<HostEndpoint, Integer> healingMembers;
    private final Cache<HostEndpoint, Integer> quitMembers;
    private final IMessenger messenger;
    private final io.reactivex.rxjava3.core.Scheduler scheduler;
    private final IHostMemberList memberList;
    private final IHostAddressResolver addressResolver;
    private final Duration healingTimeout;
    private final Duration healingInterval;
    private final AtomicBoolean stopped = new AtomicBoolean();
    private final AtomicBoolean scheduled = new AtomicBoolean();
    private final CompositeDisposable disposables = new CompositeDisposable();
    private final Gauge healingNumGauge;
    private volatile Map<HostEndpoint, Integer> alivePeers = new HashMap<HostEndpoint, Integer>();
    private volatile Disposable healingJob;

    public AutoHealer(IMessenger messenger, io.reactivex.rxjava3.core.Scheduler scheduler, IHostMemberList memberList, IHostAddressResolver addressResolver, Duration healingTimeout, Duration healingInterval, String ... tags) {
        this.messenger = messenger;
        this.scheduler = scheduler;
        this.memberList = memberList;
        this.addressResolver = addressResolver;
        this.healingTimeout = healingTimeout;
        this.healingInterval = healingInterval;
        this.healingMembers = Caffeine.newBuilder().maximumSize(30L).expireAfterWrite(healingTimeout).scheduler(Scheduler.systemScheduler()).removalListener((key, value, cause) -> {
            if (cause.wasEvicted()) {
                log.debug("Give up healing host[{}]", key);
            }
        }).build();
        this.quitMembers = Caffeine.newBuilder().maximumSize(30L).expireAfterWrite(Duration.ofSeconds(300L)).scheduler(Scheduler.systemScheduler()).build();
        this.disposables.add(messenger.receive().map(m -> ((MessageEnvelope)m.value()).message).observeOn(scheduler).subscribe(this::handleMessage));
        this.disposables.add(memberList.members().observeOn(scheduler).subscribe(this::syncAlivePeers));
        this.healingNumGauge = Gauge.builder((String)"basecluster.heal.num", () -> this.healingMembers.estimatedSize()).tags(tags).register((MeterRegistry)Metrics.globalRegistry);
    }

    public void stop() {
        if (this.stopped.compareAndSet(false, true)) {
            this.healingMembers.invalidateAll();
            this.disposables.dispose();
            if (this.healingJob != null) {
                this.healingJob.dispose();
            }
            Metrics.globalRegistry.remove((Meter)this.healingNumGauge);
        }
    }

    private void handleMessage(ClusterMessage message) {
        switch (message.getClusterMessageTypeCase()) {
            case JOIN: {
                this.handleJoin(message.getJoin());
                break;
            }
            case ENDORSE: {
                this.handleEndorse(message.getEndorse());
                break;
            }
            case QUIT: {
                this.handleQuit(message.getQuit());
                break;
            }
            case FAIL: {
                this.handleFail(message.getFail());
            }
        }
    }

    private void handleJoin(Join join) {
        HostMember joinMember = join.getMember();
        HostEndpoint joinEndpoint = joinMember.getEndpoint();
        Integer healingMemberIncarnation = (Integer)this.healingMembers.getIfPresent((Object)joinEndpoint);
        if (healingMemberIncarnation != null) {
            if (healingMemberIncarnation < joinMember.getIncarnation()) {
                log.debug("Member[{},{}] is reachable now, stop healing: local={}", new Object[]{joinEndpoint, healingMemberIncarnation, this.memberList.local().getEndpoint()});
                this.healingMembers.invalidate((Object)joinEndpoint);
            }
        } else {
            this.cleanSameAddressHealingMembers(joinEndpoint);
        }
    }

    private void handleEndorse(Endorse endorse) {
        HostEndpoint endpoint = endorse.getEndpoint();
        Integer healingMemberIncarnation = (Integer)this.healingMembers.getIfPresent((Object)endpoint);
        if (healingMemberIncarnation != null) {
            if (healingMemberIncarnation <= endorse.getIncarnation()) {
                log.debug("Member[{},{}] is confirmed alive by others, stop healing: local={}", new Object[]{endpoint, endorse.getIncarnation(), this.memberList.local().getEndpoint()});
                this.healingMembers.invalidate((Object)endpoint);
            }
        } else {
            this.cleanSameAddressHealingMembers(endpoint);
        }
    }

    private void cleanSameAddressHealingMembers(HostEndpoint endpoint) {
        for (HostEndpoint healingEndpoint : this.healingMembers.asMap().keySet()) {
            if (!healingEndpoint.getAddress().equals(endpoint.getAddress())) continue;
            log.debug("Member[{}] has been healed, stop healing: local={}", (Object)healingEndpoint, (Object)this.memberList.local().getEndpoint());
            this.healingMembers.invalidate((Object)healingEndpoint);
        }
    }

    private void handleQuit(Quit quit) {
        HostEndpoint quitEndpoint = quit.getEndpoint();
        Integer healingMemberIncarnation = (Integer)this.healingMembers.getIfPresent((Object)quitEndpoint);
        if (healingMemberIncarnation != null) {
            if (healingMemberIncarnation <= quit.getIncarnation()) {
                log.debug("Member[{},{}] has quit, stop healing: local={}", new Object[]{quitEndpoint, quit.getIncarnation(), this.memberList.local().getEndpoint()});
                this.healingMembers.invalidate((Object)quitEndpoint);
                this.quitMembers.put((Object)quitEndpoint, (Object)quit.getIncarnation());
            }
        } else {
            this.quitMembers.put((Object)quitEndpoint, (Object)quit.getIncarnation());
        }
    }

    private void handleFail(Fail fail) {
        HostEndpoint failedEndpoint = fail.getEndpoint();
        Integer inc = this.alivePeers.get(failedEndpoint);
        Integer quitInc = (Integer)this.quitMembers.getIfPresent((Object)failedEndpoint);
        if (!(failedEndpoint.equals(this.memberList.local().getEndpoint()) || this.memberList.isZombie(failedEndpoint) || inc == null || inc > fail.getIncarnation() || quitInc != null && quitInc >= fail.getIncarnation())) {
            log.debug("Member[{},{}] has failed, add it to healing list: local={}", new Object[]{failedEndpoint, fail.getIncarnation(), this.memberList.local().getEndpoint()});
            HashMap updatedAlivePeers = Maps.newHashMap(this.alivePeers);
            updatedAlivePeers.remove(failedEndpoint, inc);
            this.alivePeers = updatedAlivePeers;
            this.healingMembers.put((Object)failedEndpoint, (Object)fail.getIncarnation());
            this.quitMembers.invalidate((Object)failedEndpoint);
            this.scheduleHealing();
        }
    }

    private void scheduleHealing() {
        if (this.stopped.get()) {
            return;
        }
        if (this.scheduled.compareAndSet(false, true)) {
            this.healingJob = this.scheduler.scheduleDirect(this::heal, this.healingInterval.toMillis(), TimeUnit.MILLISECONDS);
        }
    }

    private void heal() {
        for (Map.Entry entry : this.healingMembers.asMap().entrySet()) {
            HostEndpoint healMember = (HostEndpoint)entry.getKey();
            int incarnation = (Integer)entry.getValue();
            log.debug("Send join message to the host[{}:{}] locating at address[{}:{}] for healing the connection: incarnation={}", new Object[]{healMember.getId(), healMember.getPid(), healMember.getAddress(), healMember.getPort(), incarnation});
            this.messenger.send(ClusterMessage.newBuilder().setJoin(Join.newBuilder().setMember(this.memberList.local()).setExpectedHost(healMember).build()).build(), this.addressResolver.resolve(healMember), true);
        }
        this.healingMembers.cleanUp();
        this.scheduled.set(false);
        if (!this.healingMembers.asMap().isEmpty()) {
            this.scheduleHealing();
        }
    }

    private void syncAlivePeers(Map<HostEndpoint, Integer> members) {
        Map newAlivePeers = Maps.filterKeys(members, k -> !k.equals(this.memberList.local().getEndpoint()));
        Maps.difference((Map)newAlivePeers, this.alivePeers).entriesOnlyOnLeft().forEach((k, v) -> this.cleanSameAddressHealingMembers((HostEndpoint)k));
        this.alivePeers = newAlivePeers;
    }
}

