/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.sql;

import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class SqlSchema {
    private final Map<String, Map<String, Set<String>>> schema;

    public SqlSchema(Map<String, Map<String, Set<String>>> schema) {
        this.schema = schema;
    }

    public Set<String> schemas() {
        return Collections.unmodifiableSet(this.schema.keySet());
    }

    public Set<String> tables(String schemaName) {
        return Collections.unmodifiableSet(this.schema.getOrDefault(schemaName, Collections.emptyMap()).keySet());
    }

    public Set<String> getColumnNames(String tableName) {
        Map.Entry<String, Map<String, Set<String>>> schema = this.findSchema(tableName);
        if (schema != null) {
            Map<String, Set<String>> tables = schema.getValue();
            return tables.computeIfAbsent(tableName, key -> this.getColumns((String)schema.getKey(), (String)key));
        }
        return Collections.emptySet();
    }

    private Set<String> getColumns(String schemaName, String tableName) {
        Map<String, Set<String>> tables = this.schema.get(schemaName);
        if (tables != null) {
            return tables.getOrDefault(tableName, Collections.emptySet());
        }
        return Collections.emptySet();
    }

    private Map.Entry<String, Map<String, Set<String>>> findSchema(String tableName) {
        for (Map.Entry<String, Map<String, Set<String>>> entry : this.schema.entrySet()) {
            if (!entry.getValue().containsKey(tableName)) continue;
            return entry;
        }
        return null;
    }
}

