/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.exception;

import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Optional;

public class ConnectionException
extends RuntimeException {
    private URI uri;
    private InetSocketAddress address;

    public ConnectionException(URI uri, InetSocketAddress addy, String message) {
        super(message);
        this.address = addy;
        this.uri = uri;
    }

    public ConnectionException(URI uri, Throwable cause) {
        super(cause);
        this.uri = uri;
        this.address = null;
    }

    public ConnectionException(URI uri, String message, Throwable cause) {
        super(message, cause);
        this.uri = uri;
        this.address = null;
    }

    public ConnectionException(URI uri, InetSocketAddress addy, String message, Throwable cause) {
        super(message, cause);
        this.address = addy;
        this.uri = uri;
    }

    public URI getUri() {
        return this.uri;
    }

    public Optional<InetSocketAddress> getAddress() {
        return Optional.ofNullable(this.address);
    }
}

