/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.NumberType;
import org.apache.cassandra.db.marshal.ValueAccessor;
import org.apache.cassandra.serializers.FloatSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;

public class FloatType
extends NumberType<Float> {
    public static final FloatType instance = new FloatType();

    FloatType() {
        super(AbstractType.ComparisonType.CUSTOM);
    }

    @Override
    public boolean isEmptyValueMeaningless() {
        return true;
    }

    @Override
    public boolean isFloatingPoint() {
        return true;
    }

    @Override
    public <VL, VR> int compareCustom(VL left, ValueAccessor<VL> accessorL, VR right, ValueAccessor<VR> accessorR) {
        return FloatType.compareComposed(left, accessorL, right, accessorR, this);
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        if (source.isEmpty()) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        try {
            return this.decompose(Float.valueOf(Float.parseFloat(source)));
        }
        catch (NumberFormatException e1) {
            throw new MarshalException(String.format("Unable to make float from '%s'", source), e1);
        }
    }

    @Override
    public Term fromJSONObject(Object parsed) throws MarshalException {
        try {
            if (parsed instanceof String) {
                return new Constants.Value(this.fromString((String)parsed));
            }
            return new Constants.Value(this.getSerializer().serialize(Float.valueOf(((Number)parsed).floatValue())));
        }
        catch (ClassCastException exc) {
            throw new MarshalException(String.format("Expected a float value, but got a %s: %s", parsed.getClass().getSimpleName(), parsed));
        }
    }

    @Override
    public String toJSONString(ByteBuffer buffer, ProtocolVersion protocolVersion) {
        Float value = this.getSerializer().deserialize(buffer);
        if (value == null) {
            return "\"\"";
        }
        if (value.isNaN() || value.isInfinite()) {
            return "null";
        }
        return value.toString();
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.Native.FLOAT;
    }

    @Override
    public TypeSerializer<Float> getSerializer() {
        return FloatSerializer.instance;
    }

    @Override
    public int valueLengthIfFixed() {
        return 4;
    }

    @Override
    protected int toInt(ByteBuffer value) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected float toFloat(ByteBuffer value) {
        return ByteBufferUtil.toFloat(value);
    }

    @Override
    protected double toDouble(ByteBuffer value) {
        return this.toFloat(value);
    }

    @Override
    public ByteBuffer add(NumberType<?> leftType, ByteBuffer left, NumberType<?> rightType, ByteBuffer right) {
        return ByteBufferUtil.bytes(leftType.toFloat(left) + rightType.toFloat(right));
    }

    @Override
    public ByteBuffer substract(NumberType<?> leftType, ByteBuffer left, NumberType<?> rightType, ByteBuffer right) {
        return ByteBufferUtil.bytes(leftType.toFloat(left) - rightType.toFloat(right));
    }

    @Override
    public ByteBuffer multiply(NumberType<?> leftType, ByteBuffer left, NumberType<?> rightType, ByteBuffer right) {
        return ByteBufferUtil.bytes(leftType.toFloat(left) * rightType.toFloat(right));
    }

    @Override
    public ByteBuffer divide(NumberType<?> leftType, ByteBuffer left, NumberType<?> rightType, ByteBuffer right) {
        return ByteBufferUtil.bytes(leftType.toFloat(left) / rightType.toFloat(right));
    }

    @Override
    public ByteBuffer mod(NumberType<?> leftType, ByteBuffer left, NumberType<?> rightType, ByteBuffer right) {
        return ByteBufferUtil.bytes(leftType.toFloat(left) % rightType.toFloat(right));
    }

    @Override
    public ByteBuffer negate(ByteBuffer input) {
        return ByteBufferUtil.bytes(-this.toFloat(input));
    }
}

