/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.stubbing;

import org.mockito.creation.instance.Instantiator;
import org.mockito.internal.configuration.plugins.Plugins;
import org.mockito.internal.exceptions.Reporter;
import org.mockito.internal.progress.ThreadSafeMockingProgress;
import org.mockito.internal.stubbing.answers.CallsRealMethods;
import org.mockito.internal.stubbing.answers.Returns;
import org.mockito.internal.stubbing.answers.ThrowsException;
import org.mockito.stubbing.Answer;
import org.mockito.stubbing.OngoingStubbing;

public abstract class BaseStubbing<T>
implements OngoingStubbing<T> {
    private final Object strongMockRef;

    BaseStubbing(Object mock) {
        this.strongMockRef = mock;
    }

    @Override
    public OngoingStubbing<T> then(Answer<?> answer) {
        return this.thenAnswer(answer);
    }

    @Override
    public OngoingStubbing<T> thenReturn(T value) {
        return this.thenAnswer(new Returns(value));
    }

    @Override
    public OngoingStubbing<T> thenReturn(T value, T ... values) {
        OngoingStubbing<T> stubbing = this.thenReturn(value);
        if (values == null) {
            return stubbing.thenReturn(null);
        }
        for (T v : values) {
            stubbing = stubbing.thenReturn(v);
        }
        return stubbing;
    }

    private OngoingStubbing<T> thenThrow(Throwable throwable) {
        return this.thenAnswer(new ThrowsException(throwable));
    }

    @Override
    public OngoingStubbing<T> thenThrow(Throwable ... throwables) {
        if (throwables == null) {
            return this.thenThrow((Throwable)null);
        }
        OngoingStubbing<T> stubbing = null;
        for (Throwable t : throwables) {
            stubbing = stubbing == null ? this.thenThrow(t) : stubbing.thenThrow(t);
        }
        return stubbing;
    }

    @Override
    public OngoingStubbing<T> thenThrow(Class<? extends Throwable> throwableType) {
        if (throwableType == null) {
            ThreadSafeMockingProgress.mockingProgress().reset();
            throw Reporter.notAnException();
        }
        Instantiator instantiator = Plugins.getInstantiatorProvider().getInstantiator(null);
        return this.thenThrow(instantiator.newInstance(throwableType));
    }

    @Override
    public OngoingStubbing<T> thenThrow(Class<? extends Throwable> toBeThrown, Class<? extends Throwable> ... nextToBeThrown) {
        if (nextToBeThrown == null) {
            return this.thenThrow((Class<Throwable>)null);
        }
        OngoingStubbing<T> stubbing = this.thenThrow(toBeThrown);
        for (Class<? extends Throwable> t : nextToBeThrown) {
            stubbing = stubbing.thenThrow(t);
        }
        return stubbing;
    }

    @Override
    public OngoingStubbing<T> thenCallRealMethod() {
        return this.thenAnswer(new CallsRealMethods());
    }

    @Override
    public <M> M getMock() {
        return (M)this.strongMockRef;
    }
}

