/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.auth;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.auth.AuthManager;
import org.apache.hugegraph.auth.HugeGraphAuthProxy;
import org.apache.hugegraph.auth.HugePermission;
import org.apache.hugegraph.auth.HugeResource;
import org.apache.hugegraph.auth.HugeUser;
import org.apache.hugegraph.auth.ResourceObject;
import org.apache.hugegraph.auth.ResourceType;
import org.apache.hugegraph.auth.RolePermission;
import org.apache.hugegraph.auth.SchemaDefine;
import org.apache.hugegraph.auth.UserWithRole;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.id.IdGenerator;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.config.OptionHolder;
import org.apache.hugegraph.config.OptionSpace;
import org.apache.hugegraph.config.ServerOptions;
import org.apache.hugegraph.type.Nameable;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.JsonUtil;
import org.apache.tinkerpop.gremlin.server.auth.AuthenticatedUser;
import org.apache.tinkerpop.gremlin.server.auth.AuthenticationException;
import org.apache.tinkerpop.gremlin.server.auth.Authenticator;
import org.apache.tinkerpop.shaded.jackson.annotation.JsonProperty;

public interface HugeAuthenticator
extends Authenticator {
    public static final String KEY_USERNAME = "username";
    public static final String KEY_PASSWORD = "password";
    public static final String KEY_TOKEN = "token";
    public static final String KEY_ROLE = "role";
    public static final String KEY_ADDRESS = "address";
    public static final String KEY_PATH = "path";
    public static final String USER_SYSTEM = "system";
    public static final String USER_ADMIN = "admin";
    public static final String USER_ANONY = "anonymous";
    public static final RolePermission ROLE_NONE = RolePermission.none();
    public static final RolePermission ROLE_ADMIN = RolePermission.admin();
    public static final String VAR_PREFIX = "$";
    public static final String KEY_OWNER = "$owner";
    public static final String KEY_DYNAMIC = "$dynamic";
    public static final String KEY_ACTION = "$action";

    public void setup(HugeConfig var1);

    public UserWithRole authenticate(String var1, String var2, String var3);

    public AuthManager authManager();

    public HugeGraph graph();

    default public void setup(Map<String, Object> config) {
        E.checkState((config != null ? 1 : 0) != 0, (String)"Must provide a 'config' in the 'authentication'", (Object[])new Object[0]);
        String path = (String)config.get("tokens");
        E.checkState((path != null ? 1 : 0) != 0, (String)"Credentials configuration missing key 'tokens'", (Object[])new Object[0]);
        OptionSpace.register((String)"tokens", (OptionHolder)ServerOptions.instance());
        this.setup(new HugeConfig(path));
    }

    default public User authenticate(Map<String, String> credentials) throws AuthenticationException {
        HugeGraphAuthProxy.resetContext();
        User user = User.ANONYMOUS;
        if (this.requireAuthentication()) {
            String token;
            String password;
            String username = credentials.get(KEY_USERNAME);
            UserWithRole role = this.authenticate(username, password = credentials.get(KEY_PASSWORD), token = credentials.get(KEY_TOKEN));
            if (!this.verifyRole(role.role())) {
                String message = "Incorrect username or password";
                throw new AuthenticationException(message);
            }
            user = new User(role.username(), role.role());
            user.client(credentials.get(KEY_ADDRESS));
        }
        HugeGraphAuthProxy.logUser(user, credentials.get(KEY_PATH));
        HugeGraphAuthProxy.setContext(new HugeGraphAuthProxy.Context(user));
        return user;
    }

    default public boolean requireAuthentication() {
        return true;
    }

    default public boolean verifyRole(RolePermission role) {
        return role != ROLE_NONE && role != null;
    }

    public void initAdminUser(String var1) throws Exception;

    public static HugeAuthenticator loadAuthenticator(HugeConfig conf) {
        HugeAuthenticator authenticator;
        String authClass = (String)conf.get(ServerOptions.AUTHENTICATOR);
        if (authClass.isEmpty()) {
            return null;
        }
        ClassLoader cl = conf.getClass().getClassLoader();
        try {
            authenticator = (HugeAuthenticator)cl.loadClass(authClass).newInstance();
        }
        catch (Exception e) {
            throw new HugeException("Failed to load authenticator: '%s'", new Object[]{authClass, e});
        }
        authenticator.setup(conf);
        return authenticator;
    }

    public static class RequiredPerm {
        @JsonProperty(value="owner")
        private String owner = "";
        @JsonProperty(value="action")
        private HugePermission action = HugePermission.NONE;
        @JsonProperty(value="resource")
        private ResourceType resource = ResourceType.NONE;

        public RequiredPerm owner(String owner) {
            this.owner = owner;
            return this;
        }

        public String owner() {
            return this.owner;
        }

        public RequiredPerm action(String action) {
            this.parseAction(action);
            return this;
        }

        public HugePermission action() {
            return this.action;
        }

        public ResourceType resource() {
            return this.resource;
        }

        public ResourceObject<?> resourceObject() {
            HugeResource.NameObject elem = HugeResource.NameObject.ANY;
            return ResourceObject.of((String)this.owner, (ResourceType)this.resource, (Nameable)elem);
        }

        public String toString() {
            return JsonUtil.toJson((Object)this);
        }

        private void parseAction(String action) {
            int offset = action.lastIndexOf(95);
            if (0 < offset && ++offset < action.length()) {
                String resource = action.substring(0, offset - 1);
                this.resource = ResourceType.valueOf((String)resource.toUpperCase());
                action = action.substring(offset);
            }
            this.action = HugePermission.valueOf((String)action.toUpperCase());
        }

        public static String roleFor(String owner, HugePermission perm) {
            return String.format("%s=%s %s=%s", HugeAuthenticator.KEY_OWNER, owner, HugeAuthenticator.KEY_ACTION, perm.string());
        }

        public static RequiredPerm fromJson(String json) {
            return (RequiredPerm)JsonUtil.fromJson((String)json, RequiredPerm.class);
        }

        public static RequiredPerm fromPermission(String permission) {
            RequiredPerm requiredPerm = new RequiredPerm();
            String[] ownerAndAction = permission.split(" ");
            String[] ownerKV = ownerAndAction[0].split("=", 2);
            E.checkState((ownerKV.length == 2 && ownerKV[0].equals(HugeAuthenticator.KEY_OWNER) ? 1 : 0) != 0, (String)"Bad permission format: '%s'", (Object[])new Object[]{permission});
            requiredPerm.owner(ownerKV[1]);
            if (ownerAndAction.length == 1) {
                return requiredPerm;
            }
            E.checkState((ownerAndAction.length == 2 ? 1 : 0) != 0, (String)"Bad permission format: '%s'", (Object[])new Object[]{permission});
            String[] actionKV = ownerAndAction[1].split("=", 2);
            E.checkState((actionKV.length == 2 ? 1 : 0) != 0, (String)"Bad permission format: '%s'", (Object[])new Object[]{permission});
            E.checkState((boolean)actionKV[0].equals(HugeAuthenticator.KEY_ACTION), (String)"Bad permission format: '%s'", (Object[])new Object[]{permission});
            requiredPerm.action(actionKV[1]);
            return requiredPerm;
        }
    }

    public static class RolePerm {
        @JsonProperty(value="roles")
        private Map<String, Map<HugePermission, Object>> roles;

        public RolePerm() {
            this.roles = new HashMap<String, Map<HugePermission, Object>>();
        }

        public RolePerm(Map<String, Map<HugePermission, Object>> roles) {
            this.roles = roles;
        }

        public String toString() {
            return JsonUtil.toJson((Object)this);
        }

        private boolean matchOwner(String owner) {
            if (owner == null) {
                return true;
            }
            return this.roles.containsKey(owner);
        }

        private boolean matchResource(HugePermission requiredAction, ResourceObject<?> requiredResource) {
            List list;
            E.checkNotNull(requiredResource, (String)"resource object");
            if (HugeResource.allowed(requiredResource)) {
                return true;
            }
            String owner = requiredResource.graph();
            Map<HugePermission, Object> permissions = this.roles.get(owner);
            if (permissions == null) {
                return false;
            }
            Object permission = RolePerm.matchedAction(requiredAction, permissions);
            if (permission == null) {
                return false;
            }
            List ress = permission instanceof List ? (list = (List)permission) : HugeResource.parseResources((String)permission.toString());
            for (HugeResource res : ress) {
                if (!res.filter(requiredResource)) continue;
                return true;
            }
            return false;
        }

        private static Object matchedAction(HugePermission action, Map<HugePermission, Object> perms) {
            Object matched = perms.get(action);
            if (matched != null) {
                return matched;
            }
            for (Map.Entry<HugePermission, Object> e : perms.entrySet()) {
                HugePermission permission = e.getKey();
                if (!action.match(permission)) continue;
                return e.getValue();
            }
            return null;
        }

        public static RolePerm fromJson(Object role) {
            RolePermission table = RolePermission.fromJson((Object)role);
            return new RolePerm(table.map());
        }

        public static boolean match(Object role, RequiredPerm requiredPerm) {
            if (role == ROLE_ADMIN) {
                return true;
            }
            if (role == ROLE_NONE) {
                return false;
            }
            RolePerm rolePerm = RolePerm.fromJson(role);
            if (requiredPerm.action() == HugePermission.NONE) {
                return rolePerm.matchOwner(requiredPerm.owner());
            }
            return rolePerm.matchResource(requiredPerm.action(), requiredPerm.resourceObject());
        }

        public static boolean match(Object role, HugePermission required, ResourceObject<?> resourceObject) {
            if (role == ROLE_ADMIN) {
                return true;
            }
            if (role == ROLE_NONE) {
                return false;
            }
            RolePerm rolePerm = RolePerm.fromJson(role);
            return rolePerm.matchResource(required, resourceObject);
        }

        public static boolean match(Object role, RolePermission grant, ResourceObject<?> resourceObject) {
            SchemaDefine.AuthElement element;
            if (role == ROLE_ADMIN) {
                return true;
            }
            if (role == ROLE_NONE) {
                return false;
            }
            if (resourceObject != null && (element = (SchemaDefine.AuthElement)resourceObject.operated()) instanceof HugeUser && ((HugeUser)element).name().equals(HugeAuthenticator.USER_ADMIN)) {
                return false;
            }
            RolePermission rolePerm = RolePermission.fromJson((Object)role);
            return rolePerm.contains(grant);
        }
    }

    public static class User
    extends AuthenticatedUser {
        public static final User ADMIN = new User("admin", ROLE_ADMIN);
        public static final User ANONYMOUS = new User("anonymous", ROLE_ADMIN);
        private final RolePermission role;
        private final Id userId;
        private String client;

        public User(String username, RolePermission role) {
            super(username);
            E.checkNotNull((Object)username, (String)HugeAuthenticator.KEY_USERNAME);
            E.checkNotNull((Object)role, (String)HugeAuthenticator.KEY_ROLE);
            this.role = role;
            this.client = null;
            this.userId = IdGenerator.of((String)username);
        }

        public String username() {
            return this.getName();
        }

        public Id userId() {
            return this.userId;
        }

        public RolePermission role() {
            return this.role;
        }

        public void client(String client) {
            this.client = client;
        }

        public String client() {
            return this.client;
        }

        public boolean isAnonymous() {
            return this == ANONYMOUS || this == ANONYMOUS_USER;
        }

        public int hashCode() {
            return this.username().hashCode() ^ this.role().hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof User)) {
                return false;
            }
            User other = (User)((Object)object);
            return this.username().equals(other.username()) && this.role().equals((Object)other.role());
        }

        public String toString() {
            return String.format("User{username=%s,role=%s}", this.username(), this.role());
        }

        public String toJson() {
            UserJson json = new UserJson();
            json.username = this.username();
            json.role = this.role();
            json.client = this.client();
            return JsonUtil.toJson((Object)json);
        }

        public static User fromJson(String json) {
            if (json == null) {
                return null;
            }
            UserJson userJson = (UserJson)JsonUtil.fromJson((String)json, UserJson.class);
            if (userJson != null) {
                User user = new User(userJson.username, RolePermission.builtin((RolePermission)userJson.role));
                user.client(userJson.client);
                return user;
            }
            return null;
        }

        public static class UserJson {
            @JsonProperty(value="username")
            private String username;
            @JsonProperty(value="role")
            private RolePermission role;
            @JsonProperty(value="client")
            private String client;
        }
    }
}

