/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.jraft.rpc.impl.cli;

import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.conf.Configuration;
import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.jraft.error.RaftError;
import com.alipay.sofa.jraft.rpc.CliRequests;
import com.alipay.sofa.jraft.rpc.RpcRequestClosure;
import com.alipay.sofa.jraft.rpc.RpcRequests;
import com.alipay.sofa.jraft.rpc.impl.cli.BaseCliRequestProcessor;
import com.alipay.sofa.jraft.util.RpcFactoryHelper;
import com.google.protobuf.Message;
import java.util.Iterator;
import java.util.concurrent.Executor;

public class ResetPeerRequestProcessor
extends BaseCliRequestProcessor<CliRequests.ResetPeerRequest> {
    public ResetPeerRequestProcessor(Executor executor) {
        super(executor, (Message)RpcRequests.ErrorResponse.getDefaultInstance());
    }

    @Override
    protected String getPeerId(CliRequests.ResetPeerRequest request) {
        return request.getPeerId();
    }

    @Override
    protected String getGroupId(CliRequests.ResetPeerRequest request) {
        return request.getGroupId();
    }

    @Override
    protected Message processRequest0(BaseCliRequestProcessor.CliRequestContext ctx, CliRequests.ResetPeerRequest request, RpcRequestClosure done) {
        Configuration newConf = new Configuration();
        Iterator iterator = request.getNewPeersList().iterator();
        while (iterator.hasNext()) {
            PeerId peer = new PeerId();
            String peerIdStr = (String)iterator.next();
            if (peer.parse(peerIdStr)) {
                newConf.addPeer(peer);
                continue;
            }
            return RpcFactoryHelper.responseFactory().newResponse(this.defaultResp(), RaftError.EINVAL, "Fail to parse peer id %s", peerIdStr);
        }
        LOG.info("Receive ResetPeerRequest to {} from {}, new conf is {}", new Object[]{ctx.node.getNodeId(), done.getRpcCtx().getRemoteAddress(), newConf});
        Status st = ctx.node.resetPeers(newConf);
        return RpcFactoryHelper.responseFactory().newResponse(this.defaultResp(), st);
    }

    @Override
    public String interest() {
        return CliRequests.ResetPeerRequest.class.getName();
    }
}

