/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.curator.framework.imps;

import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.apache.hadoop.hbase.shaded.org.apache.curator.RetryLoop;
import org.apache.hadoop.hbase.shaded.org.apache.curator.TimeTrace;
import org.apache.hadoop.hbase.shaded.org.apache.curator.framework.api.BackgroundCallback;
import org.apache.hadoop.hbase.shaded.org.apache.curator.framework.api.BackgroundPathable;
import org.apache.hadoop.hbase.shaded.org.apache.curator.framework.api.BackgroundPathableQuietlyable;
import org.apache.hadoop.hbase.shaded.org.apache.curator.framework.api.CuratorEventType;
import org.apache.hadoop.hbase.shaded.org.apache.curator.framework.api.CuratorWatcher;
import org.apache.hadoop.hbase.shaded.org.apache.curator.framework.api.ErrorListenerPathable;
import org.apache.hadoop.hbase.shaded.org.apache.curator.framework.api.Pathable;
import org.apache.hadoop.hbase.shaded.org.apache.curator.framework.api.RemoveWatchesBuilder;
import org.apache.hadoop.hbase.shaded.org.apache.curator.framework.api.RemoveWatchesLocal;
import org.apache.hadoop.hbase.shaded.org.apache.curator.framework.api.RemoveWatchesType;
import org.apache.hadoop.hbase.shaded.org.apache.curator.framework.api.UnhandledErrorListener;
import org.apache.hadoop.hbase.shaded.org.apache.curator.framework.imps.BackgroundOperation;
import org.apache.hadoop.hbase.shaded.org.apache.curator.framework.imps.Backgrounding;
import org.apache.hadoop.hbase.shaded.org.apache.curator.framework.imps.CuratorEventImpl;
import org.apache.hadoop.hbase.shaded.org.apache.curator.framework.imps.CuratorFrameworkImpl;
import org.apache.hadoop.hbase.shaded.org.apache.curator.framework.imps.FailedRemoveWatchManager;
import org.apache.hadoop.hbase.shaded.org.apache.curator.framework.imps.NamespaceWatcher;
import org.apache.hadoop.hbase.shaded.org.apache.curator.framework.imps.OperationAndData;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.AsyncCallback;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.Watcher;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.ZooKeeper;

public class RemoveWatchesBuilderImpl
implements RemoveWatchesBuilder,
RemoveWatchesType,
RemoveWatchesLocal,
BackgroundOperation<String>,
ErrorListenerPathable<Void> {
    private CuratorFrameworkImpl client;
    private Watcher watcher;
    private CuratorWatcher curatorWatcher;
    private Watcher.WatcherType watcherType;
    private boolean guaranteed;
    private boolean local;
    private boolean quietly;
    private Backgrounding backgrounding;

    public RemoveWatchesBuilderImpl(CuratorFrameworkImpl client) {
        this.client = client;
        this.watcher = null;
        this.curatorWatcher = null;
        this.watcherType = Watcher.WatcherType.Any;
        this.guaranteed = false;
        this.local = false;
        this.quietly = false;
        this.backgrounding = new Backgrounding();
    }

    public RemoveWatchesBuilderImpl(CuratorFrameworkImpl client, Watcher watcher, CuratorWatcher curatorWatcher, Watcher.WatcherType watcherType, boolean guaranteed, boolean local, boolean quietly, Backgrounding backgrounding) {
        this.client = client;
        this.watcher = watcher;
        this.curatorWatcher = curatorWatcher;
        this.watcherType = watcherType;
        this.guaranteed = guaranteed;
        this.local = local;
        this.quietly = quietly;
        this.backgrounding = backgrounding;
    }

    void internalRemoval(Watcher watcher, String path) throws Exception {
        this.watcher = watcher;
        this.watcherType = Watcher.WatcherType.Any;
        this.quietly = true;
        this.guaranteed = true;
        if (Boolean.getBoolean("curator-remove-watchers-in-foreground")) {
            this.backgrounding = new Backgrounding();
            this.pathInForeground(path);
        } else {
            this.backgrounding = new Backgrounding(true);
            this.pathInBackground(path);
        }
    }

    @Override
    public RemoveWatchesType remove(Watcher watcher) {
        this.watcher = watcher;
        this.curatorWatcher = null;
        return this;
    }

    @Override
    public RemoveWatchesType remove(CuratorWatcher watcher) {
        this.watcher = null;
        this.curatorWatcher = watcher;
        return this;
    }

    @Override
    public RemoveWatchesType removeAll() {
        this.watcher = null;
        this.curatorWatcher = null;
        return this;
    }

    @Override
    public RemoveWatchesLocal ofType(Watcher.WatcherType watcherType) {
        this.watcherType = watcherType;
        return this;
    }

    @Override
    public ErrorListenerPathable<Void> inBackground(BackgroundCallback callback, Object context) {
        this.backgrounding = new Backgrounding(callback, context);
        return this;
    }

    @Override
    public ErrorListenerPathable<Void> inBackground(BackgroundCallback callback, Object context, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, context, executor);
        return this;
    }

    @Override
    public ErrorListenerPathable<Void> inBackground(BackgroundCallback callback) {
        this.backgrounding = new Backgrounding(callback);
        return this;
    }

    @Override
    public ErrorListenerPathable<Void> inBackground(BackgroundCallback callback, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, executor);
        return this;
    }

    @Override
    public ErrorListenerPathable<Void> inBackground() {
        this.backgrounding = new Backgrounding(true);
        return this;
    }

    @Override
    public ErrorListenerPathable<Void> inBackground(Object context) {
        this.backgrounding = new Backgrounding(context);
        return this;
    }

    @Override
    public Pathable<Void> withUnhandledErrorListener(UnhandledErrorListener listener) {
        this.backgrounding = new Backgrounding(this.backgrounding, listener);
        return this;
    }

    @Override
    public RemoveWatchesLocal guaranteed() {
        this.guaranteed = true;
        return this;
    }

    @Override
    public BackgroundPathableQuietlyable<Void> locally() {
        this.local = true;
        return this;
    }

    @Override
    public BackgroundPathable<Void> quietly() {
        this.quietly = true;
        return this;
    }

    @Override
    public Void forPath(String path) throws Exception {
        String adjustedPath = this.client.fixForNamespace(path);
        if (this.backgrounding.inBackground()) {
            this.pathInBackground(adjustedPath);
        } else {
            this.pathInForeground(adjustedPath);
        }
        return null;
    }

    private void pathInBackground(final String path) {
        OperationAndData.ErrorCallback<String> errorCallback = null;
        if (this.guaranteed) {
            errorCallback = new OperationAndData.ErrorCallback<String>(){

                @Override
                public void retriesExhausted(OperationAndData<String> operationAndData) {
                    RemoveWatchesBuilderImpl.this.client.getFailedRemoveWatcherManager().addFailedOperation(new FailedRemoveWatchManager.FailedRemoveWatchDetails(path, RemoveWatchesBuilderImpl.this.watcher));
                }
            };
        }
        this.client.processBackgroundOperation(new OperationAndData<String>(this, path, this.backgrounding.getCallback(), errorCallback, this.backgrounding.getContext(), !this.local), null);
    }

    private void pathInForeground(final String path) throws Exception {
        NamespaceWatcher namespaceWatcher = this.makeNamespaceWatcher(path);
        if (this.local) {
            ZooKeeper zkClient = this.client.getZooKeeper();
            if (namespaceWatcher != null) {
                zkClient.removeWatches(path, namespaceWatcher, this.watcherType, this.local);
            } else {
                zkClient.removeAllWatches(path, this.watcherType, this.local);
            }
        } else {
            final NamespaceWatcher finalNamespaceWatcher = namespaceWatcher;
            RetryLoop.callWithRetry(this.client.getZookeeperClient(), new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    block5: {
                        try {
                            ZooKeeper zkClient = RemoveWatchesBuilderImpl.this.client.getZookeeperClient().getZooKeeper();
                            if (finalNamespaceWatcher != null) {
                                zkClient.removeWatches(path, finalNamespaceWatcher, RemoveWatchesBuilderImpl.this.watcherType, false);
                            } else {
                                zkClient.removeAllWatches(path, RemoveWatchesBuilderImpl.this.watcherType, false);
                            }
                        }
                        catch (Exception e) {
                            if (RetryLoop.isRetryException(e) && RemoveWatchesBuilderImpl.this.guaranteed) {
                                RemoveWatchesBuilderImpl.this.client.getFailedRemoveWatcherManager().addFailedOperation(new FailedRemoveWatchManager.FailedRemoveWatchDetails(path, finalNamespaceWatcher));
                                throw e;
                            }
                            if (e instanceof KeeperException.NoWatcherException && RemoveWatchesBuilderImpl.this.quietly) break block5;
                            throw e;
                        }
                    }
                    return null;
                }
            });
        }
    }

    private NamespaceWatcher makeNamespaceWatcher(String path) {
        NamespaceWatcher namespaceWatcher = null;
        if (this.watcher != null) {
            namespaceWatcher = this.watcher instanceof NamespaceWatcher ? (NamespaceWatcher)this.watcher : new NamespaceWatcher(this.client, this.watcher, path);
        } else if (this.curatorWatcher != null) {
            namespaceWatcher = new NamespaceWatcher(this.client, this.curatorWatcher, path);
        }
        return namespaceWatcher;
    }

    @Override
    public void performBackgroundOperation(final OperationAndData<String> operationAndData) throws Exception {
        try {
            final TimeTrace trace = this.client.getZookeeperClient().startTracer("RemoteWatches-Background");
            AsyncCallback.VoidCallback callback = new AsyncCallback.VoidCallback(){

                @Override
                public void processResult(int rc, String path, Object ctx) {
                    trace.commit();
                    CuratorEventImpl event = new CuratorEventImpl(RemoveWatchesBuilderImpl.this.client, CuratorEventType.REMOVE_WATCHES, rc, path, null, ctx, null, null, null, null, null, null);
                    RemoveWatchesBuilderImpl.this.client.processBackgroundOperation(operationAndData, event);
                }
            };
            ZooKeeper zkClient = this.client.getZooKeeper();
            NamespaceWatcher namespaceWatcher = this.makeNamespaceWatcher(operationAndData.getData());
            if (namespaceWatcher == null) {
                zkClient.removeAllWatches(operationAndData.getData(), this.watcherType, this.local, callback, operationAndData.getContext());
            } else {
                zkClient.removeWatches(operationAndData.getData(), namespaceWatcher, this.watcherType, this.local, callback, operationAndData.getContext());
            }
        }
        catch (Throwable e) {
            this.backgrounding.checkError(e, null);
        }
    }
}

