/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.job.algorithm.cent;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.job.UserJob;
import org.apache.hugegraph.job.algorithm.AbstractAlgorithm;
import org.apache.hugegraph.job.algorithm.cent.AbstractCentAlgorithm;
import org.apache.hugegraph.structure.HugeEdge;
import org.apache.hugegraph.traversal.algorithm.steps.EdgeStep;
import org.apache.hugegraph.type.define.Directions;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class DegreeCentralityAlgorithm
extends AbstractCentAlgorithm {
    @Override
    public String name() {
        return "degree_centrality";
    }

    @Override
    public void checkParameters(Map<String, Object> parameters) {
        DegreeCentralityAlgorithm.direction(parameters);
        DegreeCentralityAlgorithm.edgeLabel(parameters);
        DegreeCentralityAlgorithm.top(parameters);
    }

    @Override
    public Object call(UserJob<Object> job, Map<String, Object> parameters) {
        try (Traverser traverser = new Traverser(job);){
            Object object = traverser.degreeCentrality(DegreeCentralityAlgorithm.direction(parameters), DegreeCentralityAlgorithm.edgeLabel(parameters), DegreeCentralityAlgorithm.top(parameters));
            return object;
        }
    }

    private static class Traverser
    extends AbstractAlgorithm.AlgoTraverser {
        public Traverser(UserJob<Object> job) {
            super(job);
        }

        public Object degreeCentrality(Directions direction, String label, long topN) {
            if (direction == null || direction == Directions.BOTH) {
                return this.degreeCentralityForBothDir(label, topN);
            }
            assert (direction == Directions.OUT || direction == Directions.IN);
            assert (topN >= 0L || topN == -1L);
            Iterator<Edge> edges = this.edges(direction);
            AbstractAlgorithm.JsonMap degrees = new AbstractAlgorithm.JsonMap();
            AbstractAlgorithm.TopMap<Id> tops = new AbstractAlgorithm.TopMap<Id>(topN);
            Id vertex = null;
            Id labelId = this.getEdgeLabelId(label);
            long degree = 0L;
            long totalEdges = 0L;
            degrees.startObject();
            while (edges.hasNext()) {
                HugeEdge edge = (HugeEdge)edges.next();
                this.updateProgress(++totalEdges);
                Id schemaLabel = edge.schemaLabel().id();
                if (labelId != null && !labelId.equals(schemaLabel)) continue;
                Id source = edge.ownerVertex().id();
                if (source.equals(vertex)) {
                    ++degree;
                    continue;
                }
                if (vertex != null) {
                    if (topN <= 0L && topN != -1L) {
                        degrees.append((Object)vertex, degree);
                    } else {
                        tops.put(vertex, degree);
                    }
                }
                vertex = source;
                degree = 1L;
            }
            if (vertex != null) {
                if (topN <= 0L && topN != -1L) {
                    degrees.append((Object)vertex, degree);
                } else {
                    tops.put(vertex, degree);
                    degrees.append(tops.entrySet());
                }
            }
            degrees.endObject();
            return degrees.asJson();
        }

        protected Object degreeCentralityForBothDir(String label, long topN) {
            assert (topN >= 0L || topN == -1L);
            long totalVertices = 0L;
            AbstractAlgorithm.JsonMap degrees = new AbstractAlgorithm.JsonMap();
            AbstractAlgorithm.TopMap<Id> tops = new AbstractAlgorithm.TopMap<Id>(topN);
            Iterator<Vertex> vertices = this.vertices();
            degrees.startObject();
            while (vertices.hasNext()) {
                Id source = (Id)vertices.next().id();
                this.updateProgress(++totalVertices);
                long degree = this.degree(source, label);
                if (degree <= 0L) continue;
                if (topN <= 0L && topN != -1L) {
                    degrees.append((Object)source, degree);
                    continue;
                }
                tops.put(source, degree);
            }
            if (tops.size() > 0) {
                degrees.append(tops.entrySet());
            }
            degrees.endObject();
            return degrees.asJson();
        }

        private long degree(Id source, String label) {
            List<String> labels = label == null ? null : Collections.singletonList(label);
            EdgeStep step = new EdgeStep(this.graph(), Directions.BOTH, labels, null, -1L, 0L);
            return this.edgesCount(source, step);
        }
    }
}

