/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.module;

import com.alipay.sofa.rpc.common.RpcConfigs;
import com.alipay.sofa.rpc.common.utils.ClassUtils;
import com.alipay.sofa.rpc.config.JAXRSProviderManager;
import com.alipay.sofa.rpc.event.EventBus;
import com.alipay.sofa.rpc.event.RestTracerSubscriber;
import com.alipay.sofa.rpc.event.rest.RestServerReceiveEvent;
import com.alipay.sofa.rpc.event.rest.RestServerSendEvent;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.module.Module;
import com.alipay.sofa.rpc.server.rest.TraceRequestFilter;
import com.alipay.sofa.rpc.server.rest.TraceResponseFilter;
import com.alipay.sofa.rpc.tracer.Tracer;
import com.alipay.sofa.rpc.tracer.TracerFactory;
import com.alipay.sofa.rpc.transport.rest.TraceClientRequestFilter;
import com.alipay.sofa.rpc.transport.rest.TraceClientResponseFilter;

@Extension(value="sofaTracer-resteasy")
public class RestTracerModule
implements Module {
    private RestTracerSubscriber subscriber;

    public static boolean isEnable() {
        boolean enable = "sofaTracer".equals(RpcConfigs.getStringValue("default.tracer"));
        if (enable) {
            try {
                ClassUtils.forName("javax.ws.rs.container.ContainerRequestFilter");
                ClassUtils.forName("javax.ws.rs.container.ContainerResponseFilter");
                ClassUtils.forName("org.jboss.resteasy.core.interception.PostMatchContainerRequestContext");
                ClassUtils.forName("org.jboss.resteasy.plugins.server.netty.NettyHttpRequest");
                ClassUtils.forName("org.jboss.resteasy.plugins.server.netty.NettyHttpResponse");
            }
            catch (Exception e) {
                return false;
            }
        }
        return enable;
    }

    @Override
    public boolean needLoad() {
        return RestTracerModule.isEnable();
    }

    @Override
    public void install() {
        Tracer tracer = TracerFactory.getTracer("sofaTracer");
        if (tracer != null) {
            this.subscriber = new RestTracerSubscriber();
            EventBus.register(RestServerReceiveEvent.class, this.subscriber);
            EventBus.register(RestServerSendEvent.class, this.subscriber);
        }
        JAXRSProviderManager.registerInternalProviderClass(TraceRequestFilter.class);
        JAXRSProviderManager.registerInternalProviderClass(TraceResponseFilter.class);
        JAXRSProviderManager.registerInternalProviderClass(TraceClientRequestFilter.class);
        JAXRSProviderManager.registerInternalProviderClass(TraceClientResponseFilter.class);
    }

    @Override
    public void uninstall() {
        if (this.subscriber != null) {
            EventBus.unRegister(RestServerReceiveEvent.class, this.subscriber);
            EventBus.unRegister(RestServerSendEvent.class, this.subscriber);
        }
    }
}

