/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.structure.gremlin;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.hugegraph.driver.GraphManager;
import org.apache.hugegraph.rest.SerializeException;
import org.apache.hugegraph.serializer.PathDeserializer;
import org.apache.hugegraph.structure.constant.GraphAttachable;
import org.apache.hugegraph.structure.graph.Edge;
import org.apache.hugegraph.structure.graph.Path;
import org.apache.hugegraph.structure.graph.Vertex;
import org.apache.hugegraph.structure.gremlin.Result;
import org.apache.hugegraph.util.E;

public class ResultSet {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private GraphManager graphManager = null;
    @JsonProperty
    private List<Object> data;
    @JsonProperty
    private Map<String, ?> meta;

    public void graphManager(GraphManager graphManager) {
        this.graphManager = graphManager;
    }

    public List<Object> data() {
        return this.data;
    }

    public int size() {
        return this.data.size();
    }

    public Result get(int index) {
        if (index >= this.data.size()) {
            return null;
        }
        Object object = this.data().get(index);
        if (object == null) {
            return null;
        }
        Class<?> clazz = this.parseResultClass(object);
        if (clazz.equals(object.getClass())) {
            return new Result(object);
        }
        try {
            String rawValue = MAPPER.writeValueAsString(object);
            object = MAPPER.readValue(rawValue, clazz);
            if (object instanceof GraphAttachable) {
                ((GraphAttachable)object).attachManager(this.graphManager);
            }
            return new Result(object);
        }
        catch (Exception e) {
            throw new SerializeException("Failed to deserialize: %s", (Throwable)e, object);
        }
    }

    private Class<?> parseResultClass(Object object) {
        if (object.getClass().equals(LinkedHashMap.class)) {
            Map map = (Map)object;
            String type = (String)map.get("type");
            if (type != null) {
                if ("vertex".equals(type)) {
                    return Vertex.class;
                }
                if ("edge".equals(type)) {
                    return Edge.class;
                }
            } else if (map.get("labels") != null) {
                return Path.class;
            }
        }
        return object.getClass();
    }

    public Iterator<Result> iterator() {
        E.checkState(this.data != null, "Invalid response from server", new Object[0]);
        E.checkState(this.graphManager != null, "Must hold a graph manager", new Object[0]);
        return new Iterator<Result>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < ResultSet.this.data.size();
            }

            @Override
            public Result next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return ResultSet.this.get(this.index++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    static {
        SimpleModule module = new SimpleModule();
        module.addDeserializer(Path.class, new PathDeserializer());
        MAPPER.registerModule(module);
    }
}

