/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.adapter;

import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.DatastoreId;
import org.datanucleus.metadata.JdbcType;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.rdbms.adapter.BaseDatastoreAdapter;
import org.datanucleus.store.rdbms.adapter.SQLServerTypeInfo;
import org.datanucleus.store.rdbms.identifier.IdentifierFactory;
import org.datanucleus.store.rdbms.key.Index;
import org.datanucleus.store.rdbms.mapping.column.BigIntColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.BinaryStreamColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.BitColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.BlobColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.BooleanColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.CharColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.ClobColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.DateColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.DecimalColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.DoubleColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.FloatColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.IntegerColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.LongVarBinaryColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.LongVarcharColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.NCharColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.NVarcharColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.NumericColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.RealColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.SmallIntColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.TimeColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.TimestampColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.VarBinaryColumnMapping;
import org.datanucleus.store.rdbms.mapping.column.VarCharColumnMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.schema.RDBMSColumnInfo;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.SQLText;
import org.datanucleus.store.rdbms.sql.SelectStatement;
import org.datanucleus.store.rdbms.sql.method.SQLCubeFunction;
import org.datanucleus.store.rdbms.sql.method.SQLMethod;
import org.datanucleus.store.rdbms.sql.method.SQLRollupFunction;
import org.datanucleus.store.rdbms.sql.method.StringConcat2Method;
import org.datanucleus.store.rdbms.sql.method.StringIndexOf4Method;
import org.datanucleus.store.rdbms.sql.method.StringLength4Method;
import org.datanucleus.store.rdbms.sql.method.StringStartsWith2Method;
import org.datanucleus.store.rdbms.sql.method.StringSubstring4Method;
import org.datanucleus.store.rdbms.sql.method.StringTrim2Method;
import org.datanucleus.store.rdbms.sql.method.TemporalDayOfWeekMethod4;
import org.datanucleus.store.rdbms.sql.method.TemporalHourMethod4;
import org.datanucleus.store.rdbms.sql.method.TemporalMinuteMethod4;
import org.datanucleus.store.rdbms.sql.method.TemporalQuarterMethod4;
import org.datanucleus.store.rdbms.sql.method.TemporalSecondMethod4;
import org.datanucleus.store.rdbms.sql.method.TemporalWeekMethod4;
import org.datanucleus.store.rdbms.sql.operation.Concat2Operation;
import org.datanucleus.store.rdbms.sql.operation.SQLOperation;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.store.schema.StoreSchemaHandler;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class SQLServerAdapter
extends BaseDatastoreAdapter {
    private static final String MSSQL_RESERVED_WORDS = "ADD,ALL,ALTER,AND,ANY,AS,ASC,AUTHORIZATION,BACKUP,BEGIN,BETWEEN,BREAK,BROWSE,BULK,BY,CASCADE,CASE,CHECK,CHECKPOINT,CLOSE,CLUSTERED,COALESCE,COLLATE,COLUMN,COMMIT,COMPUTE,CONSTRAINT,CONTAINS,CONTAINSTABLE,CONTINUE,CONVERT,CREATE,CROSS,CURRENT,CURRENT_DATE,CURRENT_TIME,CURRENT_TIMESTAMP,CURRENT_USER,CURSOR,DBCC,DEALLOCATE,DECLARE,DEFAULT,DELETE,DENY,DESC,DISK,DISTINCT,DISTRIBUTED,DOUBLE,DROP,DUMMY,DUMP,ELSE,END,ERRLVL,ESCAPE,EXCEPT,EXEC,EXECUTE,EXISTS,EXIT,FETCH,FILE,FILLFACTOR,FOR,FOREIGN,FREETEXT,FREETEXTTABLE,FROM,FULL,FUNCTION,GOTO,GRANT,GROUP,HAVING,HOLDLOCK,IDENTITY,IDENTITY_INSERT,IDENTITYCOL,IF,IN,INDEX,INNER,INSERT,INTERSECT,INTO,IS,JOIN,KEY,KILL,LEFT,LIKE,LINENO,LOAD,NATIONAL,NOCHECK,NONCLUSTERED,NOT,NULL,NULLIF,OF,OFF,OFFSETS,ON,OPEN,OPENDATASOURCE,OPENQUERY,OPENROWSET,OPENXML,OPTION,OR,ORDER,OUTER,OVER,PERCENT,PLAN,PRECISION,PRIMARY,PRINT,PROC,PROCEDURE,PUBLIC,RAISERROR,READ,READTEXT,RECONFIGURE,REFERENCES,REPLICATION,RESTORE,RESTRICT,RETURN,REVOKE,RIGHT,ROLLBACK,ROWCOUNT,ROWGUIDCOL,RULE,SAVE,SCHEMA,SELECT,SESSION_USER,SET,SETUSER,SHUTDOWN,SOME,STATISTICS,SYSTEM_USER,TABLE,TEXTSIZE,THEN,TO,TOP,TRAN,DATABASE,TRANSACTION,TRIGGER,TRUNCATE,TSEQUAL,UNION,UNIQUE,UPDATE,UPDATETEXT,USE,USER,VALUES,VARYING,VIEW,WAITFOR,WHEN,WHERE,WHILE,WITH,WRITETEXT";

    public SQLServerAdapter(DatabaseMetaData metadata) {
        super(metadata);
        this.reservedKeywords.addAll(StringUtils.convertCommaSeparatedStringToSet((String)MSSQL_RESERVED_WORDS));
        this.supportedOptions.add("IdentityColumns");
        this.supportedOptions.add("LockRowUsingOptionAfterFrom");
        this.supportedOptions.add("LockRowUsingOptionWithinJoin");
        this.supportedOptions.add("StoredProcs");
        this.supportedOptions.add("OrderByNullsUsingCaseNull");
        this.supportedOptions.remove("BooleanExpression");
        this.supportedOptions.remove("DeferredConstraints");
        this.supportedOptions.remove("FkDeleteActionDefault");
        this.supportedOptions.remove("FkDeleteActionRestrict");
        this.supportedOptions.remove("FkDeleteActionNull");
        this.supportedOptions.remove("FkUpdateActionDefault");
        this.supportedOptions.remove("FkUpdateActionRestrict");
        this.supportedOptions.remove("FkUpdateActionNull");
        if (this.datastoreMajorVersion >= 11) {
            this.supportedOptions.add("Sequences");
        }
        if (this.datastoreMajorVersion >= 12) {
            this.supportedOptions.add("BitwiseAndOperator");
            this.supportedOptions.add("BitwiseOrOperator");
            this.supportedOptions.add("BitwiseXOrOperator");
        }
    }

    @Override
    public void initialiseTypes(StoreSchemaHandler handler, ManagedConnection mconn) {
        super.initialiseTypes(handler, mconn);
        SQLServerTypeInfo sqlType = new SQLServerTypeInfo("UNIQUEIDENTIFIER", 1, 36, "'", "'", "", 1, false, 2, false, false, false, "UNIQUEIDENTIFIER", 0, 0, 10);
        sqlType.setAllowsPrecisionSpec(false);
        this.addSQLTypeForJDBCType(handler, mconn, (short)-11, sqlType, true);
        sqlType = new SQLServerTypeInfo("IMAGE", 2004, Integer.MAX_VALUE, null, null, null, 1, false, 1, false, false, false, "BLOB", 0, 0, 0);
        this.addSQLTypeForJDBCType(handler, mconn, (short)2004, sqlType, true);
        sqlType = new SQLServerTypeInfo("varbinary", -3, 8000, "0x", null, "(max)", 1, false, 2, false, false, false, "varbinary", 0, 0, 0);
        this.addSQLTypeForJDBCType(handler, mconn, (short)-3, sqlType, true);
        sqlType = new SQLServerTypeInfo("TEXT", 2005, Integer.MAX_VALUE, null, null, null, 1, true, 1, false, false, false, "TEXT", 0, 0, 0);
        this.addSQLTypeForJDBCType(handler, mconn, (short)2005, sqlType, true);
        sqlType = new SQLServerTypeInfo("float", 8, 53, null, null, null, 1, false, 2, false, false, false, null, 0, 0, 2);
        this.addSQLTypeForJDBCType(handler, mconn, (short)8, sqlType, true);
        sqlType = new SQLServerTypeInfo("float", 6, 53, null, null, null, 1, false, 2, false, false, false, null, 0, 0, 2);
        this.addSQLTypeForJDBCType(handler, mconn, (short)6, sqlType, true);
        sqlType = new SQLServerTypeInfo("IMAGE", -4, Integer.MAX_VALUE, null, null, null, 1, false, 1, false, false, false, "LONGVARBINARY", 0, 0, 0);
        this.addSQLTypeForJDBCType(handler, mconn, (short)-4, sqlType, true);
        if (this.datastoreMajorVersion > 9) {
            sqlType = new SQLServerTypeInfo("TIME", 92, 0, null, null, null, 1, false, 1, true, true, false, "TIME", 0, 0, 0);
            this.addSQLTypeForJDBCType(handler, mconn, (short)92, sqlType, true);
            sqlType = new SQLServerTypeInfo("DATE", 91, 0, null, null, null, 1, false, 1, true, true, false, "DATE", 0, 0, 0);
            this.addSQLTypeForJDBCType(handler, mconn, (short)91, sqlType, true);
        }
    }

    @Override
    public String getVendorID() {
        return "sqlserver";
    }

    @Override
    public String getCatalogName(Connection conn) throws SQLException {
        String catalog = conn.getCatalog();
        return catalog != null ? catalog : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSchemaName(Connection conn) throws SQLException {
        if (this.datastoreMajorVersion >= 9) {
            try (Statement stmt = conn.createStatement();){
                String string;
                String stmtText = "SELECT SCHEMA_NAME();";
                ResultSet rs = stmt.executeQuery(stmtText);
                try {
                    if (!rs.next()) {
                        throw new NucleusDataStoreException("No result returned from " + stmtText).setFatal();
                    }
                    string = rs.getString(1);
                }
                catch (Throwable throwable) {
                    rs.close();
                    throw throwable;
                }
                rs.close();
                return string;
            }
        }
        return "";
    }

    @Override
    public boolean isReservedKeyword(String word) {
        if (super.isReservedKeyword(word)) {
            return true;
        }
        return word.indexOf(32) >= 0;
    }

    @Override
    public String getDropDatabaseStatement(String catalogName, String schemaName) {
        throw new UnsupportedOperationException("SQLServer does not support dropping schema with cascade. You need to drop all tables first");
    }

    @Override
    public String getCreateIndexStatement(Index idx, IdentifierFactory factory) {
        String extendedSetting = idx.getValueForExtension("extended-setting");
        String indexType = idx.getValueForExtension("index-type");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CREATE").append(idx.getUnique() ? " UNIQUE" : "");
        if (indexType != null) {
            stringBuilder.append(indexType.equalsIgnoreCase("CLUSTERED") ? " CLUSTERED" : (indexType.equalsIgnoreCase("NONCLUSTERED") ? " NONCLUSTERED" : ""));
        }
        stringBuilder.append(" INDEX ");
        stringBuilder.append(factory.getIdentifierInAdapterCase(idx.getName()));
        stringBuilder.append(" ON ").append(idx.getTable().toString());
        stringBuilder.append(" ").append(idx.getColumnList(true));
        if (extendedSetting != null) {
            stringBuilder.append(" ").append(extendedSetting);
        }
        return stringBuilder.toString();
    }

    @Override
    public String getSelectNewUUIDStmt() {
        return "SELECT NEWID()";
    }

    @Override
    public String getNewUUIDFunction() {
        return "NEWID()";
    }

    @Override
    public boolean supportsQueryFetchSize(int size) {
        return size >= 1;
    }

    @Override
    public RDBMSColumnInfo newRDBMSColumnInfo(ResultSet rs) {
        RDBMSColumnInfo info = new RDBMSColumnInfo(rs);
        short dataType = info.getDataType();
        switch (dataType) {
            case 91: 
            case 92: 
            case 93: {
                info.setDecimalDigits(0);
                break;
            }
        }
        return info;
    }

    @Override
    public SQLTypeInfo newSQLTypeInfo(ResultSet rs) {
        SQLServerTypeInfo ti = new SQLServerTypeInfo(rs);
        String typeName = ti.getTypeName();
        if (typeName.toLowerCase().startsWith("tinyint")) {
            return null;
        }
        if (typeName.toLowerCase().startsWith("varbinary")) {
            return null;
        }
        return ti;
    }

    @Override
    public String getDropTableStatement(Table table) {
        return "DROP TABLE " + table.toString();
    }

    @Override
    public String getDeleteTableStatement(SQLTable tbl) {
        return "DELETE " + tbl.getAlias() + " FROM " + tbl.toString();
    }

    @Override
    public SQLText getUpdateTableStatement(SQLTable tbl, SQLText setSQL) {
        SQLText sql = new SQLText("UPDATE ").append(tbl.getAlias().toString());
        sql.append(" ").append(setSQL);
        sql.append(" FROM ").append(tbl.toString());
        return sql;
    }

    @Override
    public String getIdentityLastValueStmt(Table table, String columnName) {
        return "SELECT @@IDENTITY";
    }

    @Override
    public String getIdentityKeyword(StoreManager storeMgr) {
        return "IDENTITY";
    }

    @Override
    public boolean isIdentityFieldDataType(String columnDef) {
        if (columnDef == null) {
            return false;
        }
        return columnDef.equalsIgnoreCase("uniqueidentifier");
    }

    @Override
    public String getInsertStatementForNoColumns(Table table) {
        return "INSERT INTO " + table.toString() + " DEFAULT VALUES";
    }

    @Override
    public String getSelectWithLockOption() {
        return "(UPDLOCK, ROWLOCK)";
    }

    @Override
    public boolean validToSelectMappingInStatement(SelectStatement stmt, JavaTypeMapping m) {
        if (m.getNumberOfColumnMappings() <= 0) {
            return true;
        }
        for (int i = 0; i < m.getNumberOfColumnMappings(); ++i) {
            Column col = m.getColumnMapping(i).getColumn();
            if (col.getJdbcType() != JdbcType.CLOB && col.getJdbcType() != JdbcType.BLOB) continue;
            if (stmt.isDistinct()) {
                NucleusLogger.QUERY.debug((Object)("Not selecting " + m + " since is for BLOB/CLOB and using DISTINCT"));
                return false;
            }
            if (stmt.getNumberOfUnions() <= 0) continue;
            NucleusLogger.QUERY.debug((Object)("Not selecting " + m + " since is for BLOB/CLOB and using UNION"));
            return false;
        }
        return true;
    }

    @Override
    public boolean isStatementTimeout(SQLException sqle) {
        if (sqle.getSQLState() != null && sqle.getSQLState().equalsIgnoreCase("HY008")) {
            return true;
        }
        return super.isStatementTimeout(sqle);
    }

    @Override
    public String getRangeByLimitEndOfStatementClause(long offset, long count, boolean hasOrdering) {
        if (this.datastoreMajorVersion < 11) {
            return "";
        }
        if (offset <= 0L && count <= 0L) {
            return "";
        }
        if (!hasOrdering) {
            return "";
        }
        StringBuilder str = new StringBuilder();
        str.append("OFFSET " + offset + (offset == 1L ? " ROW " : " ROWS "));
        if (count > 0L) {
            str.append("FETCH NEXT " + count + (count == 1L ? " ROW " : " ROWS ") + "ONLY ");
        }
        return str.toString();
    }

    @Override
    public String getSequenceCreateStmt(String sequenceName, Integer min, Integer max, Integer start, Integer increment, Integer cacheSize) {
        if (this.datastoreMajorVersion < 11) {
            return super.getSequenceCreateStmt(sequenceName, min, max, start, increment, cacheSize);
        }
        if (sequenceName == null) {
            throw new NucleusUserException(Localiser.msg((String)"051028"));
        }
        StringBuilder stmt = new StringBuilder("CREATE SEQUENCE ");
        stmt.append(sequenceName);
        if (start != null) {
            stmt.append(" START WITH " + start);
        }
        if (increment != null) {
            stmt.append(" INCREMENT BY " + increment);
        }
        if (min != null) {
            stmt.append(" MINVALUE " + min);
        }
        if (max != null) {
            stmt.append(" MAXVALUE " + max);
        }
        if (cacheSize != null) {
            stmt.append(" CACHE " + cacheSize);
        } else {
            stmt.append(" CACHE 1");
        }
        return stmt.toString();
    }

    @Override
    public String getSequenceNextStmt(String sequenceName) {
        if (this.datastoreMajorVersion < 11) {
            return super.getSequenceNextStmt(sequenceName);
        }
        if (sequenceName == null) {
            throw new NucleusUserException(Localiser.msg((String)"051028"));
        }
        StringBuilder stmt = new StringBuilder("SELECT NEXT VALUE FOR ");
        stmt.append(sequenceName);
        return stmt.toString();
    }

    @Override
    public Class<? extends SQLOperation> getSQLOperationClass(String operationName) {
        if ("concat".equals(operationName)) {
            return Concat2Operation.class;
        }
        return super.getSQLOperationClass(operationName);
    }

    @Override
    public Class<? extends SQLMethod> getSQLMethodClass(String className, String methodName, ClassLoaderResolver clr) {
        if (className == null) {
            if ("SQL_cube".equals(methodName)) {
                return SQLCubeFunction.class;
            }
            if ("SQL_rollup".equals(methodName)) {
                return SQLRollupFunction.class;
            }
            if ("DAY_OF_WEEK".equals(methodName)) {
                return TemporalDayOfWeekMethod4.class;
            }
            if ("HOUR".equals(methodName)) {
                return TemporalHourMethod4.class;
            }
            if ("MINUTE".equals(methodName)) {
                return TemporalMinuteMethod4.class;
            }
            if ("SECOND".equals(methodName)) {
                return TemporalSecondMethod4.class;
            }
            if ("WEEK".equals(methodName)) {
                return TemporalWeekMethod4.class;
            }
            if ("QUARTER".equals(methodName)) {
                return TemporalQuarterMethod4.class;
            }
        } else {
            Class cls = null;
            try {
                cls = clr.classForName(className);
            }
            catch (ClassNotResolvedException classNotResolvedException) {
                // empty catch block
            }
            if ("java.lang.String".equals(className)) {
                if ("concat".equals(methodName)) {
                    return StringConcat2Method.class;
                }
                if ("indexOf".equals(methodName)) {
                    return StringIndexOf4Method.class;
                }
                if ("length".equals(methodName)) {
                    return StringLength4Method.class;
                }
                if ("startsWith".equals(methodName)) {
                    return StringStartsWith2Method.class;
                }
                if ("substring".equals(methodName)) {
                    return StringSubstring4Method.class;
                }
                if ("trim".equals(methodName)) {
                    return StringTrim2Method.class;
                }
            } else if ("java.util.Date".equals(className) || cls != null && java.util.Date.class.isAssignableFrom(cls)) {
                if ("getDayOfWeek".equals(methodName)) {
                    return TemporalDayOfWeekMethod4.class;
                }
                if ("getHour".equals(methodName)) {
                    return TemporalHourMethod4.class;
                }
                if ("getMinute".equals(methodName)) {
                    return TemporalMinuteMethod4.class;
                }
                if ("getSecond".equals(methodName)) {
                    return TemporalSecondMethod4.class;
                }
            } else if ("java.time.LocalTime".equals(className)) {
                if ("getHour".equals(methodName)) {
                    return TemporalHourMethod4.class;
                }
                if ("getMinute".equals(methodName)) {
                    return TemporalMinuteMethod4.class;
                }
                if ("getSecond".equals(methodName)) {
                    return TemporalSecondMethod4.class;
                }
            } else {
                if ("java.time.LocalDate".equals(className) && "getDayOfWeek".equals(methodName)) {
                    return TemporalDayOfWeekMethod4.class;
                }
                if ("java.time.LocalDateTime".equals(className)) {
                    if ("getDayOfWeek".equals(methodName)) {
                        return TemporalDayOfWeekMethod4.class;
                    }
                    if ("getHour".equals(methodName)) {
                        return TemporalHourMethod4.class;
                    }
                    if ("getMinute".equals(methodName)) {
                        return TemporalMinuteMethod4.class;
                    }
                    if ("getSecond".equals(methodName)) {
                        return TemporalSecondMethod4.class;
                    }
                }
            }
        }
        return super.getSQLMethodClass(className, methodName, clr);
    }

    @Override
    protected void loadColumnMappings(PluginManager mgr, ClassLoaderResolver clr) {
        this.registerColumnMapping(Boolean.class.getName(), BitColumnMapping.class, JDBCType.BIT, "BIT", true);
        this.registerColumnMapping(Boolean.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerColumnMapping(Boolean.class.getName(), BooleanColumnMapping.class, JDBCType.BOOLEAN, "BOOLEAN", false);
        this.registerColumnMapping(Boolean.class.getName(), SmallIntColumnMapping.class, JDBCType.SMALLINT, "SMALLINT", false);
        this.registerColumnMapping(Byte.class.getName(), SmallIntColumnMapping.class, JDBCType.SMALLINT, "SMALLINT", false);
        this.registerColumnMapping(Character.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", true);
        this.registerColumnMapping(Character.class.getName(), IntegerColumnMapping.class, JDBCType.INTEGER, "INT", false);
        this.registerColumnMapping(Double.class.getName(), FloatColumnMapping.class, JDBCType.FLOAT, "FLOAT", true);
        this.registerColumnMapping(Double.class.getName(), DoubleColumnMapping.class, JDBCType.DOUBLE, "FLOAT", false);
        this.registerColumnMapping(Double.class.getName(), DecimalColumnMapping.class, JDBCType.DECIMAL, "DECIMAL", false);
        this.registerColumnMapping(Float.class.getName(), FloatColumnMapping.class, JDBCType.FLOAT, "FLOAT", true);
        this.registerColumnMapping(Float.class.getName(), RealColumnMapping.class, JDBCType.REAL, "REAL", false);
        this.registerColumnMapping(Float.class.getName(), DecimalColumnMapping.class, JDBCType.DECIMAL, "DECIMAL", false);
        this.registerColumnMapping(Integer.class.getName(), IntegerColumnMapping.class, JDBCType.INTEGER, "INT", true);
        this.registerColumnMapping(Integer.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerColumnMapping(Integer.class.getName(), NumericColumnMapping.class, JDBCType.NUMERIC, "NUMERIC", false);
        this.registerColumnMapping(Integer.class.getName(), SmallIntColumnMapping.class, JDBCType.SMALLINT, "SMALLINT", false);
        this.registerColumnMapping(Long.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "BIGINT", true);
        this.registerColumnMapping(Long.class.getName(), IntegerColumnMapping.class, JDBCType.INTEGER, "INT", false);
        this.registerColumnMapping(Long.class.getName(), NumericColumnMapping.class, JDBCType.NUMERIC, "NUMERIC", false);
        this.registerColumnMapping(Long.class.getName(), SmallIntColumnMapping.class, JDBCType.SMALLINT, "SMALLINT", false);
        this.registerColumnMapping(Short.class.getName(), SmallIntColumnMapping.class, JDBCType.SMALLINT, "SMALLINT", true);
        this.registerColumnMapping(Short.class.getName(), IntegerColumnMapping.class, JDBCType.INTEGER, "INT", false);
        this.registerColumnMapping(String.class.getName(), VarCharColumnMapping.class, JDBCType.VARCHAR, "VARCHAR", true);
        this.registerColumnMapping(String.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerColumnMapping(String.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerColumnMapping(String.class.getName(), LongVarcharColumnMapping.class, JDBCType.LONGVARCHAR, "LONGVARCHAR", false);
        this.registerColumnMapping(String.class.getName(), ClobColumnMapping.class, JDBCType.CLOB, "CLOB", false);
        this.registerColumnMapping(String.class.getName(), BlobColumnMapping.class, JDBCType.BLOB, "BLOB", false);
        this.registerColumnMapping(String.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "UNIQUEIDENTIFIER", false);
        this.registerColumnMapping(String.class.getName(), NVarcharColumnMapping.class, JDBCType.NVARCHAR, "NVARCHAR", false);
        this.registerColumnMapping(String.class.getName(), NCharColumnMapping.class, JDBCType.NCHAR, "NCHAR", false);
        this.registerColumnMapping(BigDecimal.class.getName(), DecimalColumnMapping.class, JDBCType.DECIMAL, "DECIMAL", true);
        this.registerColumnMapping(BigDecimal.class.getName(), NumericColumnMapping.class, JDBCType.NUMERIC, "NUMERIC", false);
        this.registerColumnMapping(BigInteger.class.getName(), NumericColumnMapping.class, JDBCType.NUMERIC, "NUMERIC", true);
        this.registerColumnMapping(BigInteger.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerColumnMapping(Date.class.getName(), DateColumnMapping.class, JDBCType.DATE, "DATE", true);
        this.registerColumnMapping(Date.class.getName(), TimestampColumnMapping.class, JDBCType.TIMESTAMP, "TIMESTAMP", false);
        this.registerColumnMapping(Date.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerColumnMapping(Date.class.getName(), VarCharColumnMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        this.registerColumnMapping(Date.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerColumnMapping(Time.class.getName(), TimeColumnMapping.class, JDBCType.TIME, "TIME", true);
        this.registerColumnMapping(Time.class.getName(), TimestampColumnMapping.class, JDBCType.TIMESTAMP, "TIMESTAMP", false);
        this.registerColumnMapping(Time.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerColumnMapping(Time.class.getName(), VarCharColumnMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        this.registerColumnMapping(Time.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerColumnMapping(Timestamp.class.getName(), TimestampColumnMapping.class, JDBCType.TIMESTAMP, "TIMESTAMP", true);
        this.registerColumnMapping(Timestamp.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerColumnMapping(Timestamp.class.getName(), VarCharColumnMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        this.registerColumnMapping(Timestamp.class.getName(), DateColumnMapping.class, JDBCType.DATE, "DATE", false);
        this.registerColumnMapping(Timestamp.class.getName(), TimeColumnMapping.class, JDBCType.TIME, "TIME", false);
        this.registerColumnMapping(java.util.Date.class.getName(), TimestampColumnMapping.class, JDBCType.TIMESTAMP, "TIMESTAMP", true);
        this.registerColumnMapping(java.util.Date.class.getName(), DateColumnMapping.class, JDBCType.DATE, "DATE", false);
        this.registerColumnMapping(java.util.Date.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerColumnMapping(java.util.Date.class.getName(), VarCharColumnMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        this.registerColumnMapping(java.util.Date.class.getName(), TimeColumnMapping.class, JDBCType.TIME, "TIME", false);
        this.registerColumnMapping(java.util.Date.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "BIGINT", false);
        this.registerColumnMapping(Serializable.class.getName(), VarBinaryColumnMapping.class, JDBCType.VARBINARY, "VARBINARY", true);
        this.registerColumnMapping(Serializable.class.getName(), BlobColumnMapping.class, JDBCType.BLOB, "BLOB", false);
        this.registerColumnMapping(Serializable.class.getName(), LongVarBinaryColumnMapping.class, JDBCType.LONGVARBINARY, "LONGVARBINARY", false);
        this.registerColumnMapping(byte[].class.getName(), VarBinaryColumnMapping.class, JDBCType.VARBINARY, "VARBINARY", true);
        this.registerColumnMapping(byte[].class.getName(), BlobColumnMapping.class, JDBCType.BLOB, "BLOB", false);
        this.registerColumnMapping(byte[].class.getName(), VarBinaryColumnMapping.class, JDBCType.VARBINARY, "VARBINARY", false);
        this.registerColumnMapping(byte[].class.getName(), LongVarBinaryColumnMapping.class, JDBCType.LONGVARBINARY, "LONGVARBINARY", false);
        this.registerColumnMapping(File.class.getName(), BinaryStreamColumnMapping.class, JDBCType.LONGVARBINARY, "LONGVARBINARY", true);
        this.registerColumnMapping(DatastoreId.class.getName(), BigIntColumnMapping.class, JDBCType.BIGINT, "BIGINT", true);
        this.registerColumnMapping(DatastoreId.class.getName(), NumericColumnMapping.class, JDBCType.NUMERIC, "NUMERIC", false);
        this.registerColumnMapping(DatastoreId.class.getName(), CharColumnMapping.class, JDBCType.CHAR, "CHAR", false);
        this.registerColumnMapping(DatastoreId.class.getName(), VarCharColumnMapping.class, JDBCType.VARCHAR, "VARCHAR", false);
        this.registerColumnMapping(DatastoreId.class.getName(), IntegerColumnMapping.class, JDBCType.INTEGER, "INT", false);
        super.loadColumnMappings(mgr, clr);
    }
}

