/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.ServletSecurity;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletServerBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServletServerBuilder.class);
    private final Configuration configuration;
    private final Map<Servlet, Descriptor> descriptorsMap = new IdentityHashMap<Servlet, Descriptor>();

    public ServletServerBuilder(Configuration conf) {
        this.configuration = conf;
    }

    @SafeVarargs
    public static ServletServerBuilder builder(Configuration conf, Function<Configuration, Descriptor> ... describe) {
        ArrayList descriptors = new ArrayList();
        Arrays.asList(describe).forEach(functor -> {
            Descriptor descriptor = (Descriptor)functor.apply(conf);
            if (descriptor != null) {
                descriptors.add(descriptor);
            }
        });
        if (!descriptors.isEmpty()) {
            ServletServerBuilder builder = new ServletServerBuilder(conf);
            descriptors.forEach(builder::addServlet);
            return builder;
        }
        return null;
    }

    @SafeVarargs
    public static Server startServer(Logger logger, Configuration conf, Function<Configuration, Descriptor> ... describe) {
        return Objects.requireNonNull(ServletServerBuilder.builder(conf, describe)).start(logger);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Descriptor addServlet(int port, String path, HttpServlet servlet) {
        Descriptor descriptor = new Descriptor(port, path, servlet);
        return this.addServlet(descriptor);
    }

    public Descriptor addServlet(Descriptor descriptor) {
        if (descriptor != null) {
            this.descriptorsMap.put((Servlet)descriptor.getServlet(), descriptor);
        }
        return descriptor;
    }

    private Server createServer() {
        int maxThreads = MetastoreConf.getIntVar((Configuration)this.configuration, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HTTPSERVER_THREADPOOL_MAX);
        int minThreads = MetastoreConf.getIntVar((Configuration)this.configuration, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HTTPSERVER_THREADPOOL_MIN);
        int idleTimeout = MetastoreConf.getIntVar((Configuration)this.configuration, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HTTPSERVER_THREADPOOL_IDLE);
        QueuedThreadPool threadPool = new QueuedThreadPool(maxThreads, minThreads, idleTimeout);
        Server server = new Server((ThreadPool)threadPool);
        server.setStopAtShutdown(true);
        return server;
    }

    private ServerConnector createConnector(Server server, SslContextFactory sslContextFactory, int port) {
        ServerConnector connector;
        HttpConfiguration httpConf = new HttpConfiguration();
        httpConf.setSendServerVersion(false);
        httpConf.setSendXPoweredBy(false);
        if (sslContextFactory != null) {
            httpConf.setSecureScheme("https");
            httpConf.setSecurePort(port);
            httpConf.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            connector = new ServerConnector(server, sslContextFactory, new ConnectionFactory[]{new HttpConnectionFactory(httpConf)});
            connector.setName("https");
        } else {
            connector = new ServerConnector(server, new ConnectionFactory[]{new HttpConnectionFactory(httpConf)});
            connector.setName("http");
        }
        connector.setPort(port);
        connector.setReuseAddress(true);
        return connector;
    }

    private void addServlet(Map<Integer, ServletContextHandler> handlersMap, Descriptor descriptor) {
        int port = descriptor.getPort();
        String path = descriptor.getPath();
        HttpServlet servlet = descriptor.getServlet();
        int key = port < 0 ? -1 - handlersMap.size() : port;
        ServletContextHandler handler = handlersMap.computeIfAbsent(key, p -> {
            ServletContextHandler servletHandler = new ServletContextHandler(0);
            servletHandler.setContextPath("/");
            servletHandler.setGzipHandler(new GzipHandler());
            return servletHandler;
        });
        ServletHolder servletHolder = new ServletHolder((Servlet)servlet);
        servletHolder.setInitParameter("javax.ws.rs.Application", "ServiceListPublic");
        handler.addServlet(servletHolder, "/" + path + "/*");
    }

    public Server startServer() throws Exception {
        HashMap<Integer, ServletContextHandler> handlersMap = new HashMap<Integer, ServletContextHandler>();
        for (Descriptor descriptor : this.descriptorsMap.values()) {
            this.addServlet(handlersMap, descriptor);
        }
        int size = handlersMap.size();
        if (size == 0) {
            return null;
        }
        Server server = this.createServer();
        SslContextFactory sslContextFactory = ServletSecurity.createSslContextFactory(this.configuration);
        ServerConnector[] connectors = new ServerConnector[size];
        ServletContextHandler[] handlers = new ServletContextHandler[size];
        Iterator it = handlersMap.entrySet().iterator();
        int c = 0;
        while (it.hasNext()) {
            ServletContextHandler handler;
            Map.Entry entry = it.next();
            int key = (Integer)entry.getKey();
            int port = Math.max(key, 0);
            ServerConnector connector = this.createConnector(server, sslContextFactory, port);
            LOGGER.info("Adding {} servlet connector on port {}", (Object)connector.getName(), (Object)port);
            connectors[c] = connector;
            handlers[c] = handler = (ServletContextHandler)entry.getValue();
            String host = "hms" + c;
            connector.setName(host);
            handler.setVirtualHosts(new String[]{"@" + host});
            ++c;
        }
        server.setConnectors((Connector[])connectors);
        ContextHandlerCollection portHandler = new ContextHandlerCollection();
        portHandler.setHandlers((Handler[])handlers);
        server.setHandler((Handler)portHandler);
        server.start();
        for (int i = 0; i < connectors.length; ++i) {
            ServletHolder[] holders;
            int port = connectors[i].getLocalPort();
            ServletContextHandler handler = handlers[i];
            for (ServletHolder holder : holders = handler.getServletHandler().getServlets()) {
                Descriptor descriptor;
                Servlet servlet = holder.getServletInstance();
                if (servlet == null || (descriptor = this.descriptorsMap.get(servlet)) == null) continue;
                descriptor.setPort(port);
            }
        }
        return server;
    }

    public Server start(Logger logger) {
        try {
            Server server = this.startServer();
            if (server != null) {
                if (!server.isStarted()) {
                    logger.error("Unable to start servlet server on {}", (Object)server.getURI());
                } else {
                    this.descriptorsMap.values().forEach(descriptor -> logger.info("Started {} servlet on {}:{}", new Object[]{descriptor, descriptor.getPort(), descriptor.getPath()}));
                }
            }
            return server;
        }
        catch (Exception e) {
            logger.error("Unable to start servlet server", (Throwable)e);
            return null;
        }
    }

    public static class Descriptor {
        private final String path;
        private final HttpServlet servlet;
        private int port;

        public Descriptor(int port, String path, HttpServlet servlet) {
            this.port = port;
            this.path = path;
            this.servlet = servlet;
        }

        public String toString() {
            Object name = null;
            try {
                name = this.servlet.getServletName() + ":" + this.port + "/" + this.path;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            if (name == null) {
                name = this.servlet.getClass().getSimpleName();
            }
            return (String)name + ":" + this.port + "/" + this.path;
        }

        public int getPort() {
            return this.port;
        }

        void setPort(int port) {
            this.port = port;
        }

        public String getPath() {
            return this.path;
        }

        public HttpServlet getServlet() {
            return this.servlet;
        }
    }
}

