/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HMSHandler;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.ServletSecurity;
import org.apache.hadoop.hive.metastore.ServletServerBuilder;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.properties.PropertyException;
import org.apache.hadoop.hive.metastore.properties.PropertyManager;
import org.apache.hadoop.hive.metastore.properties.PropertyStore;
import org.eclipse.jetty.server.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyServlet
extends HttpServlet {
    private static final String PTYERROR = "Property-maps servlet error ";
    public static final Logger LOGGER = LoggerFactory.getLogger(PropertyServlet.class);
    private final Configuration configuration;

    PropertyServlet(Configuration configuration) {
        this.configuration = configuration;
    }

    public String getServletName() {
        return "HMS Property";
    }

    private String strError(String msg, Object ... args) {
        return String.format(PTYERROR + msg, args);
    }

    private void sendError(HttpServletResponse response, Exception any, String msg) {
        int code = 500;
        if (any instanceof PropertyException || any instanceof NoSuchObjectException) {
            code = 400;
        }
        this.sendError(response, code, msg);
    }

    private void sendError(HttpServletResponse response, int code, String msg) {
        try {
            response.sendError(code, msg);
        }
        catch (IOException ioeXception) {
            LOGGER.error(this.strError("sending error", new Object[0]), (Throwable)ioeXception);
            response.setStatus(code);
        }
    }

    private String getNamespace(String ruri) {
        int index = ruri.lastIndexOf("/");
        if (index > 1) {
            return ruri.substring(index + 1);
        }
        return "";
    }

    private RawStore getMS() throws ServletException {
        try {
            return HMSHandler.newRawStoreForConf(this.configuration);
        }
        catch (MetaException exception) {
            throw new ServletException((Throwable)exception);
        }
    }

    private PropertyManager getPropertyManager(RawStore store, String ns) throws ServletException {
        try {
            PropertyStore propertyStore = store.getPropertyStore();
            return PropertyManager.create((String)ns, (PropertyStore)propertyStore);
        }
        catch (MetaException | NoSuchObjectException exception) {
            throw new ServletException(exception);
        }
    }

    private Object readJson(HttpServletRequest request) throws ServletException {
        Object object;
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream(), StandardCharsets.UTF_8));
        try {
            object = new Gson().fromJson((Reader)reader, Object.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JsonIOException | JsonSyntaxException | IOException e) {
                throw new ServletException(e);
            }
        }
        ((Reader)reader).close();
        return object;
    }

    private void writeJson(HttpServletResponse response, Object value) throws IOException {
        ServletOutputStream outputStream = response.getOutputStream();
        response.setStatus(200);
        PrintWriter writer = new PrintWriter((OutputStream)outputStream);
        writer.write(new Gson().toJson(value));
        writer.flush();
    }

    public void init() throws ServletException {
        super.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        RawStore ms = this.getMS();
        String ns = this.getNamespace(request.getRequestURI());
        try {
            PropertyManager mgr = this.getPropertyManager(ms, ns);
            Object json = this.readJson(request);
            List<Object> actions = json instanceof List ? (List<Object>)json : Collections.singletonList(json);
            ArrayList<Object> reactions = new ArrayList<Object>();
            String method = null;
            try {
                block17: for (Object t : actions) {
                    if (!(t instanceof Map)) continue;
                    Map call = (Map)t;
                    method = (String)call.get("method");
                    if (method == null) {
                        method = "selectProperties";
                    }
                    switch (method) {
                        case "fetchProperties": {
                            PropertyServlet.fetchProperties(mgr, call, reactions);
                            continue block17;
                        }
                        case "selectProperties": {
                            PropertyServlet.selectProperties(mgr, call, reactions);
                            continue block17;
                        }
                        case "script": {
                            String src = (String)call.get("source");
                            reactions.add(mgr.runScript(src));
                            continue block17;
                        }
                        case "echo": {
                            reactions.add(t);
                            continue block17;
                        }
                    }
                    throw new IllegalArgumentException("Bad argument type " + String.valueOf(t.getClass()));
                }
                mgr.commit();
                this.writeJson(response, reactions.size() > 1 ? reactions : reactions.get(0));
                response.setStatus(200);
            }
            catch (Exception any) {
                String string = this.strError("fetching values with %s, (%s) %s", method != null ? method : "?", any.getClass().getSimpleName(), any.getMessage());
                LOGGER.error(string, (Throwable)any);
                this.sendError(response, any, string);
                mgr.rollback();
            }
        }
        finally {
            ms.shutdown();
        }
    }

    private static void fetchProperties(PropertyManager mgr, Map<String, Object> call, List<Object> reactions) {
        Object jsonKeys = call.get("keys");
        if (jsonKeys == null) {
            throw new IllegalArgumentException("null keys");
        }
        List<Object> keys = jsonKeys instanceof List ? (List<Object>)jsonKeys : Collections.singletonList(jsonKeys);
        TreeMap<String, String> properties = new TreeMap<String, String>();
        for (Object t : keys) {
            String key = t.toString();
            String value = mgr.exportPropertyValue(key);
            if (value == null) continue;
            properties.put(key, value);
        }
        reactions.add(properties);
    }

    private static void selectProperties(PropertyManager mgr, Map<String, Object> call, List<Object> reactions) {
        String prefix = (String)call.get("prefix");
        if (prefix == null) {
            throw new IllegalArgumentException("null prefix");
        }
        String predicate = (String)call.get("predicate");
        Object selection = call.get("selection");
        List<String> project = selection == null ? null : (selection instanceof List ? (List<String>)selection : Collections.singletonList(selection.toString()));
        Map selected = mgr.selectProperties(prefix, predicate, project);
        TreeMap returned = new TreeMap();
        selected.forEach((k, v) -> returned.put(k, v.export(project == null)));
        reactions.add(returned);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String ns = this.getNamespace(request.getRequestURI());
        RawStore ms = this.getMS();
        try {
            PropertyManager mgr = this.getPropertyManager(ms, ns);
            Object json = this.readJson(request);
            if (json instanceof Map) {
                try {
                    Map cast = (Map)json;
                    mgr.setProperties(cast);
                    mgr.commit();
                    response.setStatus(200);
                }
                catch (Exception any) {
                    String error = this.strError("setting values (%s) %s", any.getClass().getSimpleName(), any.getMessage());
                    LOGGER.error(error, (Throwable)any);
                    this.sendError(response, any, error);
                    mgr.rollback();
                }
            } else {
                String error = this.strError("setting values, bad argument type %s", json.getClass());
                LOGGER.error(error);
                this.sendError(response, 400, error);
            }
        }
        finally {
            ms.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String ns = this.getNamespace(request.getRequestURI());
        RawStore ms = this.getMS();
        try {
            PropertyManager mgr = this.getPropertyManager(ms, ns);
            try {
                String[] keys = request.getParameterValues("key");
                if (keys == null) {
                    throw new IllegalArgumentException("null key");
                }
                TreeMap<String, String> properties = new TreeMap<String, String>();
                for (String action : keys) {
                    String key = action.toString();
                    String value = mgr.exportPropertyValue(key);
                    if (value == null) continue;
                    properties.put(key, value);
                }
                mgr.commit();
                this.writeJson(response, properties);
                response.setStatus(200);
            }
            catch (Exception any) {
                mgr.rollback();
                String error = this.strError("getting values (%s) %s", any.getClass().getSimpleName(), any.getMessage());
                LOGGER.error(error, (Throwable)any);
                this.sendError(response, any, error);
            }
        }
        finally {
            ms.shutdown();
        }
    }

    public static ServletServerBuilder.Descriptor createServlet(Configuration configuration) {
        try {
            int port = MetastoreConf.getIntVar((Configuration)configuration, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.PROPERTIES_SERVLET_PORT);
            String path = MetastoreConf.getVar((Configuration)configuration, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.PROPERTIES_SERVLET_PATH);
            if (port >= 0 && path != null && !path.isEmpty()) {
                String authType = MetastoreConf.getVar((Configuration)configuration, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.PROPERTIES_SERVLET_AUTH);
                ServletSecurity security = new ServletSecurity(ServletSecurity.AuthType.fromString(authType), configuration);
                HttpServlet servlet = security.proxy(new PropertyServlet(configuration));
                return new ServletServerBuilder.Descriptor(port, path, servlet);
            }
        }
        catch (Exception io) {
            LOGGER.error("Failed to create servlet ", (Throwable)io);
        }
        return null;
    }

    public static Server startServer(Configuration conf) throws Exception {
        return ServletServerBuilder.startServer(LOGGER, conf, PropertyServlet::createServlet);
    }
}

